package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AssignedLabel;
import odata.msgraph.client.beta.complex.AssignedLicense;
import odata.msgraph.client.beta.complex.EvaluateDynamicMembershipResult;
import odata.msgraph.client.beta.complex.LicenseProcessingState;
import odata.msgraph.client.beta.complex.OnPremisesProvisioningError;
import odata.msgraph.client.beta.entity.collection.request.AppRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationThreadCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectorySettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EndpointCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupLifecyclePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProfilePhotoCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ResourceSpecificPermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SiteCollectionRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.OnenoteRequest;
import odata.msgraph.client.beta.entity.request.PlannerGroupRequest;
import odata.msgraph.client.beta.entity.request.ProfilePhotoRequest;
import odata.msgraph.client.beta.entity.request.TeamRequest;
import odata.msgraph.client.beta.enums.GroupAccessType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
 * <p>
 * Supported = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "assignedLabels", 
    "assignedLicenses", 
    "classification", 
    "createdByAppId", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "expirationDateTime", 
    "groupTypes", 
    "hasMembersWithLicenseErrors", 
    "infoCatalogs", 
    "isAssignableToRole", 
    "licenseProcessingState", 
    "mail", 
    "mailEnabled", 
    "mailNickname", 
    "mdmAppId", 
    "membershipRule", 
    "membershipRuleProcessingState", 
    "onPremisesDomainName", 
    "onPremisesLastSyncDateTime", 
    "onPremisesNetBiosName", 
    "onPremisesProvisioningErrors", 
    "onPremisesSamAccountName", 
    "onPremisesSecurityIdentifier", 
    "onPremisesSyncEnabled", 
    "preferredDataLocation", 
    "preferredLanguage", 
    "proxyAddresses", 
    "renewedDateTime", 
    "resourceBehaviorOptions", 
    "resourceProvisioningOptions", 
    "securityEnabled", 
    "securityIdentifier", 
    "theme", 
    "visibility", 
    "accessType", 
    "allowExternalSenders", 
    "autoSubscribeNewMembers", 
    "isFavorite", 
    "isSubscribedByMail", 
    "unseenCount", 
    "unseenConversationsCount", 
    "unseenMessagesCount", 
    "hideFromOutlookClients", 
    "hideFromAddressLists", 
    "isArchived"})
@JsonInclude(Include.NON_NULL)
public class Group extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.group";
    }

    @JsonProperty("assignedLabels")
    protected List<AssignedLabel> assignedLabels;

    @JsonProperty("assignedLabels@nextLink")
    protected String assignedLabelsNextLink;

    @JsonProperty("assignedLicenses")
    protected List<AssignedLicense> assignedLicenses;

    @JsonProperty("assignedLicenses@nextLink")
    protected String assignedLicensesNextLink;

    @JsonProperty("classification")
    protected String classification;

    @JsonProperty("createdByAppId")
    protected String createdByAppId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("groupTypes")
    protected List<String> groupTypes;

    @JsonProperty("groupTypes@nextLink")
    protected String groupTypesNextLink;

    @JsonProperty("hasMembersWithLicenseErrors")
    protected Boolean hasMembersWithLicenseErrors;

    @JsonProperty("infoCatalogs")
    protected List<String> infoCatalogs;

    @JsonProperty("infoCatalogs@nextLink")
    protected String infoCatalogsNextLink;

    @JsonProperty("isAssignableToRole")
    protected Boolean isAssignableToRole;

    @JsonProperty("licenseProcessingState")
    protected LicenseProcessingState licenseProcessingState;

    @JsonProperty("mail")
    protected String mail;

    @JsonProperty("mailEnabled")
    protected Boolean mailEnabled;

    @JsonProperty("mailNickname")
    protected String mailNickname;

    @JsonProperty("mdmAppId")
    protected String mdmAppId;

    @JsonProperty("membershipRule")
    protected String membershipRule;

    @JsonProperty("membershipRuleProcessingState")
    protected String membershipRuleProcessingState;

    @JsonProperty("onPremisesDomainName")
    protected String onPremisesDomainName;

    @JsonProperty("onPremisesLastSyncDateTime")
    protected OffsetDateTime onPremisesLastSyncDateTime;

    @JsonProperty("onPremisesNetBiosName")
    protected String onPremisesNetBiosName;

    @JsonProperty("onPremisesProvisioningErrors")
    protected List<OnPremisesProvisioningError> onPremisesProvisioningErrors;

    @JsonProperty("onPremisesProvisioningErrors@nextLink")
    protected String onPremisesProvisioningErrorsNextLink;

    @JsonProperty("onPremisesSamAccountName")
    protected String onPremisesSamAccountName;

    @JsonProperty("onPremisesSecurityIdentifier")
    protected String onPremisesSecurityIdentifier;

    @JsonProperty("onPremisesSyncEnabled")
    protected Boolean onPremisesSyncEnabled;

    @JsonProperty("preferredDataLocation")
    protected String preferredDataLocation;

    @JsonProperty("preferredLanguage")
    protected String preferredLanguage;

    @JsonProperty("proxyAddresses")
    protected List<String> proxyAddresses;

    @JsonProperty("proxyAddresses@nextLink")
    protected String proxyAddressesNextLink;

    @JsonProperty("renewedDateTime")
    protected OffsetDateTime renewedDateTime;

    @JsonProperty("resourceBehaviorOptions")
    protected List<String> resourceBehaviorOptions;

    @JsonProperty("resourceBehaviorOptions@nextLink")
    protected String resourceBehaviorOptionsNextLink;

    @JsonProperty("resourceProvisioningOptions")
    protected List<String> resourceProvisioningOptions;

    @JsonProperty("resourceProvisioningOptions@nextLink")
    protected String resourceProvisioningOptionsNextLink;

    @JsonProperty("securityEnabled")
    protected Boolean securityEnabled;

    @JsonProperty("securityIdentifier")
    protected String securityIdentifier;

    @JsonProperty("theme")
    protected String theme;

    @JsonProperty("visibility")
    protected String visibility;

    @JsonProperty("accessType")
    protected GroupAccessType accessType;

    @JsonProperty("allowExternalSenders")
    protected Boolean allowExternalSenders;

    @JsonProperty("autoSubscribeNewMembers")
    protected Boolean autoSubscribeNewMembers;

    @JsonProperty("isFavorite")
    protected Boolean isFavorite;

    @JsonProperty("isSubscribedByMail")
    protected Boolean isSubscribedByMail;

    @JsonProperty("unseenCount")
    protected Integer unseenCount;

    @JsonProperty("unseenConversationsCount")
    protected Integer unseenConversationsCount;

    @JsonProperty("unseenMessagesCount")
    protected Integer unseenMessagesCount;

    @JsonProperty("hideFromOutlookClients")
    protected Boolean hideFromOutlookClients;

    @JsonProperty("hideFromAddressLists")
    protected Boolean hideFromAddressLists;

    @JsonProperty("isArchived")
    protected Boolean isArchived;

    protected Group() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private List<AssignedLabel> assignedLabels;
        private String assignedLabelsNextLink;
        private List<AssignedLicense> assignedLicenses;
        private String assignedLicensesNextLink;
        private String classification;
        private String createdByAppId;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime expirationDateTime;
        private List<String> groupTypes;
        private String groupTypesNextLink;
        private Boolean hasMembersWithLicenseErrors;
        private List<String> infoCatalogs;
        private String infoCatalogsNextLink;
        private Boolean isAssignableToRole;
        private LicenseProcessingState licenseProcessingState;
        private String mail;
        private Boolean mailEnabled;
        private String mailNickname;
        private String mdmAppId;
        private String membershipRule;
        private String membershipRuleProcessingState;
        private String onPremisesDomainName;
        private OffsetDateTime onPremisesLastSyncDateTime;
        private String onPremisesNetBiosName;
        private List<OnPremisesProvisioningError> onPremisesProvisioningErrors;
        private String onPremisesProvisioningErrorsNextLink;
        private String onPremisesSamAccountName;
        private String onPremisesSecurityIdentifier;
        private Boolean onPremisesSyncEnabled;
        private String preferredDataLocation;
        private String preferredLanguage;
        private List<String> proxyAddresses;
        private String proxyAddressesNextLink;
        private OffsetDateTime renewedDateTime;
        private List<String> resourceBehaviorOptions;
        private String resourceBehaviorOptionsNextLink;
        private List<String> resourceProvisioningOptions;
        private String resourceProvisioningOptionsNextLink;
        private Boolean securityEnabled;
        private String securityIdentifier;
        private String theme;
        private String visibility;
        private GroupAccessType accessType;
        private Boolean allowExternalSenders;
        private Boolean autoSubscribeNewMembers;
        private Boolean isFavorite;
        private Boolean isSubscribedByMail;
        private Integer unseenCount;
        private Integer unseenConversationsCount;
        private Integer unseenMessagesCount;
        private Boolean hideFromOutlookClients;
        private Boolean hideFromAddressLists;
        private Boolean isArchived;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder assignedLabels(List<AssignedLabel> assignedLabels) {
            this.assignedLabels = assignedLabels;
            this.changedFields = changedFields.add("assignedLabels");
            return this;
        }

        public Builder assignedLabels(AssignedLabel... assignedLabels) {
            return assignedLabels(Arrays.asList(assignedLabels));
        }

        public Builder assignedLabelsNextLink(String assignedLabelsNextLink) {
            this.assignedLabelsNextLink = assignedLabelsNextLink;
            this.changedFields = changedFields.add("assignedLabels");
            return this;
        }

        public Builder assignedLicenses(List<AssignedLicense> assignedLicenses) {
            this.assignedLicenses = assignedLicenses;
            this.changedFields = changedFields.add("assignedLicenses");
            return this;
        }

        public Builder assignedLicenses(AssignedLicense... assignedLicenses) {
            return assignedLicenses(Arrays.asList(assignedLicenses));
        }

        public Builder assignedLicensesNextLink(String assignedLicensesNextLink) {
            this.assignedLicensesNextLink = assignedLicensesNextLink;
            this.changedFields = changedFields.add("assignedLicenses");
            return this;
        }

        public Builder classification(String classification) {
            this.classification = classification;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public Builder createdByAppId(String createdByAppId) {
            this.createdByAppId = createdByAppId;
            this.changedFields = changedFields.add("createdByAppId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder groupTypes(List<String> groupTypes) {
            this.groupTypes = groupTypes;
            this.changedFields = changedFields.add("groupTypes");
            return this;
        }

        public Builder groupTypes(String... groupTypes) {
            return groupTypes(Arrays.asList(groupTypes));
        }

        public Builder groupTypesNextLink(String groupTypesNextLink) {
            this.groupTypesNextLink = groupTypesNextLink;
            this.changedFields = changedFields.add("groupTypes");
            return this;
        }

        public Builder hasMembersWithLicenseErrors(Boolean hasMembersWithLicenseErrors) {
            this.hasMembersWithLicenseErrors = hasMembersWithLicenseErrors;
            this.changedFields = changedFields.add("hasMembersWithLicenseErrors");
            return this;
        }

        public Builder infoCatalogs(List<String> infoCatalogs) {
            this.infoCatalogs = infoCatalogs;
            this.changedFields = changedFields.add("infoCatalogs");
            return this;
        }

        public Builder infoCatalogs(String... infoCatalogs) {
            return infoCatalogs(Arrays.asList(infoCatalogs));
        }

        public Builder infoCatalogsNextLink(String infoCatalogsNextLink) {
            this.infoCatalogsNextLink = infoCatalogsNextLink;
            this.changedFields = changedFields.add("infoCatalogs");
            return this;
        }

        public Builder isAssignableToRole(Boolean isAssignableToRole) {
            this.isAssignableToRole = isAssignableToRole;
            this.changedFields = changedFields.add("isAssignableToRole");
            return this;
        }

        public Builder licenseProcessingState(LicenseProcessingState licenseProcessingState) {
            this.licenseProcessingState = licenseProcessingState;
            this.changedFields = changedFields.add("licenseProcessingState");
            return this;
        }

        public Builder mail(String mail) {
            this.mail = mail;
            this.changedFields = changedFields.add("mail");
            return this;
        }

        public Builder mailEnabled(Boolean mailEnabled) {
            this.mailEnabled = mailEnabled;
            this.changedFields = changedFields.add("mailEnabled");
            return this;
        }

        public Builder mailNickname(String mailNickname) {
            this.mailNickname = mailNickname;
            this.changedFields = changedFields.add("mailNickname");
            return this;
        }

        public Builder mdmAppId(String mdmAppId) {
            this.mdmAppId = mdmAppId;
            this.changedFields = changedFields.add("mdmAppId");
            return this;
        }

        public Builder membershipRule(String membershipRule) {
            this.membershipRule = membershipRule;
            this.changedFields = changedFields.add("membershipRule");
            return this;
        }

        public Builder membershipRuleProcessingState(String membershipRuleProcessingState) {
            this.membershipRuleProcessingState = membershipRuleProcessingState;
            this.changedFields = changedFields.add("membershipRuleProcessingState");
            return this;
        }

        public Builder onPremisesDomainName(String onPremisesDomainName) {
            this.onPremisesDomainName = onPremisesDomainName;
            this.changedFields = changedFields.add("onPremisesDomainName");
            return this;
        }

        public Builder onPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
            this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            this.changedFields = changedFields.add("onPremisesLastSyncDateTime");
            return this;
        }

        public Builder onPremisesNetBiosName(String onPremisesNetBiosName) {
            this.onPremisesNetBiosName = onPremisesNetBiosName;
            this.changedFields = changedFields.add("onPremisesNetBiosName");
            return this;
        }

        public Builder onPremisesProvisioningErrors(List<OnPremisesProvisioningError> onPremisesProvisioningErrors) {
            this.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
            this.changedFields = changedFields.add("onPremisesProvisioningErrors");
            return this;
        }

        public Builder onPremisesProvisioningErrors(OnPremisesProvisioningError... onPremisesProvisioningErrors) {
            return onPremisesProvisioningErrors(Arrays.asList(onPremisesProvisioningErrors));
        }

        public Builder onPremisesProvisioningErrorsNextLink(String onPremisesProvisioningErrorsNextLink) {
            this.onPremisesProvisioningErrorsNextLink = onPremisesProvisioningErrorsNextLink;
            this.changedFields = changedFields.add("onPremisesProvisioningErrors");
            return this;
        }

        public Builder onPremisesSamAccountName(String onPremisesSamAccountName) {
            this.onPremisesSamAccountName = onPremisesSamAccountName;
            this.changedFields = changedFields.add("onPremisesSamAccountName");
            return this;
        }

        public Builder onPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
            this.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
            this.changedFields = changedFields.add("onPremisesSecurityIdentifier");
            return this;
        }

        public Builder onPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
            this.onPremisesSyncEnabled = onPremisesSyncEnabled;
            this.changedFields = changedFields.add("onPremisesSyncEnabled");
            return this;
        }

        public Builder preferredDataLocation(String preferredDataLocation) {
            this.preferredDataLocation = preferredDataLocation;
            this.changedFields = changedFields.add("preferredDataLocation");
            return this;
        }

        public Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            this.changedFields = changedFields.add("preferredLanguage");
            return this;
        }

        public Builder proxyAddresses(List<String> proxyAddresses) {
            this.proxyAddresses = proxyAddresses;
            this.changedFields = changedFields.add("proxyAddresses");
            return this;
        }

        public Builder proxyAddresses(String... proxyAddresses) {
            return proxyAddresses(Arrays.asList(proxyAddresses));
        }

        public Builder proxyAddressesNextLink(String proxyAddressesNextLink) {
            this.proxyAddressesNextLink = proxyAddressesNextLink;
            this.changedFields = changedFields.add("proxyAddresses");
            return this;
        }

        public Builder renewedDateTime(OffsetDateTime renewedDateTime) {
            this.renewedDateTime = renewedDateTime;
            this.changedFields = changedFields.add("renewedDateTime");
            return this;
        }

        public Builder resourceBehaviorOptions(List<String> resourceBehaviorOptions) {
            this.resourceBehaviorOptions = resourceBehaviorOptions;
            this.changedFields = changedFields.add("resourceBehaviorOptions");
            return this;
        }

        public Builder resourceBehaviorOptions(String... resourceBehaviorOptions) {
            return resourceBehaviorOptions(Arrays.asList(resourceBehaviorOptions));
        }

        public Builder resourceBehaviorOptionsNextLink(String resourceBehaviorOptionsNextLink) {
            this.resourceBehaviorOptionsNextLink = resourceBehaviorOptionsNextLink;
            this.changedFields = changedFields.add("resourceBehaviorOptions");
            return this;
        }

        public Builder resourceProvisioningOptions(List<String> resourceProvisioningOptions) {
            this.resourceProvisioningOptions = resourceProvisioningOptions;
            this.changedFields = changedFields.add("resourceProvisioningOptions");
            return this;
        }

        public Builder resourceProvisioningOptions(String... resourceProvisioningOptions) {
            return resourceProvisioningOptions(Arrays.asList(resourceProvisioningOptions));
        }

        public Builder resourceProvisioningOptionsNextLink(String resourceProvisioningOptionsNextLink) {
            this.resourceProvisioningOptionsNextLink = resourceProvisioningOptionsNextLink;
            this.changedFields = changedFields.add("resourceProvisioningOptions");
            return this;
        }

        public Builder securityEnabled(Boolean securityEnabled) {
            this.securityEnabled = securityEnabled;
            this.changedFields = changedFields.add("securityEnabled");
            return this;
        }

        public Builder securityIdentifier(String securityIdentifier) {
            this.securityIdentifier = securityIdentifier;
            this.changedFields = changedFields.add("securityIdentifier");
            return this;
        }

        public Builder theme(String theme) {
            this.theme = theme;
            this.changedFields = changedFields.add("theme");
            return this;
        }

        public Builder visibility(String visibility) {
            this.visibility = visibility;
            this.changedFields = changedFields.add("visibility");
            return this;
        }

        public Builder accessType(GroupAccessType accessType) {
            this.accessType = accessType;
            this.changedFields = changedFields.add("accessType");
            return this;
        }

        public Builder allowExternalSenders(Boolean allowExternalSenders) {
            this.allowExternalSenders = allowExternalSenders;
            this.changedFields = changedFields.add("allowExternalSenders");
            return this;
        }

        public Builder autoSubscribeNewMembers(Boolean autoSubscribeNewMembers) {
            this.autoSubscribeNewMembers = autoSubscribeNewMembers;
            this.changedFields = changedFields.add("autoSubscribeNewMembers");
            return this;
        }

        public Builder isFavorite(Boolean isFavorite) {
            this.isFavorite = isFavorite;
            this.changedFields = changedFields.add("isFavorite");
            return this;
        }

        public Builder isSubscribedByMail(Boolean isSubscribedByMail) {
            this.isSubscribedByMail = isSubscribedByMail;
            this.changedFields = changedFields.add("isSubscribedByMail");
            return this;
        }

        public Builder unseenCount(Integer unseenCount) {
            this.unseenCount = unseenCount;
            this.changedFields = changedFields.add("unseenCount");
            return this;
        }

        public Builder unseenConversationsCount(Integer unseenConversationsCount) {
            this.unseenConversationsCount = unseenConversationsCount;
            this.changedFields = changedFields.add("unseenConversationsCount");
            return this;
        }

        public Builder unseenMessagesCount(Integer unseenMessagesCount) {
            this.unseenMessagesCount = unseenMessagesCount;
            this.changedFields = changedFields.add("unseenMessagesCount");
            return this;
        }

        public Builder hideFromOutlookClients(Boolean hideFromOutlookClients) {
            this.hideFromOutlookClients = hideFromOutlookClients;
            this.changedFields = changedFields.add("hideFromOutlookClients");
            return this;
        }

        public Builder hideFromAddressLists(Boolean hideFromAddressLists) {
            this.hideFromAddressLists = hideFromAddressLists;
            this.changedFields = changedFields.add("hideFromAddressLists");
            return this;
        }

        public Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            this.changedFields = changedFields.add("isArchived");
            return this;
        }

        public Group build() {
            Group _x = new Group();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.group";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.assignedLabels = assignedLabels;
            _x.assignedLabelsNextLink = assignedLabelsNextLink;
            _x.assignedLicenses = assignedLicenses;
            _x.assignedLicensesNextLink = assignedLicensesNextLink;
            _x.classification = classification;
            _x.createdByAppId = createdByAppId;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.expirationDateTime = expirationDateTime;
            _x.groupTypes = groupTypes;
            _x.groupTypesNextLink = groupTypesNextLink;
            _x.hasMembersWithLicenseErrors = hasMembersWithLicenseErrors;
            _x.infoCatalogs = infoCatalogs;
            _x.infoCatalogsNextLink = infoCatalogsNextLink;
            _x.isAssignableToRole = isAssignableToRole;
            _x.licenseProcessingState = licenseProcessingState;
            _x.mail = mail;
            _x.mailEnabled = mailEnabled;
            _x.mailNickname = mailNickname;
            _x.mdmAppId = mdmAppId;
            _x.membershipRule = membershipRule;
            _x.membershipRuleProcessingState = membershipRuleProcessingState;
            _x.onPremisesDomainName = onPremisesDomainName;
            _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            _x.onPremisesNetBiosName = onPremisesNetBiosName;
            _x.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
            _x.onPremisesProvisioningErrorsNextLink = onPremisesProvisioningErrorsNextLink;
            _x.onPremisesSamAccountName = onPremisesSamAccountName;
            _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
            _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
            _x.preferredDataLocation = preferredDataLocation;
            _x.preferredLanguage = preferredLanguage;
            _x.proxyAddresses = proxyAddresses;
            _x.proxyAddressesNextLink = proxyAddressesNextLink;
            _x.renewedDateTime = renewedDateTime;
            _x.resourceBehaviorOptions = resourceBehaviorOptions;
            _x.resourceBehaviorOptionsNextLink = resourceBehaviorOptionsNextLink;
            _x.resourceProvisioningOptions = resourceProvisioningOptions;
            _x.resourceProvisioningOptionsNextLink = resourceProvisioningOptionsNextLink;
            _x.securityEnabled = securityEnabled;
            _x.securityIdentifier = securityIdentifier;
            _x.theme = theme;
            _x.visibility = visibility;
            _x.accessType = accessType;
            _x.allowExternalSenders = allowExternalSenders;
            _x.autoSubscribeNewMembers = autoSubscribeNewMembers;
            _x.isFavorite = isFavorite;
            _x.isSubscribedByMail = isSubscribedByMail;
            _x.unseenCount = unseenCount;
            _x.unseenConversationsCount = unseenConversationsCount;
            _x.unseenMessagesCount = unseenMessagesCount;
            _x.hideFromOutlookClients = hideFromOutlookClients;
            _x.hideFromAddressLists = hideFromAddressLists;
            _x.isArchived = isArchived;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="assignedLabels")
    @JsonIgnore
    public CollectionPage<AssignedLabel> getAssignedLabels() {
        return new CollectionPage<AssignedLabel>(contextPath, AssignedLabel.class, assignedLabels, Optional.ofNullable(assignedLabelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedLabels")
    @JsonIgnore
    public CollectionPage<AssignedLabel> getAssignedLabels(HttpRequestOptions options) {
        return new CollectionPage<AssignedLabel>(contextPath, AssignedLabel.class, assignedLabels, Optional.ofNullable(assignedLabelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="assignedLicenses")
    @JsonIgnore
    public CollectionPage<AssignedLicense> getAssignedLicenses() {
        return new CollectionPage<AssignedLicense>(contextPath, AssignedLicense.class, assignedLicenses, Optional.ofNullable(assignedLicensesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedLicenses")
    @JsonIgnore
    public CollectionPage<AssignedLicense> getAssignedLicenses(HttpRequestOptions options) {
        return new CollectionPage<AssignedLicense>(contextPath, AssignedLicense.class, assignedLicenses, Optional.ofNullable(assignedLicensesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="classification")
    @JsonIgnore
    public Optional<String> getClassification() {
        return Optional.ofNullable(classification);
    }

    public Group withClassification(String classification) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("classification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.classification = classification;
        return _x;
    }

    @Property(name="createdByAppId")
    @JsonIgnore
    public Optional<String> getCreatedByAppId() {
        return Optional.ofNullable(createdByAppId);
    }

    public Group withCreatedByAppId(String createdByAppId) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("createdByAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.createdByAppId = createdByAppId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Group withCreatedDateTime(OffsetDateTime createdDateTime) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Group withDescription(String description) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Group withDisplayName(String displayName) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public Group withExpirationDateTime(OffsetDateTime expirationDateTime) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="groupTypes")
    @JsonIgnore
    public CollectionPage<String> getGroupTypes() {
        return new CollectionPage<String>(contextPath, String.class, groupTypes, Optional.ofNullable(groupTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="groupTypes")
    @JsonIgnore
    public CollectionPage<String> getGroupTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, groupTypes, Optional.ofNullable(groupTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="hasMembersWithLicenseErrors")
    @JsonIgnore
    public Optional<Boolean> getHasMembersWithLicenseErrors() {
        return Optional.ofNullable(hasMembersWithLicenseErrors);
    }

    public Group withHasMembersWithLicenseErrors(Boolean hasMembersWithLicenseErrors) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("hasMembersWithLicenseErrors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.hasMembersWithLicenseErrors = hasMembersWithLicenseErrors;
        return _x;
    }

    @Property(name="infoCatalogs")
    @JsonIgnore
    public CollectionPage<String> getInfoCatalogs() {
        return new CollectionPage<String>(contextPath, String.class, infoCatalogs, Optional.ofNullable(infoCatalogsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="infoCatalogs")
    @JsonIgnore
    public CollectionPage<String> getInfoCatalogs(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, infoCatalogs, Optional.ofNullable(infoCatalogsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="isAssignableToRole")
    @JsonIgnore
    public Optional<Boolean> getIsAssignableToRole() {
        return Optional.ofNullable(isAssignableToRole);
    }

    public Group withIsAssignableToRole(Boolean isAssignableToRole) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("isAssignableToRole");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.isAssignableToRole = isAssignableToRole;
        return _x;
    }

    @Property(name="licenseProcessingState")
    @JsonIgnore
    public Optional<LicenseProcessingState> getLicenseProcessingState() {
        return Optional.ofNullable(licenseProcessingState);
    }

    public Group withLicenseProcessingState(LicenseProcessingState licenseProcessingState) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("licenseProcessingState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.licenseProcessingState = licenseProcessingState;
        return _x;
    }

    @Property(name="mail")
    @JsonIgnore
    public Optional<String> getMail() {
        return Optional.ofNullable(mail);
    }

    public Group withMail(String mail) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("mail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.mail = mail;
        return _x;
    }

    @Property(name="mailEnabled")
    @JsonIgnore
    public Optional<Boolean> getMailEnabled() {
        return Optional.ofNullable(mailEnabled);
    }

    public Group withMailEnabled(Boolean mailEnabled) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("mailEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.mailEnabled = mailEnabled;
        return _x;
    }

    @Property(name="mailNickname")
    @JsonIgnore
    public Optional<String> getMailNickname() {
        return Optional.ofNullable(mailNickname);
    }

    public Group withMailNickname(String mailNickname) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("mailNickname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.mailNickname = mailNickname;
        return _x;
    }

    @Property(name="mdmAppId")
    @JsonIgnore
    public Optional<String> getMdmAppId() {
        return Optional.ofNullable(mdmAppId);
    }

    public Group withMdmAppId(String mdmAppId) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("mdmAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.mdmAppId = mdmAppId;
        return _x;
    }

    @Property(name="membershipRule")
    @JsonIgnore
    public Optional<String> getMembershipRule() {
        return Optional.ofNullable(membershipRule);
    }

    public Group withMembershipRule(String membershipRule) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("membershipRule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.membershipRule = membershipRule;
        return _x;
    }

    @Property(name="membershipRuleProcessingState")
    @JsonIgnore
    public Optional<String> getMembershipRuleProcessingState() {
        return Optional.ofNullable(membershipRuleProcessingState);
    }

    public Group withMembershipRuleProcessingState(String membershipRuleProcessingState) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("membershipRuleProcessingState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.membershipRuleProcessingState = membershipRuleProcessingState;
        return _x;
    }

    @Property(name="onPremisesDomainName")
    @JsonIgnore
    public Optional<String> getOnPremisesDomainName() {
        return Optional.ofNullable(onPremisesDomainName);
    }

    public Group withOnPremisesDomainName(String onPremisesDomainName) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("onPremisesDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.onPremisesDomainName = onPremisesDomainName;
        return _x;
    }

    @Property(name="onPremisesLastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOnPremisesLastSyncDateTime() {
        return Optional.ofNullable(onPremisesLastSyncDateTime);
    }

    public Group withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("onPremisesLastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return _x;
    }

    @Property(name="onPremisesNetBiosName")
    @JsonIgnore
    public Optional<String> getOnPremisesNetBiosName() {
        return Optional.ofNullable(onPremisesNetBiosName);
    }

    public Group withOnPremisesNetBiosName(String onPremisesNetBiosName) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("onPremisesNetBiosName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.onPremisesNetBiosName = onPremisesNetBiosName;
        return _x;
    }

    @Property(name="onPremisesProvisioningErrors")
    @JsonIgnore
    public CollectionPage<OnPremisesProvisioningError> getOnPremisesProvisioningErrors() {
        return new CollectionPage<OnPremisesProvisioningError>(contextPath, OnPremisesProvisioningError.class, onPremisesProvisioningErrors, Optional.ofNullable(onPremisesProvisioningErrorsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="onPremisesProvisioningErrors")
    @JsonIgnore
    public CollectionPage<OnPremisesProvisioningError> getOnPremisesProvisioningErrors(HttpRequestOptions options) {
        return new CollectionPage<OnPremisesProvisioningError>(contextPath, OnPremisesProvisioningError.class, onPremisesProvisioningErrors, Optional.ofNullable(onPremisesProvisioningErrorsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="onPremisesSamAccountName")
    @JsonIgnore
    public Optional<String> getOnPremisesSamAccountName() {
        return Optional.ofNullable(onPremisesSamAccountName);
    }

    public Group withOnPremisesSamAccountName(String onPremisesSamAccountName) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSamAccountName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.onPremisesSamAccountName = onPremisesSamAccountName;
        return _x;
    }

    @Property(name="onPremisesSecurityIdentifier")
    @JsonIgnore
    public Optional<String> getOnPremisesSecurityIdentifier() {
        return Optional.ofNullable(onPremisesSecurityIdentifier);
    }

    public Group withOnPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSecurityIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        return _x;
    }

    @Property(name="onPremisesSyncEnabled")
    @JsonIgnore
    public Optional<Boolean> getOnPremisesSyncEnabled() {
        return Optional.ofNullable(onPremisesSyncEnabled);
    }

    public Group withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSyncEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return _x;
    }

    @Property(name="preferredDataLocation")
    @JsonIgnore
    public Optional<String> getPreferredDataLocation() {
        return Optional.ofNullable(preferredDataLocation);
    }

    public Group withPreferredDataLocation(String preferredDataLocation) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("preferredDataLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.preferredDataLocation = preferredDataLocation;
        return _x;
    }

    @Property(name="preferredLanguage")
    @JsonIgnore
    public Optional<String> getPreferredLanguage() {
        return Optional.ofNullable(preferredLanguage);
    }

    public Group withPreferredLanguage(String preferredLanguage) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("preferredLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.preferredLanguage = preferredLanguage;
        return _x;
    }

    @Property(name="proxyAddresses")
    @JsonIgnore
    public CollectionPage<String> getProxyAddresses() {
        return new CollectionPage<String>(contextPath, String.class, proxyAddresses, Optional.ofNullable(proxyAddressesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="proxyAddresses")
    @JsonIgnore
    public CollectionPage<String> getProxyAddresses(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, proxyAddresses, Optional.ofNullable(proxyAddressesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="renewedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRenewedDateTime() {
        return Optional.ofNullable(renewedDateTime);
    }

    public Group withRenewedDateTime(OffsetDateTime renewedDateTime) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("renewedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.renewedDateTime = renewedDateTime;
        return _x;
    }

    @Property(name="resourceBehaviorOptions")
    @JsonIgnore
    public CollectionPage<String> getResourceBehaviorOptions() {
        return new CollectionPage<String>(contextPath, String.class, resourceBehaviorOptions, Optional.ofNullable(resourceBehaviorOptionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="resourceBehaviorOptions")
    @JsonIgnore
    public CollectionPage<String> getResourceBehaviorOptions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, resourceBehaviorOptions, Optional.ofNullable(resourceBehaviorOptionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="resourceProvisioningOptions")
    @JsonIgnore
    public CollectionPage<String> getResourceProvisioningOptions() {
        return new CollectionPage<String>(contextPath, String.class, resourceProvisioningOptions, Optional.ofNullable(resourceProvisioningOptionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="resourceProvisioningOptions")
    @JsonIgnore
    public CollectionPage<String> getResourceProvisioningOptions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, resourceProvisioningOptions, Optional.ofNullable(resourceProvisioningOptionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="securityEnabled")
    @JsonIgnore
    public Optional<Boolean> getSecurityEnabled() {
        return Optional.ofNullable(securityEnabled);
    }

    public Group withSecurityEnabled(Boolean securityEnabled) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("securityEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.securityEnabled = securityEnabled;
        return _x;
    }

    @Property(name="securityIdentifier")
    @JsonIgnore
    public Optional<String> getSecurityIdentifier() {
        return Optional.ofNullable(securityIdentifier);
    }

    public Group withSecurityIdentifier(String securityIdentifier) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("securityIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.securityIdentifier = securityIdentifier;
        return _x;
    }

    @Property(name="theme")
    @JsonIgnore
    public Optional<String> getTheme() {
        return Optional.ofNullable(theme);
    }

    public Group withTheme(String theme) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("theme");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.theme = theme;
        return _x;
    }

    @Property(name="visibility")
    @JsonIgnore
    public Optional<String> getVisibility() {
        return Optional.ofNullable(visibility);
    }

    public Group withVisibility(String visibility) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("visibility");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.visibility = visibility;
        return _x;
    }

    @Property(name="accessType")
    @JsonIgnore
    public Optional<GroupAccessType> getAccessType() {
        return Optional.ofNullable(accessType);
    }

    public Group withAccessType(GroupAccessType accessType) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("accessType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.accessType = accessType;
        return _x;
    }

    @Property(name="allowExternalSenders")
    @JsonIgnore
    public Optional<Boolean> getAllowExternalSenders() {
        return Optional.ofNullable(allowExternalSenders);
    }

    public Group withAllowExternalSenders(Boolean allowExternalSenders) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("allowExternalSenders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.allowExternalSenders = allowExternalSenders;
        return _x;
    }

    @Property(name="autoSubscribeNewMembers")
    @JsonIgnore
    public Optional<Boolean> getAutoSubscribeNewMembers() {
        return Optional.ofNullable(autoSubscribeNewMembers);
    }

    public Group withAutoSubscribeNewMembers(Boolean autoSubscribeNewMembers) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("autoSubscribeNewMembers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.autoSubscribeNewMembers = autoSubscribeNewMembers;
        return _x;
    }

    @Property(name="isFavorite")
    @JsonIgnore
    public Optional<Boolean> getIsFavorite() {
        return Optional.ofNullable(isFavorite);
    }

    public Group withIsFavorite(Boolean isFavorite) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("isFavorite");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.isFavorite = isFavorite;
        return _x;
    }

    @Property(name="isSubscribedByMail")
    @JsonIgnore
    public Optional<Boolean> getIsSubscribedByMail() {
        return Optional.ofNullable(isSubscribedByMail);
    }

    public Group withIsSubscribedByMail(Boolean isSubscribedByMail) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("isSubscribedByMail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.isSubscribedByMail = isSubscribedByMail;
        return _x;
    }

    @Property(name="unseenCount")
    @JsonIgnore
    public Optional<Integer> getUnseenCount() {
        return Optional.ofNullable(unseenCount);
    }

    public Group withUnseenCount(Integer unseenCount) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("unseenCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.unseenCount = unseenCount;
        return _x;
    }

    @Property(name="unseenConversationsCount")
    @JsonIgnore
    public Optional<Integer> getUnseenConversationsCount() {
        return Optional.ofNullable(unseenConversationsCount);
    }

    public Group withUnseenConversationsCount(Integer unseenConversationsCount) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("unseenConversationsCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.unseenConversationsCount = unseenConversationsCount;
        return _x;
    }

    @Property(name="unseenMessagesCount")
    @JsonIgnore
    public Optional<Integer> getUnseenMessagesCount() {
        return Optional.ofNullable(unseenMessagesCount);
    }

    public Group withUnseenMessagesCount(Integer unseenMessagesCount) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("unseenMessagesCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.unseenMessagesCount = unseenMessagesCount;
        return _x;
    }

    @Property(name="hideFromOutlookClients")
    @JsonIgnore
    public Optional<Boolean> getHideFromOutlookClients() {
        return Optional.ofNullable(hideFromOutlookClients);
    }

    public Group withHideFromOutlookClients(Boolean hideFromOutlookClients) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("hideFromOutlookClients");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.hideFromOutlookClients = hideFromOutlookClients;
        return _x;
    }

    @Property(name="hideFromAddressLists")
    @JsonIgnore
    public Optional<Boolean> getHideFromAddressLists() {
        return Optional.ofNullable(hideFromAddressLists);
    }

    public Group withHideFromAddressLists(Boolean hideFromAddressLists) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("hideFromAddressLists");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.hideFromAddressLists = hideFromAddressLists;
        return _x;
    }

    @Property(name="isArchived")
    @JsonIgnore
    public Optional<Boolean> getIsArchived() {
        return Optional.ofNullable(isArchived);
    }

    public Group withIsArchived(Boolean isArchived) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("isArchived");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.group");
        _x.isArchived = isArchived;
        return _x;
    }

    @NavigationProperty(name="appRoleAssignments")
    @JsonIgnore
    public AppRoleAssignmentCollectionRequest getAppRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignments"));
    }

    @NavigationProperty(name="members")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getMembers() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("members"));
    }

    @NavigationProperty(name="membersWithLicenseErrors")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getMembersWithLicenseErrors() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("membersWithLicenseErrors"));
    }

    @NavigationProperty(name="memberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"));
    }

    @NavigationProperty(name="transitiveMembers")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getTransitiveMembers() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMembers"));
    }

    @NavigationProperty(name="transitiveMemberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getTransitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"));
    }

    @NavigationProperty(name="createdOnBehalfOf")
    @JsonIgnore
    public DirectoryObjectRequest getCreatedOnBehalfOf() {
        return new DirectoryObjectRequest(contextPath.addSegment("createdOnBehalfOf"));
    }

    @NavigationProperty(name="owners")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getOwners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("owners"));
    }

    @NavigationProperty(name="settings")
    @JsonIgnore
    public DirectorySettingCollectionRequest getSettings() {
        return new DirectorySettingCollectionRequest(
                        contextPath.addSegment("settings"));
    }

    @NavigationProperty(name="endpoints")
    @JsonIgnore
    public EndpointCollectionRequest getEndpoints() {
        return new EndpointCollectionRequest(
                        contextPath.addSegment("endpoints"));
    }

    @NavigationProperty(name="permissionGrants")
    @JsonIgnore
    public ResourceSpecificPermissionGrantCollectionRequest getPermissionGrants() {
        return new ResourceSpecificPermissionGrantCollectionRequest(
                        contextPath.addSegment("permissionGrants"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property conversations
     */
    @NavigationProperty(name="conversations")
    @JsonIgnore
    public ConversationCollectionRequest getConversations() {
        return new ConversationCollectionRequest(
                        contextPath.addSegment("conversations"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property photos
     */
    @NavigationProperty(name="photos")
    @JsonIgnore
    public ProfilePhotoCollectionRequest getPhotos() {
        return new ProfilePhotoCollectionRequest(
                        contextPath.addSegment("photos"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property acceptedSenders
     */
    @NavigationProperty(name="acceptedSenders")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getAcceptedSenders() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("acceptedSenders"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property rejectedSenders
     */
    @NavigationProperty(name="rejectedSenders")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getRejectedSenders() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("rejectedSenders"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property threads
     */
    @NavigationProperty(name="threads")
    @JsonIgnore
    public ConversationThreadCollectionRequest getThreads() {
        return new ConversationThreadCollectionRequest(
                        contextPath.addSegment("threads"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property calendar
     */
    @NavigationProperty(name="calendar")
    @JsonIgnore
    public CalendarRequest getCalendar() {
        return new CalendarRequest(contextPath.addSegment("calendar"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property calendarView
     */
    @NavigationProperty(name="calendarView")
    @JsonIgnore
    public EventCollectionRequest getCalendarView() {
        return new EventCollectionRequest(
                        contextPath.addSegment("calendarView"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property events
     */
    @NavigationProperty(name="events")
    @JsonIgnore
    public EventCollectionRequest getEvents() {
        return new EventCollectionRequest(
                        contextPath.addSegment("events"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property photo
     */
    @NavigationProperty(name="photo")
    @JsonIgnore
    public ProfilePhotoRequest getPhoto() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"));
    }

    @NavigationProperty(name="drive")
    @JsonIgnore
    public DriveRequest getDrive() {
        return new DriveRequest(contextPath.addSegment("drive"));
    }

    @NavigationProperty(name="drives")
    @JsonIgnore
    public DriveCollectionRequest getDrives() {
        return new DriveCollectionRequest(
                        contextPath.addSegment("drives"));
    }

    @NavigationProperty(name="sites")
    @JsonIgnore
    public SiteCollectionRequest getSites() {
        return new SiteCollectionRequest(
                        contextPath.addSegment("sites"));
    }

    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    @NavigationProperty(name="groupLifecyclePolicies")
    @JsonIgnore
    public GroupLifecyclePolicyCollectionRequest getGroupLifecyclePolicies() {
        return new GroupLifecyclePolicyCollectionRequest(
                        contextPath.addSegment("groupLifecyclePolicies"));
    }

    @NavigationProperty(name="planner")
    @JsonIgnore
    public PlannerGroupRequest getPlanner() {
        return new PlannerGroupRequest(contextPath.addSegment("planner"));
    }

    @NavigationProperty(name="onenote")
    @JsonIgnore
    public OnenoteRequest getOnenote() {
        return new OnenoteRequest(contextPath.addSegment("onenote"));
    }

    @NavigationProperty(name="team")
    @JsonIgnore
    public TeamRequest getTeam() {
        return new TeamRequest(contextPath.addSegment("team"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Group patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Group _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Group put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Group _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Group _copy() {
        Group _x = new Group();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.assignedLabels = assignedLabels;
        _x.assignedLicenses = assignedLicenses;
        _x.classification = classification;
        _x.createdByAppId = createdByAppId;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.expirationDateTime = expirationDateTime;
        _x.groupTypes = groupTypes;
        _x.hasMembersWithLicenseErrors = hasMembersWithLicenseErrors;
        _x.infoCatalogs = infoCatalogs;
        _x.isAssignableToRole = isAssignableToRole;
        _x.licenseProcessingState = licenseProcessingState;
        _x.mail = mail;
        _x.mailEnabled = mailEnabled;
        _x.mailNickname = mailNickname;
        _x.mdmAppId = mdmAppId;
        _x.membershipRule = membershipRule;
        _x.membershipRuleProcessingState = membershipRuleProcessingState;
        _x.onPremisesDomainName = onPremisesDomainName;
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        _x.onPremisesNetBiosName = onPremisesNetBiosName;
        _x.onPremisesProvisioningErrors = onPremisesProvisioningErrors;
        _x.onPremisesSamAccountName = onPremisesSamAccountName;
        _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        _x.preferredDataLocation = preferredDataLocation;
        _x.preferredLanguage = preferredLanguage;
        _x.proxyAddresses = proxyAddresses;
        _x.renewedDateTime = renewedDateTime;
        _x.resourceBehaviorOptions = resourceBehaviorOptions;
        _x.resourceProvisioningOptions = resourceProvisioningOptions;
        _x.securityEnabled = securityEnabled;
        _x.securityIdentifier = securityIdentifier;
        _x.theme = theme;
        _x.visibility = visibility;
        _x.accessType = accessType;
        _x.allowExternalSenders = allowExternalSenders;
        _x.autoSubscribeNewMembers = autoSubscribeNewMembers;
        _x.isFavorite = isFavorite;
        _x.isSubscribedByMail = isSubscribedByMail;
        _x.unseenCount = unseenCount;
        _x.unseenConversationsCount = unseenConversationsCount;
        _x.unseenMessagesCount = unseenMessagesCount;
        _x.hideFromOutlookClients = hideFromOutlookClients;
        _x.hideFromAddressLists = hideFromAddressLists;
        _x.isArchived = isArchived;
        return _x;
    }

    @Action(name = "validateProperties")
    @JsonIgnore
    public ActionRequestNoReturn validateProperties(String displayName, String mailNickname, String onBehalfOfUserId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("mailNickname", "Edm.String", Checks.checkIsAscii(mailNickname))
            .put("onBehalfOfUserId", "Edm.Guid", onBehalfOfUserId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validateProperties"), _parameters);
    }

    @Action(name = "checkGrantedPermissionsForApp")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ResourceSpecificPermissionGrant> checkGrantedPermissionsForApp() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.checkGrantedPermissionsForApp"), ResourceSpecificPermissionGrant.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "assignLicense")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Group> assignLicense(List<AssignedLicense> addLicenses, List<String> removeLicenses) {
        Preconditions.checkNotNull(addLicenses, "addLicenses cannot be null");
        Preconditions.checkNotNull(removeLicenses, "removeLicenses cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("addLicenses", "Collection(microsoft.graph.assignedLicense)", addLicenses)
            .put("removeLicenses", "Collection(Edm.Guid)", removeLicenses)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Group>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignLicense"), Group.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "subscribeByMail")
    @JsonIgnore
    public ActionRequestNoReturn subscribeByMail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.subscribeByMail"), _parameters);
    }

    @Action(name = "unsubscribeByMail")
    @JsonIgnore
    public ActionRequestNoReturn unsubscribeByMail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unsubscribeByMail"), _parameters);
    }

    @Action(name = "addFavorite")
    @JsonIgnore
    public ActionRequestNoReturn addFavorite() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addFavorite"), _parameters);
    }

    @Action(name = "removeFavorite")
    @JsonIgnore
    public ActionRequestNoReturn removeFavorite() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeFavorite"), _parameters);
    }

    @Action(name = "resetUnseenCount")
    @JsonIgnore
    public ActionRequestNoReturn resetUnseenCount() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetUnseenCount"), _parameters);
    }

    @Action(name = "renew")
    @JsonIgnore
    public ActionRequestNoReturn renew() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.renew"), _parameters);
    }

    @Action(name = "evaluateDynamicMembership")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EvaluateDynamicMembershipResult> evaluateDynamicMembership(String memberId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("memberId", "Edm.String", Checks.checkIsAscii(memberId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<EvaluateDynamicMembershipResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.evaluateDynamicMembership"), EvaluateDynamicMembershipResult.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Group[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("assignedLabels=");
        b.append(this.assignedLabels);
        b.append(", ");
        b.append("assignedLicenses=");
        b.append(this.assignedLicenses);
        b.append(", ");
        b.append("classification=");
        b.append(this.classification);
        b.append(", ");
        b.append("createdByAppId=");
        b.append(this.createdByAppId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("groupTypes=");
        b.append(this.groupTypes);
        b.append(", ");
        b.append("hasMembersWithLicenseErrors=");
        b.append(this.hasMembersWithLicenseErrors);
        b.append(", ");
        b.append("infoCatalogs=");
        b.append(this.infoCatalogs);
        b.append(", ");
        b.append("isAssignableToRole=");
        b.append(this.isAssignableToRole);
        b.append(", ");
        b.append("licenseProcessingState=");
        b.append(this.licenseProcessingState);
        b.append(", ");
        b.append("mail=");
        b.append(this.mail);
        b.append(", ");
        b.append("mailEnabled=");
        b.append(this.mailEnabled);
        b.append(", ");
        b.append("mailNickname=");
        b.append(this.mailNickname);
        b.append(", ");
        b.append("mdmAppId=");
        b.append(this.mdmAppId);
        b.append(", ");
        b.append("membershipRule=");
        b.append(this.membershipRule);
        b.append(", ");
        b.append("membershipRuleProcessingState=");
        b.append(this.membershipRuleProcessingState);
        b.append(", ");
        b.append("onPremisesDomainName=");
        b.append(this.onPremisesDomainName);
        b.append(", ");
        b.append("onPremisesLastSyncDateTime=");
        b.append(this.onPremisesLastSyncDateTime);
        b.append(", ");
        b.append("onPremisesNetBiosName=");
        b.append(this.onPremisesNetBiosName);
        b.append(", ");
        b.append("onPremisesProvisioningErrors=");
        b.append(this.onPremisesProvisioningErrors);
        b.append(", ");
        b.append("onPremisesSamAccountName=");
        b.append(this.onPremisesSamAccountName);
        b.append(", ");
        b.append("onPremisesSecurityIdentifier=");
        b.append(this.onPremisesSecurityIdentifier);
        b.append(", ");
        b.append("onPremisesSyncEnabled=");
        b.append(this.onPremisesSyncEnabled);
        b.append(", ");
        b.append("preferredDataLocation=");
        b.append(this.preferredDataLocation);
        b.append(", ");
        b.append("preferredLanguage=");
        b.append(this.preferredLanguage);
        b.append(", ");
        b.append("proxyAddresses=");
        b.append(this.proxyAddresses);
        b.append(", ");
        b.append("renewedDateTime=");
        b.append(this.renewedDateTime);
        b.append(", ");
        b.append("resourceBehaviorOptions=");
        b.append(this.resourceBehaviorOptions);
        b.append(", ");
        b.append("resourceProvisioningOptions=");
        b.append(this.resourceProvisioningOptions);
        b.append(", ");
        b.append("securityEnabled=");
        b.append(this.securityEnabled);
        b.append(", ");
        b.append("securityIdentifier=");
        b.append(this.securityIdentifier);
        b.append(", ");
        b.append("theme=");
        b.append(this.theme);
        b.append(", ");
        b.append("visibility=");
        b.append(this.visibility);
        b.append(", ");
        b.append("accessType=");
        b.append(this.accessType);
        b.append(", ");
        b.append("allowExternalSenders=");
        b.append(this.allowExternalSenders);
        b.append(", ");
        b.append("autoSubscribeNewMembers=");
        b.append(this.autoSubscribeNewMembers);
        b.append(", ");
        b.append("isFavorite=");
        b.append(this.isFavorite);
        b.append(", ");
        b.append("isSubscribedByMail=");
        b.append(this.isSubscribedByMail);
        b.append(", ");
        b.append("unseenCount=");
        b.append(this.unseenCount);
        b.append(", ");
        b.append("unseenConversationsCount=");
        b.append(this.unseenConversationsCount);
        b.append(", ");
        b.append("unseenMessagesCount=");
        b.append(this.unseenMessagesCount);
        b.append(", ");
        b.append("hideFromOutlookClients=");
        b.append(this.hideFromOutlookClients);
        b.append(", ");
        b.append("hideFromAddressLists=");
        b.append(this.hideFromAddressLists);
        b.append(", ");
        b.append("isArchived=");
        b.append(this.isArchived);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
