package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleSettingRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "resourceId", 
    "externalId", 
    "templateId", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class GovernanceRoleDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceRoleDefinition";
    }

    @JsonProperty("resourceId")
    protected String resourceId;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("templateId")
    protected String templateId;

    @JsonProperty("displayName")
    protected String displayName;

    protected GovernanceRoleDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGovernanceRoleDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String resourceId;
        private String externalId;
        private String templateId;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            this.changedFields = changedFields.add("templateId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public GovernanceRoleDefinition build() {
            GovernanceRoleDefinition _x = new GovernanceRoleDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.governanceRoleDefinition";
            _x.id = id;
            _x.resourceId = resourceId;
            _x.externalId = externalId;
            _x.templateId = templateId;
            _x.displayName = displayName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public GovernanceRoleDefinition withResourceId(String resourceId) {
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("resourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleDefinition");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public GovernanceRoleDefinition withExternalId(String externalId) {
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleDefinition");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="templateId")
    @JsonIgnore
    public Optional<String> getTemplateId() {
        return Optional.ofNullable(templateId);
    }

    public GovernanceRoleDefinition withTemplateId(String templateId) {
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("templateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleDefinition");
        _x.templateId = templateId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public GovernanceRoleDefinition withDisplayName(String displayName) {
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleDefinition");
        _x.displayName = displayName;
        return _x;
    }

    @NavigationProperty(name="resource")
    @JsonIgnore
    public GovernanceResourceRequest getResource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"));
    }

    @NavigationProperty(name="roleSetting")
    @JsonIgnore
    public GovernanceRoleSettingRequest getRoleSetting() {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("roleSetting"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceRoleDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceRoleDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GovernanceRoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GovernanceRoleDefinition _copy() {
        GovernanceRoleDefinition _x = new GovernanceRoleDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.resourceId = resourceId;
        _x.externalId = externalId;
        _x.templateId = templateId;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceRoleDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("templateId=");
        b.append(this.templateId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
