package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.GovernanceRoleAssignmentRequestStatus;
import odata.msgraph.client.beta.complex.GovernanceSchedule;
import odata.msgraph.client.beta.entity.request.GovernanceResourceRequest;
import odata.msgraph.client.beta.entity.request.GovernanceRoleDefinitionRequest;
import odata.msgraph.client.beta.entity.request.GovernanceSubjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "resourceId", 
    "roleDefinitionId", 
    "subjectId", 
    "linkedEligibleRoleAssignmentId", 
    "type", 
    "assignmentState", 
    "requestedDateTime", 
    "reason", 
    "status", 
    "schedule"})
@JsonInclude(Include.NON_NULL)
public class GovernanceRoleAssignmentRequest extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceRoleAssignmentRequest";
    }

    @JsonProperty("resourceId")
    protected String resourceId;

    @JsonProperty("roleDefinitionId")
    protected String roleDefinitionId;

    @JsonProperty("subjectId")
    protected String subjectId;

    @JsonProperty("linkedEligibleRoleAssignmentId")
    protected String linkedEligibleRoleAssignmentId;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("assignmentState")
    protected String assignmentState;

    @JsonProperty("requestedDateTime")
    protected OffsetDateTime requestedDateTime;

    @JsonProperty("reason")
    protected String reason;

    @JsonProperty("status")
    protected GovernanceRoleAssignmentRequestStatus status;

    @JsonProperty("schedule")
    protected GovernanceSchedule schedule;

    protected GovernanceRoleAssignmentRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGovernanceRoleAssignmentRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String resourceId;
        private String roleDefinitionId;
        private String subjectId;
        private String linkedEligibleRoleAssignmentId;
        private String type;
        private String assignmentState;
        private OffsetDateTime requestedDateTime;
        private String reason;
        private GovernanceRoleAssignmentRequestStatus status;
        private GovernanceSchedule schedule;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public Builder roleDefinitionId(String roleDefinitionId) {
            this.roleDefinitionId = roleDefinitionId;
            this.changedFields = changedFields.add("roleDefinitionId");
            return this;
        }

        public Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            this.changedFields = changedFields.add("subjectId");
            return this;
        }

        public Builder linkedEligibleRoleAssignmentId(String linkedEligibleRoleAssignmentId) {
            this.linkedEligibleRoleAssignmentId = linkedEligibleRoleAssignmentId;
            this.changedFields = changedFields.add("linkedEligibleRoleAssignmentId");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder assignmentState(String assignmentState) {
            this.assignmentState = assignmentState;
            this.changedFields = changedFields.add("assignmentState");
            return this;
        }

        public Builder requestedDateTime(OffsetDateTime requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
            this.changedFields = changedFields.add("requestedDateTime");
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            this.changedFields = changedFields.add("reason");
            return this;
        }

        public Builder status(GovernanceRoleAssignmentRequestStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder schedule(GovernanceSchedule schedule) {
            this.schedule = schedule;
            this.changedFields = changedFields.add("schedule");
            return this;
        }

        public GovernanceRoleAssignmentRequest build() {
            GovernanceRoleAssignmentRequest _x = new GovernanceRoleAssignmentRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.governanceRoleAssignmentRequest";
            _x.id = id;
            _x.resourceId = resourceId;
            _x.roleDefinitionId = roleDefinitionId;
            _x.subjectId = subjectId;
            _x.linkedEligibleRoleAssignmentId = linkedEligibleRoleAssignmentId;
            _x.type = type;
            _x.assignmentState = assignmentState;
            _x.requestedDateTime = requestedDateTime;
            _x.reason = reason;
            _x.status = status;
            _x.schedule = schedule;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public GovernanceRoleAssignmentRequest withResourceId(String resourceId) {
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("resourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequest");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="roleDefinitionId")
    @JsonIgnore
    public Optional<String> getRoleDefinitionId() {
        return Optional.ofNullable(roleDefinitionId);
    }

    public GovernanceRoleAssignmentRequest withRoleDefinitionId(String roleDefinitionId) {
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("roleDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequest");
        _x.roleDefinitionId = roleDefinitionId;
        return _x;
    }

    @Property(name="subjectId")
    @JsonIgnore
    public Optional<String> getSubjectId() {
        return Optional.ofNullable(subjectId);
    }

    public GovernanceRoleAssignmentRequest withSubjectId(String subjectId) {
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("subjectId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequest");
        _x.subjectId = subjectId;
        return _x;
    }

    @Property(name="linkedEligibleRoleAssignmentId")
    @JsonIgnore
    public Optional<String> getLinkedEligibleRoleAssignmentId() {
        return Optional.ofNullable(linkedEligibleRoleAssignmentId);
    }

    public GovernanceRoleAssignmentRequest withLinkedEligibleRoleAssignmentId(String linkedEligibleRoleAssignmentId) {
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("linkedEligibleRoleAssignmentId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequest");
        _x.linkedEligibleRoleAssignmentId = linkedEligibleRoleAssignmentId;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public GovernanceRoleAssignmentRequest withType(String type) {
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequest");
        _x.type = type;
        return _x;
    }

    @Property(name="assignmentState")
    @JsonIgnore
    public Optional<String> getAssignmentState() {
        return Optional.ofNullable(assignmentState);
    }

    public GovernanceRoleAssignmentRequest withAssignmentState(String assignmentState) {
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("assignmentState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequest");
        _x.assignmentState = assignmentState;
        return _x;
    }

    @Property(name="requestedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRequestedDateTime() {
        return Optional.ofNullable(requestedDateTime);
    }

    public GovernanceRoleAssignmentRequest withRequestedDateTime(OffsetDateTime requestedDateTime) {
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("requestedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequest");
        _x.requestedDateTime = requestedDateTime;
        return _x;
    }

    @Property(name="reason")
    @JsonIgnore
    public Optional<String> getReason() {
        return Optional.ofNullable(reason);
    }

    public GovernanceRoleAssignmentRequest withReason(String reason) {
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("reason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequest");
        _x.reason = reason;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<GovernanceRoleAssignmentRequestStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public GovernanceRoleAssignmentRequest withStatus(GovernanceRoleAssignmentRequestStatus status) {
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequest");
        _x.status = status;
        return _x;
    }

    @Property(name="schedule")
    @JsonIgnore
    public Optional<GovernanceSchedule> getSchedule() {
        return Optional.ofNullable(schedule);
    }

    public GovernanceRoleAssignmentRequest withSchedule(GovernanceSchedule schedule) {
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("schedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceRoleAssignmentRequest");
        _x.schedule = schedule;
        return _x;
    }

    @NavigationProperty(name="resource")
    @JsonIgnore
    public GovernanceResourceRequest getResource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"));
    }

    @NavigationProperty(name="roleDefinition")
    @JsonIgnore
    public GovernanceRoleDefinitionRequest getRoleDefinition() {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinition"));
    }

    @NavigationProperty(name="subject")
    @JsonIgnore
    public GovernanceSubjectRequest getSubject() {
        return new GovernanceSubjectRequest(contextPath.addSegment("subject"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceRoleAssignmentRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceRoleAssignmentRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GovernanceRoleAssignmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GovernanceRoleAssignmentRequest _copy() {
        GovernanceRoleAssignmentRequest _x = new GovernanceRoleAssignmentRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.resourceId = resourceId;
        _x.roleDefinitionId = roleDefinitionId;
        _x.subjectId = subjectId;
        _x.linkedEligibleRoleAssignmentId = linkedEligibleRoleAssignmentId;
        _x.type = type;
        _x.assignmentState = assignmentState;
        _x.requestedDateTime = requestedDateTime;
        _x.reason = reason;
        _x.status = status;
        _x.schedule = schedule;
        return _x;
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "updateRequest")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<GovernanceRoleAssignmentRequest> updateRequest(String decision, String assignmentState, GovernanceSchedule schedule, String reason) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("decision", "Edm.String", Checks.checkIsAscii(decision))
            .put("assignmentState", "Edm.String", Checks.checkIsAscii(assignmentState))
            .put("schedule", "microsoft.graph.governanceSchedule", schedule)
            .put("reason", "Edm.String", Checks.checkIsAscii(reason))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<GovernanceRoleAssignmentRequest>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateRequest"), GovernanceRoleAssignmentRequest.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceRoleAssignmentRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("roleDefinitionId=");
        b.append(this.roleDefinitionId);
        b.append(", ");
        b.append("subjectId=");
        b.append(this.subjectId);
        b.append(", ");
        b.append("linkedEligibleRoleAssignmentId=");
        b.append(this.linkedEligibleRoleAssignmentId);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("assignmentState=");
        b.append(this.assignmentState);
        b.append(", ");
        b.append("requestedDateTime=");
        b.append(this.requestedDateTime);
        b.append(", ");
        b.append("reason=");
        b.append(this.reason);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("schedule=");
        b.append(this.schedule);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
