package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AccountRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "postingDate", 
    "documentNumber", 
    "documentType", 
    "accountId", 
    "accountNumber", 
    "description", 
    "debitAmount", 
    "creditAmount", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class GeneralLedgerEntry extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.generalLedgerEntry";
    }

    @JsonProperty("postingDate")
    protected LocalDate postingDate;

    @JsonProperty("documentNumber")
    protected String documentNumber;

    @JsonProperty("documentType")
    protected String documentType;

    @JsonProperty("accountId")
    protected String accountId;

    @JsonProperty("accountNumber")
    protected String accountNumber;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("debitAmount")
    protected BigDecimal debitAmount;

    @JsonProperty("creditAmount")
    protected BigDecimal creditAmount;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected GeneralLedgerEntry() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGeneralLedgerEntry() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate postingDate;
        private String documentNumber;
        private String documentType;
        private String accountId;
        private String accountNumber;
        private String description;
        private BigDecimal debitAmount;
        private BigDecimal creditAmount;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder postingDate(LocalDate postingDate) {
            this.postingDate = postingDate;
            this.changedFields = changedFields.add("postingDate");
            return this;
        }

        public Builder documentNumber(String documentNumber) {
            this.documentNumber = documentNumber;
            this.changedFields = changedFields.add("documentNumber");
            return this;
        }

        public Builder documentType(String documentType) {
            this.documentType = documentType;
            this.changedFields = changedFields.add("documentType");
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            this.changedFields = changedFields.add("accountId");
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            this.changedFields = changedFields.add("accountNumber");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder debitAmount(BigDecimal debitAmount) {
            this.debitAmount = debitAmount;
            this.changedFields = changedFields.add("debitAmount");
            return this;
        }

        public Builder creditAmount(BigDecimal creditAmount) {
            this.creditAmount = creditAmount;
            this.changedFields = changedFields.add("creditAmount");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public GeneralLedgerEntry build() {
            GeneralLedgerEntry _x = new GeneralLedgerEntry();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.generalLedgerEntry";
            _x.id = id;
            _x.postingDate = postingDate;
            _x.documentNumber = documentNumber;
            _x.documentType = documentType;
            _x.accountId = accountId;
            _x.accountNumber = accountNumber;
            _x.description = description;
            _x.debitAmount = debitAmount;
            _x.creditAmount = creditAmount;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="postingDate")
    @JsonIgnore
    public Optional<LocalDate> getPostingDate() {
        return Optional.ofNullable(postingDate);
    }

    public GeneralLedgerEntry withPostingDate(LocalDate postingDate) {
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = changedFields.add("postingDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.generalLedgerEntry");
        _x.postingDate = postingDate;
        return _x;
    }

    @Property(name="documentNumber")
    @JsonIgnore
    public Optional<String> getDocumentNumber() {
        return Optional.ofNullable(documentNumber);
    }

    public GeneralLedgerEntry withDocumentNumber(String documentNumber) {
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = changedFields.add("documentNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.generalLedgerEntry");
        _x.documentNumber = documentNumber;
        return _x;
    }

    @Property(name="documentType")
    @JsonIgnore
    public Optional<String> getDocumentType() {
        return Optional.ofNullable(documentType);
    }

    public GeneralLedgerEntry withDocumentType(String documentType) {
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = changedFields.add("documentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.generalLedgerEntry");
        _x.documentType = documentType;
        return _x;
    }

    @Property(name="accountId")
    @JsonIgnore
    public Optional<String> getAccountId() {
        return Optional.ofNullable(accountId);
    }

    public GeneralLedgerEntry withAccountId(String accountId) {
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = changedFields.add("accountId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.generalLedgerEntry");
        _x.accountId = accountId;
        return _x;
    }

    @Property(name="accountNumber")
    @JsonIgnore
    public Optional<String> getAccountNumber() {
        return Optional.ofNullable(accountNumber);
    }

    public GeneralLedgerEntry withAccountNumber(String accountNumber) {
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = changedFields.add("accountNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.generalLedgerEntry");
        _x.accountNumber = accountNumber;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public GeneralLedgerEntry withDescription(String description) {
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.generalLedgerEntry");
        _x.description = description;
        return _x;
    }

    @Property(name="debitAmount")
    @JsonIgnore
    public Optional<BigDecimal> getDebitAmount() {
        return Optional.ofNullable(debitAmount);
    }

    public GeneralLedgerEntry withDebitAmount(BigDecimal debitAmount) {
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = changedFields.add("debitAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.generalLedgerEntry");
        _x.debitAmount = debitAmount;
        return _x;
    }

    @Property(name="creditAmount")
    @JsonIgnore
    public Optional<BigDecimal> getCreditAmount() {
        return Optional.ofNullable(creditAmount);
    }

    public GeneralLedgerEntry withCreditAmount(BigDecimal creditAmount) {
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = changedFields.add("creditAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.generalLedgerEntry");
        _x.creditAmount = creditAmount;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public GeneralLedgerEntry withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.generalLedgerEntry");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @NavigationProperty(name="account")
    @JsonIgnore
    public AccountRequest getAccount() {
        return new AccountRequest(contextPath.addSegment("account"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GeneralLedgerEntry patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GeneralLedgerEntry put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GeneralLedgerEntry _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GeneralLedgerEntry _copy() {
        GeneralLedgerEntry _x = new GeneralLedgerEntry();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.postingDate = postingDate;
        _x.documentNumber = documentNumber;
        _x.documentType = documentType;
        _x.accountId = accountId;
        _x.accountNumber = accountNumber;
        _x.description = description;
        _x.debitAmount = debitAmount;
        _x.creditAmount = creditAmount;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GeneralLedgerEntry[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("postingDate=");
        b.append(this.postingDate);
        b.append(", ");
        b.append("documentNumber=");
        b.append(this.documentNumber);
        b.append(", ");
        b.append("documentType=");
        b.append(this.documentType);
        b.append(", ");
        b.append("accountId=");
        b.append(this.accountId);
        b.append(", ");
        b.append("accountNumber=");
        b.append(this.accountNumber);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("debitAmount=");
        b.append(this.debitAmount);
        b.append(", ");
        b.append("creditAmount=");
        b.append(this.creditAmount);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
