package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AttributeType;
import odata.msgraph.client.beta.enums.ScopeOperatorMultiValuedComparisonType;
import odata.msgraph.client.beta.enums.ScopeOperatorType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "arity", 
    "multivaluedComparisonType", 
    "supportedAttributeTypes"})
@JsonInclude(Include.NON_NULL)
public class FilterOperatorSchema extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.filterOperatorSchema";
    }

    @JsonProperty("arity")
    protected ScopeOperatorType arity;

    @JsonProperty("multivaluedComparisonType")
    protected ScopeOperatorMultiValuedComparisonType multivaluedComparisonType;

    @JsonProperty("supportedAttributeTypes")
    protected List<AttributeType> supportedAttributeTypes;

    @JsonProperty("supportedAttributeTypes@nextLink")
    protected String supportedAttributeTypesNextLink;

    protected FilterOperatorSchema() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFilterOperatorSchema() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ScopeOperatorType arity;
        private ScopeOperatorMultiValuedComparisonType multivaluedComparisonType;
        private List<AttributeType> supportedAttributeTypes;
        private String supportedAttributeTypesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder arity(ScopeOperatorType arity) {
            this.arity = arity;
            this.changedFields = changedFields.add("arity");
            return this;
        }

        public Builder multivaluedComparisonType(ScopeOperatorMultiValuedComparisonType multivaluedComparisonType) {
            this.multivaluedComparisonType = multivaluedComparisonType;
            this.changedFields = changedFields.add("multivaluedComparisonType");
            return this;
        }

        public Builder supportedAttributeTypes(List<AttributeType> supportedAttributeTypes) {
            this.supportedAttributeTypes = supportedAttributeTypes;
            this.changedFields = changedFields.add("supportedAttributeTypes");
            return this;
        }

        public Builder supportedAttributeTypes(AttributeType... supportedAttributeTypes) {
            return supportedAttributeTypes(Arrays.asList(supportedAttributeTypes));
        }

        public Builder supportedAttributeTypesNextLink(String supportedAttributeTypesNextLink) {
            this.supportedAttributeTypesNextLink = supportedAttributeTypesNextLink;
            this.changedFields = changedFields.add("supportedAttributeTypes");
            return this;
        }

        public FilterOperatorSchema build() {
            FilterOperatorSchema _x = new FilterOperatorSchema();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.filterOperatorSchema";
            _x.id = id;
            _x.arity = arity;
            _x.multivaluedComparisonType = multivaluedComparisonType;
            _x.supportedAttributeTypes = supportedAttributeTypes;
            _x.supportedAttributeTypesNextLink = supportedAttributeTypesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="arity")
    @JsonIgnore
    public Optional<ScopeOperatorType> getArity() {
        return Optional.ofNullable(arity);
    }

    public FilterOperatorSchema withArity(ScopeOperatorType arity) {
        FilterOperatorSchema _x = _copy();
        _x.changedFields = changedFields.add("arity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.filterOperatorSchema");
        _x.arity = arity;
        return _x;
    }

    @Property(name="multivaluedComparisonType")
    @JsonIgnore
    public Optional<ScopeOperatorMultiValuedComparisonType> getMultivaluedComparisonType() {
        return Optional.ofNullable(multivaluedComparisonType);
    }

    public FilterOperatorSchema withMultivaluedComparisonType(ScopeOperatorMultiValuedComparisonType multivaluedComparisonType) {
        FilterOperatorSchema _x = _copy();
        _x.changedFields = changedFields.add("multivaluedComparisonType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.filterOperatorSchema");
        _x.multivaluedComparisonType = multivaluedComparisonType;
        return _x;
    }

    @Property(name="supportedAttributeTypes")
    @JsonIgnore
    public CollectionPage<AttributeType> getSupportedAttributeTypes() {
        return new CollectionPage<AttributeType>(contextPath, AttributeType.class, supportedAttributeTypes, Optional.ofNullable(supportedAttributeTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedAttributeTypes")
    @JsonIgnore
    public CollectionPage<AttributeType> getSupportedAttributeTypes(HttpRequestOptions options) {
        return new CollectionPage<AttributeType>(contextPath, AttributeType.class, supportedAttributeTypes, Optional.ofNullable(supportedAttributeTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FilterOperatorSchema patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        FilterOperatorSchema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FilterOperatorSchema put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        FilterOperatorSchema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private FilterOperatorSchema _copy() {
        FilterOperatorSchema _x = new FilterOperatorSchema();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.arity = arity;
        _x.multivaluedComparisonType = multivaluedComparisonType;
        _x.supportedAttributeTypes = supportedAttributeTypes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FilterOperatorSchema[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("arity=");
        b.append(this.arity);
        b.append(", ");
        b.append("multivaluedComparisonType=");
        b.append(this.multivaluedComparisonType);
        b.append(", ");
        b.append("supportedAttributeTypes=");
        b.append(this.supportedAttributeTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
