package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "file", 
    "sensitiveTypeIds"})
@JsonInclude(Include.NON_NULL)
public class FileClassificationRequest extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.fileClassificationRequest";
    }

    @JsonProperty("file")
    protected String file;

    @JsonProperty("sensitiveTypeIds")
    protected List<String> sensitiveTypeIds;

    @JsonProperty("sensitiveTypeIds@nextLink")
    protected String sensitiveTypeIdsNextLink;

    protected FileClassificationRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFileClassificationRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String file;
        private List<String> sensitiveTypeIds;
        private String sensitiveTypeIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder file(String file) {
            this.file = file;
            this.changedFields = changedFields.add("file");
            return this;
        }

        public Builder sensitiveTypeIds(List<String> sensitiveTypeIds) {
            this.sensitiveTypeIds = sensitiveTypeIds;
            this.changedFields = changedFields.add("sensitiveTypeIds");
            return this;
        }

        public Builder sensitiveTypeIds(String... sensitiveTypeIds) {
            return sensitiveTypeIds(Arrays.asList(sensitiveTypeIds));
        }

        public Builder sensitiveTypeIdsNextLink(String sensitiveTypeIdsNextLink) {
            this.sensitiveTypeIdsNextLink = sensitiveTypeIdsNextLink;
            this.changedFields = changedFields.add("sensitiveTypeIds");
            return this;
        }

        public FileClassificationRequest build() {
            FileClassificationRequest _x = new FileClassificationRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.fileClassificationRequest";
            _x.id = id;
            _x.file = file;
            _x.sensitiveTypeIds = sensitiveTypeIds;
            _x.sensitiveTypeIdsNextLink = sensitiveTypeIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="file")
    @JsonIgnore
    public Optional<StreamProvider> getFile() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "file", file);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code file} property.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="file")
    public Optional<StreamUploaderSingleCall> putFile() {
        return putFile(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code file} property.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="file")
    public Optional<StreamUploaderChunked> putChunkedFile() {
        return putFile(UploadStrategy.chunked());
    }

    @Property(name="file")
    public <T extends StreamUploader<T>> Optional<T> putFile(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("file"), this, "file");
    }

    @Property(name="sensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<String> getSensitiveTypeIds() {
        return new CollectionPage<String>(contextPath, String.class, sensitiveTypeIds, Optional.ofNullable(sensitiveTypeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="sensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<String> getSensitiveTypeIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, sensitiveTypeIds, Optional.ofNullable(sensitiveTypeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FileClassificationRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        FileClassificationRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FileClassificationRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        FileClassificationRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private FileClassificationRequest _copy() {
        FileClassificationRequest _x = new FileClassificationRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.file = file;
        _x.sensitiveTypeIds = sensitiveTypeIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FileClassificationRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("file=");
        b.append(this.file);
        b.append(", ");
        b.append("sensitiveTypeIds=");
        b.append(this.sensitiveTypeIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
