package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.enums.ThreatAssessmentContentType;
import odata.msgraph.client.beta.enums.ThreatAssessmentRequestSource;
import odata.msgraph.client.beta.enums.ThreatAssessmentStatus;
import odata.msgraph.client.beta.enums.ThreatCategory;
import odata.msgraph.client.beta.enums.ThreatExpectedAssessment;

@JsonPropertyOrder({
    "@odata.type", 
    "fileName", 
    "contentData"})
@JsonInclude(Include.NON_NULL)
public class FileAssessmentRequest extends ThreatAssessmentRequest implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.fileAssessmentRequest";
    }

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("contentData")
    protected String contentData;

    protected FileAssessmentRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFileAssessmentRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private ThreatAssessmentContentType contentType;
        private ThreatExpectedAssessment expectedAssessment;
        private ThreatCategory category;
        private ThreatAssessmentStatus status;
        private ThreatAssessmentRequestSource requestSource;
        private IdentitySet createdBy;
        private String fileName;
        private String contentData;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder contentType(ThreatAssessmentContentType contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder expectedAssessment(ThreatExpectedAssessment expectedAssessment) {
            this.expectedAssessment = expectedAssessment;
            this.changedFields = changedFields.add("expectedAssessment");
            return this;
        }

        public Builder category(ThreatCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder status(ThreatAssessmentStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder requestSource(ThreatAssessmentRequestSource requestSource) {
            this.requestSource = requestSource;
            this.changedFields = changedFields.add("requestSource");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder contentData(String contentData) {
            this.contentData = contentData;
            this.changedFields = changedFields.add("contentData");
            return this;
        }

        public FileAssessmentRequest build() {
            FileAssessmentRequest _x = new FileAssessmentRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.fileAssessmentRequest";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.contentType = contentType;
            _x.expectedAssessment = expectedAssessment;
            _x.category = category;
            _x.status = status;
            _x.requestSource = requestSource;
            _x.createdBy = createdBy;
            _x.fileName = fileName;
            _x.contentData = contentData;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public FileAssessmentRequest withFileName(String fileName) {
        FileAssessmentRequest _x = _copy();
        _x.changedFields = changedFields.add("fileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileAssessmentRequest");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="contentData")
    @JsonIgnore
    public Optional<String> getContentData() {
        return Optional.ofNullable(contentData);
    }

    public FileAssessmentRequest withContentData(String contentData) {
        FileAssessmentRequest _x = _copy();
        _x.changedFields = changedFields.add("contentData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileAssessmentRequest");
        _x.contentData = contentData;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FileAssessmentRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        FileAssessmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FileAssessmentRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        FileAssessmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private FileAssessmentRequest _copy() {
        FileAssessmentRequest _x = new FileAssessmentRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.contentType = contentType;
        _x.expectedAssessment = expectedAssessment;
        _x.category = category;
        _x.status = status;
        _x.requestSource = requestSource;
        _x.createdBy = createdBy;
        _x.fileName = fileName;
        _x.contentData = contentData;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FileAssessmentRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("expectedAssessment=");
        b.append(this.expectedAssessment);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("requestSource=");
        b.append(this.requestSource);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("contentData=");
        b.append(this.contentData);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
