package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Acl;
import odata.msgraph.client.beta.complex.ExternalItemContent;
import odata.msgraph.client.beta.complex.Properties;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "properties", 
    "content", 
    "acl"})
@JsonInclude(Include.NON_NULL)
public class ExternalItem extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.externalItem";
    }

    @JsonProperty("properties")
    protected Properties properties;

    @JsonProperty("content")
    protected ExternalItemContent content;

    @JsonProperty("acl")
    protected List<Acl> acl;

    @JsonProperty("acl@nextLink")
    protected String aclNextLink;

    protected ExternalItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExternalItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Properties properties;
        private ExternalItemContent content;
        private List<Acl> acl;
        private String aclNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder properties(Properties properties) {
            this.properties = properties;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Builder content(ExternalItemContent content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder acl(List<Acl> acl) {
            this.acl = acl;
            this.changedFields = changedFields.add("acl");
            return this;
        }

        public Builder acl(Acl... acl) {
            return acl(Arrays.asList(acl));
        }

        public Builder aclNextLink(String aclNextLink) {
            this.aclNextLink = aclNextLink;
            this.changedFields = changedFields.add("acl");
            return this;
        }

        public ExternalItem build() {
            ExternalItem _x = new ExternalItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.externalItem";
            _x.id = id;
            _x.properties = properties;
            _x.content = content;
            _x.acl = acl;
            _x.aclNextLink = aclNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="properties")
    @JsonIgnore
    public Optional<Properties> getProperties() {
        return Optional.ofNullable(properties);
    }

    public ExternalItem withProperties(Properties properties) {
        ExternalItem _x = _copy();
        _x.changedFields = changedFields.add("properties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalItem");
        _x.properties = properties;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<ExternalItemContent> getContent() {
        return Optional.ofNullable(content);
    }

    public ExternalItem withContent(ExternalItemContent content) {
        ExternalItem _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalItem");
        _x.content = content;
        return _x;
    }

    @Property(name="acl")
    @JsonIgnore
    public CollectionPage<Acl> getAcl() {
        return new CollectionPage<Acl>(contextPath, Acl.class, acl, Optional.ofNullable(aclNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="acl")
    @JsonIgnore
    public CollectionPage<Acl> getAcl(HttpRequestOptions options) {
        return new CollectionPage<Acl>(contextPath, Acl.class, acl, Optional.ofNullable(aclNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExternalItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExternalItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExternalItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExternalItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExternalItem _copy() {
        ExternalItem _x = new ExternalItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.properties = properties;
        _x.content = content;
        _x.acl = acl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExternalItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("properties=");
        b.append(this.properties);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("acl=");
        b.append(this.acl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
