package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.Configuration;
import odata.msgraph.client.beta.entity.collection.request.ConnectionOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExternalItemCollectionRequest;
import odata.msgraph.client.beta.entity.request.SchemaRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "description", 
    "configuration"})
@JsonInclude(Include.NON_NULL)
public class ExternalConnection extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.externalConnection";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("configuration")
    protected Configuration configuration;

    protected ExternalConnection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExternalConnection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String description;
        private Configuration configuration;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            this.changedFields = changedFields.add("configuration");
            return this;
        }

        public ExternalConnection build() {
            ExternalConnection _x = new ExternalConnection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.externalConnection";
            _x.id = id;
            _x.name = name;
            _x.description = description;
            _x.configuration = configuration;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ExternalConnection withName(String name) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnection");
        _x.name = name;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ExternalConnection withDescription(String description) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnection");
        _x.description = description;
        return _x;
    }

    @Property(name="configuration")
    @JsonIgnore
    public Optional<Configuration> getConfiguration() {
        return Optional.ofNullable(configuration);
    }

    public ExternalConnection withConfiguration(Configuration configuration) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("configuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnection");
        _x.configuration = configuration;
        return _x;
    }

    @NavigationProperty(name="schema")
    @JsonIgnore
    public SchemaRequest getSchema() {
        return new SchemaRequest(contextPath.addSegment("schema"));
    }

    @NavigationProperty(name="items")
    @JsonIgnore
    public ExternalItemCollectionRequest getItems() {
        return new ExternalItemCollectionRequest(
                        contextPath.addSegment("items"));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public ConnectionOperationCollectionRequest getOperations() {
        return new ConnectionOperationCollectionRequest(
                        contextPath.addSegment("operations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExternalConnection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExternalConnection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExternalConnection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExternalConnection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExternalConnection _copy() {
        ExternalConnection _x = new ExternalConnection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.description = description;
        _x.configuration = configuration;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExternalConnection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("configuration=");
        b.append(this.configuration);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
