package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "appDisplayName", 
    "name", 
    "dataType", 
    "isSyncedFromOnPremises", 
    "targetObjects"})
@JsonInclude(Include.NON_NULL)
public class ExtensionProperty extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.extensionProperty";
    }

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("dataType")
    protected String dataType;

    @JsonProperty("isSyncedFromOnPremises")
    protected Boolean isSyncedFromOnPremises;

    @JsonProperty("targetObjects")
    protected List<String> targetObjects;

    @JsonProperty("targetObjects@nextLink")
    protected String targetObjectsNextLink;

    protected ExtensionProperty() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExtensionProperty() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String appDisplayName;
        private String name;
        private String dataType;
        private Boolean isSyncedFromOnPremises;
        private List<String> targetObjects;
        private String targetObjectsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.changedFields = changedFields.add("dataType");
            return this;
        }

        public Builder isSyncedFromOnPremises(Boolean isSyncedFromOnPremises) {
            this.isSyncedFromOnPremises = isSyncedFromOnPremises;
            this.changedFields = changedFields.add("isSyncedFromOnPremises");
            return this;
        }

        public Builder targetObjects(List<String> targetObjects) {
            this.targetObjects = targetObjects;
            this.changedFields = changedFields.add("targetObjects");
            return this;
        }

        public Builder targetObjects(String... targetObjects) {
            return targetObjects(Arrays.asList(targetObjects));
        }

        public Builder targetObjectsNextLink(String targetObjectsNextLink) {
            this.targetObjectsNextLink = targetObjectsNextLink;
            this.changedFields = changedFields.add("targetObjects");
            return this;
        }

        public ExtensionProperty build() {
            ExtensionProperty _x = new ExtensionProperty();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.extensionProperty";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.appDisplayName = appDisplayName;
            _x.name = name;
            _x.dataType = dataType;
            _x.isSyncedFromOnPremises = isSyncedFromOnPremises;
            _x.targetObjects = targetObjects;
            _x.targetObjectsNextLink = targetObjectsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    public ExtensionProperty withAppDisplayName(String appDisplayName) {
        ExtensionProperty _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.extensionProperty");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ExtensionProperty withName(String name) {
        ExtensionProperty _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.extensionProperty");
        _x.name = name;
        return _x;
    }

    @Property(name="dataType")
    @JsonIgnore
    public Optional<String> getDataType() {
        return Optional.ofNullable(dataType);
    }

    public ExtensionProperty withDataType(String dataType) {
        ExtensionProperty _x = _copy();
        _x.changedFields = changedFields.add("dataType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.extensionProperty");
        _x.dataType = dataType;
        return _x;
    }

    @Property(name="isSyncedFromOnPremises")
    @JsonIgnore
    public Optional<Boolean> getIsSyncedFromOnPremises() {
        return Optional.ofNullable(isSyncedFromOnPremises);
    }

    public ExtensionProperty withIsSyncedFromOnPremises(Boolean isSyncedFromOnPremises) {
        ExtensionProperty _x = _copy();
        _x.changedFields = changedFields.add("isSyncedFromOnPremises");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.extensionProperty");
        _x.isSyncedFromOnPremises = isSyncedFromOnPremises;
        return _x;
    }

    @Property(name="targetObjects")
    @JsonIgnore
    public CollectionPage<String> getTargetObjects() {
        return new CollectionPage<String>(contextPath, String.class, targetObjects, Optional.ofNullable(targetObjectsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="targetObjects")
    @JsonIgnore
    public CollectionPage<String> getTargetObjects(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, targetObjects, Optional.ofNullable(targetObjectsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExtensionProperty patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExtensionProperty _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExtensionProperty put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExtensionProperty _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExtensionProperty _copy() {
        ExtensionProperty _x = new ExtensionProperty();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.appDisplayName = appDisplayName;
        _x.name = name;
        _x.dataType = dataType;
        _x.isSyncedFromOnPremises = isSyncedFromOnPremises;
        _x.targetObjects = targetObjects;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExtensionProperty[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("dataType=");
        b.append(this.dataType);
        b.append(", ");
        b.append("isSyncedFromOnPremises=");
        b.append(this.isSyncedFromOnPremises);
        b.append(", ");
        b.append("targetObjects=");
        b.append(this.targetObjects);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
