package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ClassificationError;
import odata.msgraph.client.beta.entity.request.ExactMatchUploadAgentRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "datastoreId", 
    "uploadAgentId", 
    "fields", 
    "fileName", 
    "checksum", 
    "dataUploadURI", 
    "remainingBlockCount", 
    "totalBlockCount", 
    "state", 
    "uploadCompletionDateTime", 
    "processingCompletionDateTime", 
    "rowsPerBlock", 
    "totalJobCount", 
    "remainingJobCount", 
    "salt"})
@JsonInclude(Include.NON_NULL)
public class ExactMatchSession extends ExactMatchJobBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactMatchSession";
    }

    @JsonProperty("datastoreId")
    protected String datastoreId;

    @JsonProperty("uploadAgentId")
    protected String uploadAgentId;

    @JsonProperty("fields")
    protected List<String> fields;

    @JsonProperty("fields@nextLink")
    protected String fieldsNextLink;

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("checksum")
    protected String checksum;

    @JsonProperty("dataUploadURI")
    protected String dataUploadURI;

    @JsonProperty("remainingBlockCount")
    protected Integer remainingBlockCount;

    @JsonProperty("totalBlockCount")
    protected Integer totalBlockCount;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("uploadCompletionDateTime")
    protected OffsetDateTime uploadCompletionDateTime;

    @JsonProperty("processingCompletionDateTime")
    protected OffsetDateTime processingCompletionDateTime;

    @JsonProperty("rowsPerBlock")
    protected Integer rowsPerBlock;

    @JsonProperty("totalJobCount")
    protected Integer totalJobCount;

    @JsonProperty("remainingJobCount")
    protected Integer remainingJobCount;

    @JsonProperty("salt")
    protected String salt;

    protected ExactMatchSession() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExactMatchSession() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime creationDateTime;
        private OffsetDateTime startDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private OffsetDateTime completionDateTime;
        private ClassificationError error;
        private String datastoreId;
        private String uploadAgentId;
        private List<String> fields;
        private String fieldsNextLink;
        private String fileName;
        private String checksum;
        private String dataUploadURI;
        private Integer remainingBlockCount;
        private Integer totalBlockCount;
        private String state;
        private OffsetDateTime uploadCompletionDateTime;
        private OffsetDateTime processingCompletionDateTime;
        private Integer rowsPerBlock;
        private Integer totalJobCount;
        private Integer remainingJobCount;
        private String salt;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder completionDateTime(OffsetDateTime completionDateTime) {
            this.completionDateTime = completionDateTime;
            this.changedFields = changedFields.add("completionDateTime");
            return this;
        }

        public Builder error(ClassificationError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            this.changedFields = changedFields.add("datastoreId");
            return this;
        }

        public Builder uploadAgentId(String uploadAgentId) {
            this.uploadAgentId = uploadAgentId;
            this.changedFields = changedFields.add("uploadAgentId");
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public Builder fields(String... fields) {
            return fields(Arrays.asList(fields));
        }

        public Builder fieldsNextLink(String fieldsNextLink) {
            this.fieldsNextLink = fieldsNextLink;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder checksum(String checksum) {
            this.checksum = checksum;
            this.changedFields = changedFields.add("checksum");
            return this;
        }

        public Builder dataUploadURI(String dataUploadURI) {
            this.dataUploadURI = dataUploadURI;
            this.changedFields = changedFields.add("dataUploadURI");
            return this;
        }

        public Builder remainingBlockCount(Integer remainingBlockCount) {
            this.remainingBlockCount = remainingBlockCount;
            this.changedFields = changedFields.add("remainingBlockCount");
            return this;
        }

        public Builder totalBlockCount(Integer totalBlockCount) {
            this.totalBlockCount = totalBlockCount;
            this.changedFields = changedFields.add("totalBlockCount");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder uploadCompletionDateTime(OffsetDateTime uploadCompletionDateTime) {
            this.uploadCompletionDateTime = uploadCompletionDateTime;
            this.changedFields = changedFields.add("uploadCompletionDateTime");
            return this;
        }

        public Builder processingCompletionDateTime(OffsetDateTime processingCompletionDateTime) {
            this.processingCompletionDateTime = processingCompletionDateTime;
            this.changedFields = changedFields.add("processingCompletionDateTime");
            return this;
        }

        public Builder rowsPerBlock(Integer rowsPerBlock) {
            this.rowsPerBlock = rowsPerBlock;
            this.changedFields = changedFields.add("rowsPerBlock");
            return this;
        }

        public Builder totalJobCount(Integer totalJobCount) {
            this.totalJobCount = totalJobCount;
            this.changedFields = changedFields.add("totalJobCount");
            return this;
        }

        public Builder remainingJobCount(Integer remainingJobCount) {
            this.remainingJobCount = remainingJobCount;
            this.changedFields = changedFields.add("remainingJobCount");
            return this;
        }

        public Builder salt(String salt) {
            this.salt = salt;
            this.changedFields = changedFields.add("salt");
            return this;
        }

        public ExactMatchSession build() {
            ExactMatchSession _x = new ExactMatchSession();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.exactMatchSession";
            _x.id = id;
            _x.creationDateTime = creationDateTime;
            _x.startDateTime = startDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.completionDateTime = completionDateTime;
            _x.error = error;
            _x.datastoreId = datastoreId;
            _x.uploadAgentId = uploadAgentId;
            _x.fields = fields;
            _x.fieldsNextLink = fieldsNextLink;
            _x.fileName = fileName;
            _x.checksum = checksum;
            _x.dataUploadURI = dataUploadURI;
            _x.remainingBlockCount = remainingBlockCount;
            _x.totalBlockCount = totalBlockCount;
            _x.state = state;
            _x.uploadCompletionDateTime = uploadCompletionDateTime;
            _x.processingCompletionDateTime = processingCompletionDateTime;
            _x.rowsPerBlock = rowsPerBlock;
            _x.totalJobCount = totalJobCount;
            _x.remainingJobCount = remainingJobCount;
            _x.salt = salt;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="datastoreId")
    @JsonIgnore
    public Optional<String> getDatastoreId() {
        return Optional.ofNullable(datastoreId);
    }

    public ExactMatchSession withDatastoreId(String datastoreId) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("datastoreId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.datastoreId = datastoreId;
        return _x;
    }

    @Property(name="uploadAgentId")
    @JsonIgnore
    public Optional<String> getUploadAgentId() {
        return Optional.ofNullable(uploadAgentId);
    }

    public ExactMatchSession withUploadAgentId(String uploadAgentId) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("uploadAgentId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.uploadAgentId = uploadAgentId;
        return _x;
    }

    @Property(name="fields")
    @JsonIgnore
    public CollectionPage<String> getFields() {
        return new CollectionPage<String>(contextPath, String.class, fields, Optional.ofNullable(fieldsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="fields")
    @JsonIgnore
    public CollectionPage<String> getFields(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, fields, Optional.ofNullable(fieldsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public ExactMatchSession withFileName(String fileName) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("fileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="checksum")
    @JsonIgnore
    public Optional<String> getChecksum() {
        return Optional.ofNullable(checksum);
    }

    public ExactMatchSession withChecksum(String checksum) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("checksum");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.checksum = checksum;
        return _x;
    }

    @Property(name="dataUploadURI")
    @JsonIgnore
    public Optional<String> getDataUploadURI() {
        return Optional.ofNullable(dataUploadURI);
    }

    public ExactMatchSession withDataUploadURI(String dataUploadURI) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("dataUploadURI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.dataUploadURI = dataUploadURI;
        return _x;
    }

    @Property(name="remainingBlockCount")
    @JsonIgnore
    public Optional<Integer> getRemainingBlockCount() {
        return Optional.ofNullable(remainingBlockCount);
    }

    public ExactMatchSession withRemainingBlockCount(Integer remainingBlockCount) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("remainingBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.remainingBlockCount = remainingBlockCount;
        return _x;
    }

    @Property(name="totalBlockCount")
    @JsonIgnore
    public Optional<Integer> getTotalBlockCount() {
        return Optional.ofNullable(totalBlockCount);
    }

    public ExactMatchSession withTotalBlockCount(Integer totalBlockCount) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("totalBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.totalBlockCount = totalBlockCount;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public ExactMatchSession withState(String state) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.state = state;
        return _x;
    }

    @Property(name="uploadCompletionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getUploadCompletionDateTime() {
        return Optional.ofNullable(uploadCompletionDateTime);
    }

    public ExactMatchSession withUploadCompletionDateTime(OffsetDateTime uploadCompletionDateTime) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("uploadCompletionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.uploadCompletionDateTime = uploadCompletionDateTime;
        return _x;
    }

    @Property(name="processingCompletionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getProcessingCompletionDateTime() {
        return Optional.ofNullable(processingCompletionDateTime);
    }

    public ExactMatchSession withProcessingCompletionDateTime(OffsetDateTime processingCompletionDateTime) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("processingCompletionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.processingCompletionDateTime = processingCompletionDateTime;
        return _x;
    }

    @Property(name="rowsPerBlock")
    @JsonIgnore
    public Optional<Integer> getRowsPerBlock() {
        return Optional.ofNullable(rowsPerBlock);
    }

    public ExactMatchSession withRowsPerBlock(Integer rowsPerBlock) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("rowsPerBlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.rowsPerBlock = rowsPerBlock;
        return _x;
    }

    @Property(name="totalJobCount")
    @JsonIgnore
    public Optional<Integer> getTotalJobCount() {
        return Optional.ofNullable(totalJobCount);
    }

    public ExactMatchSession withTotalJobCount(Integer totalJobCount) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("totalJobCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.totalJobCount = totalJobCount;
        return _x;
    }

    @Property(name="remainingJobCount")
    @JsonIgnore
    public Optional<Integer> getRemainingJobCount() {
        return Optional.ofNullable(remainingJobCount);
    }

    public ExactMatchSession withRemainingJobCount(Integer remainingJobCount) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("remainingJobCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.remainingJobCount = remainingJobCount;
        return _x;
    }

    @Property(name="salt")
    @JsonIgnore
    public Optional<String> getSalt() {
        return Optional.ofNullable(salt);
    }

    public ExactMatchSession withSalt(String salt) {
        ExactMatchSession _x = _copy();
        _x.changedFields = changedFields.add("salt");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSession");
        _x.salt = salt;
        return _x;
    }

    @NavigationProperty(name="uploadAgent")
    @JsonIgnore
    public ExactMatchUploadAgentRequest getUploadAgent() {
        return new ExactMatchUploadAgentRequest(contextPath.addSegment("uploadAgent"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchSession patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExactMatchSession _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchSession put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExactMatchSession _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExactMatchSession _copy() {
        ExactMatchSession _x = new ExactMatchSession();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.creationDateTime = creationDateTime;
        _x.startDateTime = startDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.completionDateTime = completionDateTime;
        _x.error = error;
        _x.datastoreId = datastoreId;
        _x.uploadAgentId = uploadAgentId;
        _x.fields = fields;
        _x.fileName = fileName;
        _x.checksum = checksum;
        _x.dataUploadURI = dataUploadURI;
        _x.remainingBlockCount = remainingBlockCount;
        _x.totalBlockCount = totalBlockCount;
        _x.state = state;
        _x.uploadCompletionDateTime = uploadCompletionDateTime;
        _x.processingCompletionDateTime = processingCompletionDateTime;
        _x.rowsPerBlock = rowsPerBlock;
        _x.totalJobCount = totalJobCount;
        _x.remainingJobCount = remainingJobCount;
        _x.salt = salt;
        return _x;
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "commit")
    @JsonIgnore
    public ActionRequestNoReturn commit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.commit"), _parameters);
    }

    @Action(name = "renew")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExactMatchSession> renew() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<ExactMatchSession>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.renew"), ExactMatchSession.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactMatchSession[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("completionDateTime=");
        b.append(this.completionDateTime);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("datastoreId=");
        b.append(this.datastoreId);
        b.append(", ");
        b.append("uploadAgentId=");
        b.append(this.uploadAgentId);
        b.append(", ");
        b.append("fields=");
        b.append(this.fields);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("checksum=");
        b.append(this.checksum);
        b.append(", ");
        b.append("dataUploadURI=");
        b.append(this.dataUploadURI);
        b.append(", ");
        b.append("remainingBlockCount=");
        b.append(this.remainingBlockCount);
        b.append(", ");
        b.append("totalBlockCount=");
        b.append(this.totalBlockCount);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("uploadCompletionDateTime=");
        b.append(this.uploadCompletionDateTime);
        b.append(", ");
        b.append("processingCompletionDateTime=");
        b.append(this.processingCompletionDateTime);
        b.append(", ");
        b.append("rowsPerBlock=");
        b.append(this.rowsPerBlock);
        b.append(", ");
        b.append("totalJobCount=");
        b.append(this.totalJobCount);
        b.append(", ");
        b.append("remainingJobCount=");
        b.append(this.remainingJobCount);
        b.append(", ");
        b.append("salt=");
        b.append(this.salt);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
