package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ClassificationError;

@JsonPropertyOrder({
    "@odata.type", 
    "creationDateTime", 
    "startDateTime", 
    "lastUpdatedDateTime", 
    "completionDateTime", 
    "error"})
@JsonInclude(Include.NON_NULL)
public class ExactMatchJobBase extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactMatchJobBase";
    }

    @JsonProperty("creationDateTime")
    protected OffsetDateTime creationDateTime;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    @JsonProperty("completionDateTime")
    protected OffsetDateTime completionDateTime;

    @JsonProperty("error")
    protected ClassificationError error;

    protected ExactMatchJobBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="creationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreationDateTime() {
        return Optional.ofNullable(creationDateTime);
    }

    public ExactMatchJobBase withCreationDateTime(OffsetDateTime creationDateTime) {
        ExactMatchJobBase _x = _copy();
        _x.changedFields = changedFields.add("creationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchJobBase");
        _x.creationDateTime = creationDateTime;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public ExactMatchJobBase withStartDateTime(OffsetDateTime startDateTime) {
        ExactMatchJobBase _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchJobBase");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    public ExactMatchJobBase withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        ExactMatchJobBase _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchJobBase");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Property(name="completionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletionDateTime() {
        return Optional.ofNullable(completionDateTime);
    }

    public ExactMatchJobBase withCompletionDateTime(OffsetDateTime completionDateTime) {
        ExactMatchJobBase _x = _copy();
        _x.changedFields = changedFields.add("completionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchJobBase");
        _x.completionDateTime = completionDateTime;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<ClassificationError> getError() {
        return Optional.ofNullable(error);
    }

    public ExactMatchJobBase withError(ClassificationError error) {
        ExactMatchJobBase _x = _copy();
        _x.changedFields = changedFields.add("error");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchJobBase");
        _x.error = error;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchJobBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExactMatchJobBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchJobBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExactMatchJobBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExactMatchJobBase _copy() {
        ExactMatchJobBase _x = new ExactMatchJobBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.creationDateTime = creationDateTime;
        _x.startDateTime = startDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.completionDateTime = completionDateTime;
        _x.error = error;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactMatchJobBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("completionDateTime=");
        b.append(this.completionDateTime);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
