package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ExactMatchSessionCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "description", 
    "dataLastUpdatedDateTime"})
@JsonInclude(Include.NON_NULL)
public class ExactMatchDataStore extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactMatchDataStore";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("dataLastUpdatedDateTime")
    protected OffsetDateTime dataLastUpdatedDateTime;

    protected ExactMatchDataStore() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExactMatchDataStore() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private OffsetDateTime dataLastUpdatedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder dataLastUpdatedDateTime(OffsetDateTime dataLastUpdatedDateTime) {
            this.dataLastUpdatedDateTime = dataLastUpdatedDateTime;
            this.changedFields = changedFields.add("dataLastUpdatedDateTime");
            return this;
        }

        public ExactMatchDataStore build() {
            ExactMatchDataStore _x = new ExactMatchDataStore();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.exactMatchDataStore";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.dataLastUpdatedDateTime = dataLastUpdatedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ExactMatchDataStore withDisplayName(String displayName) {
        ExactMatchDataStore _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchDataStore");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ExactMatchDataStore withDescription(String description) {
        ExactMatchDataStore _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchDataStore");
        _x.description = description;
        return _x;
    }

    @Property(name="dataLastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDataLastUpdatedDateTime() {
        return Optional.ofNullable(dataLastUpdatedDateTime);
    }

    public ExactMatchDataStore withDataLastUpdatedDateTime(OffsetDateTime dataLastUpdatedDateTime) {
        ExactMatchDataStore _x = _copy();
        _x.changedFields = changedFields.add("dataLastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchDataStore");
        _x.dataLastUpdatedDateTime = dataLastUpdatedDateTime;
        return _x;
    }

    @NavigationProperty(name="sessions")
    @JsonIgnore
    public ExactMatchSessionCollectionRequest getSessions() {
        return new ExactMatchSessionCollectionRequest(
                        contextPath.addSegment("sessions"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchDataStore patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExactMatchDataStore _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchDataStore put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExactMatchDataStore _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExactMatchDataStore _copy() {
        ExactMatchDataStore _x = new ExactMatchDataStore();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.dataLastUpdatedDateTime = dataLastUpdatedDateTime;
        return _x;
    }

    @Action(name = "lookup")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> lookup(String key, List<String> values, List<String> resultColumnNames) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("key", "Edm.String", Checks.checkIsAscii(key))
            .put("values", "Collection(Edm.String)", Checks.checkIsAscii(values))
            .put("resultColumnNames", "Collection(Edm.String)", Checks.checkIsAscii(resultColumnNames))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lookup"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactMatchDataStore[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("dataLastUpdatedDateTime=");
        b.append(this.dataLastUpdatedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
