package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Attendee;
import odata.msgraph.client.beta.complex.DateTimeTimeZone;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.Location;
import odata.msgraph.client.beta.complex.OnlineMeetingInfo;
import odata.msgraph.client.beta.complex.PatternedRecurrence;
import odata.msgraph.client.beta.complex.Recipient;
import odata.msgraph.client.beta.complex.ResponseStatus;
import odata.msgraph.client.beta.complex.TimeSlot;
import odata.msgraph.client.beta.entity.collection.request.AttachmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;
import odata.msgraph.client.beta.enums.EventType;
import odata.msgraph.client.beta.enums.FreeBusyStatus;
import odata.msgraph.client.beta.enums.Importance;
import odata.msgraph.client.beta.enums.OnlineMeetingProviderType;
import odata.msgraph.client.beta.enums.Sensitivity;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "transactionId", 
    "originalStartTimeZone", 
    "originalEndTimeZone", 
    "responseStatus", 
    "uid", 
    "reminderMinutesBeforeStart", 
    "isReminderOn", 
    "hasAttachments", 
    "subject", 
    "body", 
    "bodyPreview", 
    "importance", 
    "sensitivity", 
    "start", 
    "originalStart", 
    "end", 
    "location", 
    "locations", 
    "isAllDay", 
    "isCancelled", 
    "isOrganizer", 
    "recurrence", 
    "responseRequested", 
    "seriesMasterId", 
    "showAs", 
    "type", 
    "attendees", 
    "organizer", 
    "webLink", 
    "onlineMeetingUrl", 
    "isOnlineMeeting", 
    "onlineMeetingProvider", 
    "onlineMeeting", 
    "allowNewTimeProposals", 
    "isDraft"})
@JsonInclude(Include.NON_NULL)
public class Event extends OutlookItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.event";
    }

    @JsonProperty("transactionId")
    protected String transactionId;

    @JsonProperty("originalStartTimeZone")
    protected String originalStartTimeZone;

    @JsonProperty("originalEndTimeZone")
    protected String originalEndTimeZone;

    @JsonProperty("responseStatus")
    protected ResponseStatus responseStatus;

    @JsonProperty("uid")
    protected String uid;

    @JsonProperty("reminderMinutesBeforeStart")
    protected Integer reminderMinutesBeforeStart;

    @JsonProperty("isReminderOn")
    protected Boolean isReminderOn;

    @JsonProperty("hasAttachments")
    protected Boolean hasAttachments;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("body")
    protected ItemBody body;

    @JsonProperty("bodyPreview")
    protected String bodyPreview;

    @JsonProperty("importance")
    protected Importance importance;

    @JsonProperty("sensitivity")
    protected Sensitivity sensitivity;

    @JsonProperty("start")
    protected DateTimeTimeZone start;

    @JsonProperty("originalStart")
    protected OffsetDateTime originalStart;

    @JsonProperty("end")
    protected DateTimeTimeZone end;

    @JsonProperty("location")
    protected Location location;

    @JsonProperty("locations")
    protected List<Location> locations;

    @JsonProperty("locations@nextLink")
    protected String locationsNextLink;

    @JsonProperty("isAllDay")
    protected Boolean isAllDay;

    @JsonProperty("isCancelled")
    protected Boolean isCancelled;

    @JsonProperty("isOrganizer")
    protected Boolean isOrganizer;

    @JsonProperty("recurrence")
    protected PatternedRecurrence recurrence;

    @JsonProperty("responseRequested")
    protected Boolean responseRequested;

    @JsonProperty("seriesMasterId")
    protected String seriesMasterId;

    @JsonProperty("showAs")
    protected FreeBusyStatus showAs;

    @JsonProperty("type")
    protected EventType type;

    @JsonProperty("attendees")
    protected List<Attendee> attendees;

    @JsonProperty("attendees@nextLink")
    protected String attendeesNextLink;

    @JsonProperty("organizer")
    protected Recipient organizer;

    @JsonProperty("webLink")
    protected String webLink;

    @JsonProperty("onlineMeetingUrl")
    protected String onlineMeetingUrl;

    @JsonProperty("isOnlineMeeting")
    protected Boolean isOnlineMeeting;

    @JsonProperty("onlineMeetingProvider")
    protected OnlineMeetingProviderType onlineMeetingProvider;

    @JsonProperty("onlineMeeting")
    protected OnlineMeetingInfo onlineMeeting;

    @JsonProperty("allowNewTimeProposals")
    protected Boolean allowNewTimeProposals;

    @JsonProperty("isDraft")
    protected Boolean isDraft;

    protected Event() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEvent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String changeKey;
        private List<String> categories;
        private String categoriesNextLink;
        private String transactionId;
        private String originalStartTimeZone;
        private String originalEndTimeZone;
        private ResponseStatus responseStatus;
        private String uid;
        private Integer reminderMinutesBeforeStart;
        private Boolean isReminderOn;
        private Boolean hasAttachments;
        private String subject;
        private ItemBody body;
        private String bodyPreview;
        private Importance importance;
        private Sensitivity sensitivity;
        private DateTimeTimeZone start;
        private OffsetDateTime originalStart;
        private DateTimeTimeZone end;
        private Location location;
        private List<Location> locations;
        private String locationsNextLink;
        private Boolean isAllDay;
        private Boolean isCancelled;
        private Boolean isOrganizer;
        private PatternedRecurrence recurrence;
        private Boolean responseRequested;
        private String seriesMasterId;
        private FreeBusyStatus showAs;
        private EventType type;
        private List<Attendee> attendees;
        private String attendeesNextLink;
        private Recipient organizer;
        private String webLink;
        private String onlineMeetingUrl;
        private Boolean isOnlineMeeting;
        private OnlineMeetingProviderType onlineMeetingProvider;
        private OnlineMeetingInfo onlineMeeting;
        private Boolean allowNewTimeProposals;
        private Boolean isDraft;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            this.changedFields = changedFields.add("transactionId");
            return this;
        }

        public Builder originalStartTimeZone(String originalStartTimeZone) {
            this.originalStartTimeZone = originalStartTimeZone;
            this.changedFields = changedFields.add("originalStartTimeZone");
            return this;
        }

        public Builder originalEndTimeZone(String originalEndTimeZone) {
            this.originalEndTimeZone = originalEndTimeZone;
            this.changedFields = changedFields.add("originalEndTimeZone");
            return this;
        }

        public Builder responseStatus(ResponseStatus responseStatus) {
            this.responseStatus = responseStatus;
            this.changedFields = changedFields.add("responseStatus");
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            this.changedFields = changedFields.add("uid");
            return this;
        }

        public Builder reminderMinutesBeforeStart(Integer reminderMinutesBeforeStart) {
            this.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
            this.changedFields = changedFields.add("reminderMinutesBeforeStart");
            return this;
        }

        public Builder isReminderOn(Boolean isReminderOn) {
            this.isReminderOn = isReminderOn;
            this.changedFields = changedFields.add("isReminderOn");
            return this;
        }

        public Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            this.changedFields = changedFields.add("hasAttachments");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder body(ItemBody body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder bodyPreview(String bodyPreview) {
            this.bodyPreview = bodyPreview;
            this.changedFields = changedFields.add("bodyPreview");
            return this;
        }

        public Builder importance(Importance importance) {
            this.importance = importance;
            this.changedFields = changedFields.add("importance");
            return this;
        }

        public Builder sensitivity(Sensitivity sensitivity) {
            this.sensitivity = sensitivity;
            this.changedFields = changedFields.add("sensitivity");
            return this;
        }

        public Builder start(DateTimeTimeZone start) {
            this.start = start;
            this.changedFields = changedFields.add("start");
            return this;
        }

        public Builder originalStart(OffsetDateTime originalStart) {
            this.originalStart = originalStart;
            this.changedFields = changedFields.add("originalStart");
            return this;
        }

        public Builder end(DateTimeTimeZone end) {
            this.end = end;
            this.changedFields = changedFields.add("end");
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder locations(List<Location> locations) {
            this.locations = locations;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder locations(Location... locations) {
            return locations(Arrays.asList(locations));
        }

        public Builder locationsNextLink(String locationsNextLink) {
            this.locationsNextLink = locationsNextLink;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder isAllDay(Boolean isAllDay) {
            this.isAllDay = isAllDay;
            this.changedFields = changedFields.add("isAllDay");
            return this;
        }

        public Builder isCancelled(Boolean isCancelled) {
            this.isCancelled = isCancelled;
            this.changedFields = changedFields.add("isCancelled");
            return this;
        }

        public Builder isOrganizer(Boolean isOrganizer) {
            this.isOrganizer = isOrganizer;
            this.changedFields = changedFields.add("isOrganizer");
            return this;
        }

        public Builder recurrence(PatternedRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        public Builder responseRequested(Boolean responseRequested) {
            this.responseRequested = responseRequested;
            this.changedFields = changedFields.add("responseRequested");
            return this;
        }

        public Builder seriesMasterId(String seriesMasterId) {
            this.seriesMasterId = seriesMasterId;
            this.changedFields = changedFields.add("seriesMasterId");
            return this;
        }

        public Builder showAs(FreeBusyStatus showAs) {
            this.showAs = showAs;
            this.changedFields = changedFields.add("showAs");
            return this;
        }

        public Builder type(EventType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder attendees(List<Attendee> attendees) {
            this.attendees = attendees;
            this.changedFields = changedFields.add("attendees");
            return this;
        }

        public Builder attendees(Attendee... attendees) {
            return attendees(Arrays.asList(attendees));
        }

        public Builder attendeesNextLink(String attendeesNextLink) {
            this.attendeesNextLink = attendeesNextLink;
            this.changedFields = changedFields.add("attendees");
            return this;
        }

        public Builder organizer(Recipient organizer) {
            this.organizer = organizer;
            this.changedFields = changedFields.add("organizer");
            return this;
        }

        public Builder webLink(String webLink) {
            this.webLink = webLink;
            this.changedFields = changedFields.add("webLink");
            return this;
        }

        public Builder onlineMeetingUrl(String onlineMeetingUrl) {
            this.onlineMeetingUrl = onlineMeetingUrl;
            this.changedFields = changedFields.add("onlineMeetingUrl");
            return this;
        }

        public Builder isOnlineMeeting(Boolean isOnlineMeeting) {
            this.isOnlineMeeting = isOnlineMeeting;
            this.changedFields = changedFields.add("isOnlineMeeting");
            return this;
        }

        public Builder onlineMeetingProvider(OnlineMeetingProviderType onlineMeetingProvider) {
            this.onlineMeetingProvider = onlineMeetingProvider;
            this.changedFields = changedFields.add("onlineMeetingProvider");
            return this;
        }

        public Builder onlineMeeting(OnlineMeetingInfo onlineMeeting) {
            this.onlineMeeting = onlineMeeting;
            this.changedFields = changedFields.add("onlineMeeting");
            return this;
        }

        public Builder allowNewTimeProposals(Boolean allowNewTimeProposals) {
            this.allowNewTimeProposals = allowNewTimeProposals;
            this.changedFields = changedFields.add("allowNewTimeProposals");
            return this;
        }

        public Builder isDraft(Boolean isDraft) {
            this.isDraft = isDraft;
            this.changedFields = changedFields.add("isDraft");
            return this;
        }

        public Event build() {
            Event _x = new Event();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.event";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.changeKey = changeKey;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.transactionId = transactionId;
            _x.originalStartTimeZone = originalStartTimeZone;
            _x.originalEndTimeZone = originalEndTimeZone;
            _x.responseStatus = responseStatus;
            _x.uid = uid;
            _x.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
            _x.isReminderOn = isReminderOn;
            _x.hasAttachments = hasAttachments;
            _x.subject = subject;
            _x.body = body;
            _x.bodyPreview = bodyPreview;
            _x.importance = importance;
            _x.sensitivity = sensitivity;
            _x.start = start;
            _x.originalStart = originalStart;
            _x.end = end;
            _x.location = location;
            _x.locations = locations;
            _x.locationsNextLink = locationsNextLink;
            _x.isAllDay = isAllDay;
            _x.isCancelled = isCancelled;
            _x.isOrganizer = isOrganizer;
            _x.recurrence = recurrence;
            _x.responseRequested = responseRequested;
            _x.seriesMasterId = seriesMasterId;
            _x.showAs = showAs;
            _x.type = type;
            _x.attendees = attendees;
            _x.attendeesNextLink = attendeesNextLink;
            _x.organizer = organizer;
            _x.webLink = webLink;
            _x.onlineMeetingUrl = onlineMeetingUrl;
            _x.isOnlineMeeting = isOnlineMeeting;
            _x.onlineMeetingProvider = onlineMeetingProvider;
            _x.onlineMeeting = onlineMeeting;
            _x.allowNewTimeProposals = allowNewTimeProposals;
            _x.isDraft = isDraft;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="transactionId")
    @JsonIgnore
    public Optional<String> getTransactionId() {
        return Optional.ofNullable(transactionId);
    }

    public Event withTransactionId(String transactionId) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("transactionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.transactionId = transactionId;
        return _x;
    }

    @Property(name="originalStartTimeZone")
    @JsonIgnore
    public Optional<String> getOriginalStartTimeZone() {
        return Optional.ofNullable(originalStartTimeZone);
    }

    public Event withOriginalStartTimeZone(String originalStartTimeZone) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("originalStartTimeZone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.originalStartTimeZone = originalStartTimeZone;
        return _x;
    }

    @Property(name="originalEndTimeZone")
    @JsonIgnore
    public Optional<String> getOriginalEndTimeZone() {
        return Optional.ofNullable(originalEndTimeZone);
    }

    public Event withOriginalEndTimeZone(String originalEndTimeZone) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("originalEndTimeZone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.originalEndTimeZone = originalEndTimeZone;
        return _x;
    }

    @Property(name="responseStatus")
    @JsonIgnore
    public Optional<ResponseStatus> getResponseStatus() {
        return Optional.ofNullable(responseStatus);
    }

    public Event withResponseStatus(ResponseStatus responseStatus) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("responseStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.responseStatus = responseStatus;
        return _x;
    }

    @Property(name="uid")
    @JsonIgnore
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    public Event withUid(String uid) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("uid");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.uid = uid;
        return _x;
    }

    @Property(name="reminderMinutesBeforeStart")
    @JsonIgnore
    public Optional<Integer> getReminderMinutesBeforeStart() {
        return Optional.ofNullable(reminderMinutesBeforeStart);
    }

    public Event withReminderMinutesBeforeStart(Integer reminderMinutesBeforeStart) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("reminderMinutesBeforeStart");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
        return _x;
    }

    @Property(name="isReminderOn")
    @JsonIgnore
    public Optional<Boolean> getIsReminderOn() {
        return Optional.ofNullable(isReminderOn);
    }

    public Event withIsReminderOn(Boolean isReminderOn) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isReminderOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isReminderOn = isReminderOn;
        return _x;
    }

    @Property(name="hasAttachments")
    @JsonIgnore
    public Optional<Boolean> getHasAttachments() {
        return Optional.ofNullable(hasAttachments);
    }

    public Event withHasAttachments(Boolean hasAttachments) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("hasAttachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.hasAttachments = hasAttachments;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public Event withSubject(String subject) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.subject = subject;
        return _x;
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<ItemBody> getBody() {
        return Optional.ofNullable(body);
    }

    public Event withBody(ItemBody body) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.body = body;
        return _x;
    }

    @Property(name="bodyPreview")
    @JsonIgnore
    public Optional<String> getBodyPreview() {
        return Optional.ofNullable(bodyPreview);
    }

    public Event withBodyPreview(String bodyPreview) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("bodyPreview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.bodyPreview = bodyPreview;
        return _x;
    }

    @Property(name="importance")
    @JsonIgnore
    public Optional<Importance> getImportance() {
        return Optional.ofNullable(importance);
    }

    public Event withImportance(Importance importance) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("importance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.importance = importance;
        return _x;
    }

    @Property(name="sensitivity")
    @JsonIgnore
    public Optional<Sensitivity> getSensitivity() {
        return Optional.ofNullable(sensitivity);
    }

    public Event withSensitivity(Sensitivity sensitivity) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("sensitivity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.sensitivity = sensitivity;
        return _x;
    }

    @Property(name="start")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getStart() {
        return Optional.ofNullable(start);
    }

    public Event withStart(DateTimeTimeZone start) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("start");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.start = start;
        return _x;
    }

    @Property(name="originalStart")
    @JsonIgnore
    public Optional<OffsetDateTime> getOriginalStart() {
        return Optional.ofNullable(originalStart);
    }

    public Event withOriginalStart(OffsetDateTime originalStart) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("originalStart");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.originalStart = originalStart;
        return _x;
    }

    @Property(name="end")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getEnd() {
        return Optional.ofNullable(end);
    }

    public Event withEnd(DateTimeTimeZone end) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("end");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.end = end;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<Location> getLocation() {
        return Optional.ofNullable(location);
    }

    public Event withLocation(Location location) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.location = location;
        return _x;
    }

    @Property(name="locations")
    @JsonIgnore
    public CollectionPage<Location> getLocations() {
        return new CollectionPage<Location>(contextPath, Location.class, locations, Optional.ofNullable(locationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="locations")
    @JsonIgnore
    public CollectionPage<Location> getLocations(HttpRequestOptions options) {
        return new CollectionPage<Location>(contextPath, Location.class, locations, Optional.ofNullable(locationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="isAllDay")
    @JsonIgnore
    public Optional<Boolean> getIsAllDay() {
        return Optional.ofNullable(isAllDay);
    }

    public Event withIsAllDay(Boolean isAllDay) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isAllDay");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isAllDay = isAllDay;
        return _x;
    }

    @Property(name="isCancelled")
    @JsonIgnore
    public Optional<Boolean> getIsCancelled() {
        return Optional.ofNullable(isCancelled);
    }

    public Event withIsCancelled(Boolean isCancelled) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isCancelled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isCancelled = isCancelled;
        return _x;
    }

    @Property(name="isOrganizer")
    @JsonIgnore
    public Optional<Boolean> getIsOrganizer() {
        return Optional.ofNullable(isOrganizer);
    }

    public Event withIsOrganizer(Boolean isOrganizer) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isOrganizer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isOrganizer = isOrganizer;
        return _x;
    }

    @Property(name="recurrence")
    @JsonIgnore
    public Optional<PatternedRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    public Event withRecurrence(PatternedRecurrence recurrence) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("recurrence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.recurrence = recurrence;
        return _x;
    }

    @Property(name="responseRequested")
    @JsonIgnore
    public Optional<Boolean> getResponseRequested() {
        return Optional.ofNullable(responseRequested);
    }

    public Event withResponseRequested(Boolean responseRequested) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("responseRequested");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.responseRequested = responseRequested;
        return _x;
    }

    @Property(name="seriesMasterId")
    @JsonIgnore
    public Optional<String> getSeriesMasterId() {
        return Optional.ofNullable(seriesMasterId);
    }

    public Event withSeriesMasterId(String seriesMasterId) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("seriesMasterId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.seriesMasterId = seriesMasterId;
        return _x;
    }

    @Property(name="showAs")
    @JsonIgnore
    public Optional<FreeBusyStatus> getShowAs() {
        return Optional.ofNullable(showAs);
    }

    public Event withShowAs(FreeBusyStatus showAs) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("showAs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.showAs = showAs;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<EventType> getType() {
        return Optional.ofNullable(type);
    }

    public Event withType(EventType type) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.type = type;
        return _x;
    }

    @Property(name="attendees")
    @JsonIgnore
    public CollectionPage<Attendee> getAttendees() {
        return new CollectionPage<Attendee>(contextPath, Attendee.class, attendees, Optional.ofNullable(attendeesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="attendees")
    @JsonIgnore
    public CollectionPage<Attendee> getAttendees(HttpRequestOptions options) {
        return new CollectionPage<Attendee>(contextPath, Attendee.class, attendees, Optional.ofNullable(attendeesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="organizer")
    @JsonIgnore
    public Optional<Recipient> getOrganizer() {
        return Optional.ofNullable(organizer);
    }

    public Event withOrganizer(Recipient organizer) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("organizer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.organizer = organizer;
        return _x;
    }

    @Property(name="webLink")
    @JsonIgnore
    public Optional<String> getWebLink() {
        return Optional.ofNullable(webLink);
    }

    public Event withWebLink(String webLink) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("webLink");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.webLink = webLink;
        return _x;
    }

    @Property(name="onlineMeetingUrl")
    @JsonIgnore
    public Optional<String> getOnlineMeetingUrl() {
        return Optional.ofNullable(onlineMeetingUrl);
    }

    public Event withOnlineMeetingUrl(String onlineMeetingUrl) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("onlineMeetingUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.onlineMeetingUrl = onlineMeetingUrl;
        return _x;
    }

    @Property(name="isOnlineMeeting")
    @JsonIgnore
    public Optional<Boolean> getIsOnlineMeeting() {
        return Optional.ofNullable(isOnlineMeeting);
    }

    public Event withIsOnlineMeeting(Boolean isOnlineMeeting) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isOnlineMeeting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isOnlineMeeting = isOnlineMeeting;
        return _x;
    }

    @Property(name="onlineMeetingProvider")
    @JsonIgnore
    public Optional<OnlineMeetingProviderType> getOnlineMeetingProvider() {
        return Optional.ofNullable(onlineMeetingProvider);
    }

    public Event withOnlineMeetingProvider(OnlineMeetingProviderType onlineMeetingProvider) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("onlineMeetingProvider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.onlineMeetingProvider = onlineMeetingProvider;
        return _x;
    }

    @Property(name="onlineMeeting")
    @JsonIgnore
    public Optional<OnlineMeetingInfo> getOnlineMeeting() {
        return Optional.ofNullable(onlineMeeting);
    }

    public Event withOnlineMeeting(OnlineMeetingInfo onlineMeeting) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("onlineMeeting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.onlineMeeting = onlineMeeting;
        return _x;
    }

    @Property(name="allowNewTimeProposals")
    @JsonIgnore
    public Optional<Boolean> getAllowNewTimeProposals() {
        return Optional.ofNullable(allowNewTimeProposals);
    }

    public Event withAllowNewTimeProposals(Boolean allowNewTimeProposals) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("allowNewTimeProposals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.allowNewTimeProposals = allowNewTimeProposals;
        return _x;
    }

    @Property(name="isDraft")
    @JsonIgnore
    public Optional<Boolean> getIsDraft() {
        return Optional.ofNullable(isDraft);
    }

    public Event withIsDraft(Boolean isDraft) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isDraft");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isDraft = isDraft;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property attachments
     */
    @NavigationProperty(name="attachments")
    @JsonIgnore
    public AttachmentCollectionRequest getAttachments() {
        return new AttachmentCollectionRequest(
                        contextPath.addSegment("attachments"));
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property calendar
     */
    @NavigationProperty(name="calendar")
    @JsonIgnore
    public CalendarRequest getCalendar() {
        return new CalendarRequest(contextPath.addSegment("calendar"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * 
     * @return navigational property instances
     */
    @NavigationProperty(name="instances")
    @JsonIgnore
    public EventCollectionRequest getInstances() {
        return new EventCollectionRequest(
                        contextPath.addSegment("instances"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property extensions
     */
    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Event patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Event _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Event put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Event _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Event _copy() {
        Event _x = new Event();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.changeKey = changeKey;
        _x.categories = categories;
        _x.transactionId = transactionId;
        _x.originalStartTimeZone = originalStartTimeZone;
        _x.originalEndTimeZone = originalEndTimeZone;
        _x.responseStatus = responseStatus;
        _x.uid = uid;
        _x.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
        _x.isReminderOn = isReminderOn;
        _x.hasAttachments = hasAttachments;
        _x.subject = subject;
        _x.body = body;
        _x.bodyPreview = bodyPreview;
        _x.importance = importance;
        _x.sensitivity = sensitivity;
        _x.start = start;
        _x.originalStart = originalStart;
        _x.end = end;
        _x.location = location;
        _x.locations = locations;
        _x.isAllDay = isAllDay;
        _x.isCancelled = isCancelled;
        _x.isOrganizer = isOrganizer;
        _x.recurrence = recurrence;
        _x.responseRequested = responseRequested;
        _x.seriesMasterId = seriesMasterId;
        _x.showAs = showAs;
        _x.type = type;
        _x.attendees = attendees;
        _x.organizer = organizer;
        _x.webLink = webLink;
        _x.onlineMeetingUrl = onlineMeetingUrl;
        _x.isOnlineMeeting = isOnlineMeeting;
        _x.onlineMeetingProvider = onlineMeetingProvider;
        _x.onlineMeeting = onlineMeeting;
        _x.allowNewTimeProposals = allowNewTimeProposals;
        _x.isDraft = isDraft;
        return _x;
    }

    @Action(name = "dismissReminder")
    @JsonIgnore
    public ActionRequestNoReturn dismissReminder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dismissReminder"), _parameters);
    }

    @Action(name = "snoozeReminder")
    @JsonIgnore
    public ActionRequestNoReturn snoozeReminder(DateTimeTimeZone newReminderTime) {
        Preconditions.checkNotNull(newReminderTime, "newReminderTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("NewReminderTime", "microsoft.graph.dateTimeTimeZone", newReminderTime)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.snoozeReminder"), _parameters);
    }

    @Action(name = "forward")
    @JsonIgnore
    public ActionRequestNoReturn forward(List<Recipient> toRecipients, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ToRecipients", "Collection(microsoft.graph.recipient)", toRecipients)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.forward"), _parameters);
    }

    @Action(name = "accept")
    @JsonIgnore
    public ActionRequestNoReturn accept(Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.accept"), _parameters);
    }

    @Action(name = "decline")
    @JsonIgnore
    public ActionRequestNoReturn decline(TimeSlot proposedNewTime, Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ProposedNewTime", "microsoft.graph.timeSlot", proposedNewTime)
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.decline"), _parameters);
    }

    @Action(name = "tentativelyAccept")
    @JsonIgnore
    public ActionRequestNoReturn tentativelyAccept(TimeSlot proposedNewTime, Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ProposedNewTime", "microsoft.graph.timeSlot", proposedNewTime)
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.tentativelyAccept"), _parameters);
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel(String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Event[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("transactionId=");
        b.append(this.transactionId);
        b.append(", ");
        b.append("originalStartTimeZone=");
        b.append(this.originalStartTimeZone);
        b.append(", ");
        b.append("originalEndTimeZone=");
        b.append(this.originalEndTimeZone);
        b.append(", ");
        b.append("responseStatus=");
        b.append(this.responseStatus);
        b.append(", ");
        b.append("uid=");
        b.append(this.uid);
        b.append(", ");
        b.append("reminderMinutesBeforeStart=");
        b.append(this.reminderMinutesBeforeStart);
        b.append(", ");
        b.append("isReminderOn=");
        b.append(this.isReminderOn);
        b.append(", ");
        b.append("hasAttachments=");
        b.append(this.hasAttachments);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("bodyPreview=");
        b.append(this.bodyPreview);
        b.append(", ");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("sensitivity=");
        b.append(this.sensitivity);
        b.append(", ");
        b.append("start=");
        b.append(this.start);
        b.append(", ");
        b.append("originalStart=");
        b.append(this.originalStart);
        b.append(", ");
        b.append("end=");
        b.append(this.end);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("locations=");
        b.append(this.locations);
        b.append(", ");
        b.append("isAllDay=");
        b.append(this.isAllDay);
        b.append(", ");
        b.append("isCancelled=");
        b.append(this.isCancelled);
        b.append(", ");
        b.append("isOrganizer=");
        b.append(this.isOrganizer);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("responseRequested=");
        b.append(this.responseRequested);
        b.append(", ");
        b.append("seriesMasterId=");
        b.append(this.seriesMasterId);
        b.append(", ");
        b.append("showAs=");
        b.append(this.showAs);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("attendees=");
        b.append(this.attendees);
        b.append(", ");
        b.append("organizer=");
        b.append(this.organizer);
        b.append(", ");
        b.append("webLink=");
        b.append(this.webLink);
        b.append(", ");
        b.append("onlineMeetingUrl=");
        b.append(this.onlineMeetingUrl);
        b.append(", ");
        b.append("isOnlineMeeting=");
        b.append(this.isOnlineMeeting);
        b.append(", ");
        b.append("onlineMeetingProvider=");
        b.append(this.onlineMeetingProvider);
        b.append(", ");
        b.append("onlineMeeting=");
        b.append(this.onlineMeeting);
        b.append(", ");
        b.append("allowNewTimeProposals=");
        b.append(this.allowNewTimeProposals);
        b.append(", ");
        b.append("isDraft=");
        b.append(this.isDraft);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
