package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCatalogCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConnectedOrganizationCollectionRequest;
import odata.msgraph.client.beta.entity.request.EntitlementManagementSettingsRequest;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class EntitlementManagement extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.entitlementManagement";
    }

    protected EntitlementManagement() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntitlementManagement() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public EntitlementManagement build() {
            EntitlementManagement _x = new EntitlementManagement();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.entitlementManagement";
            _x.id = id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @NavigationProperty(name="accessPackageCatalogs")
    @JsonIgnore
    public AccessPackageCatalogCollectionRequest getAccessPackageCatalogs() {
        return new AccessPackageCatalogCollectionRequest(
                        contextPath.addSegment("accessPackageCatalogs"));
    }

    @NavigationProperty(name="accessPackageResources")
    @JsonIgnore
    public AccessPackageResourceCollectionRequest getAccessPackageResources() {
        return new AccessPackageResourceCollectionRequest(
                        contextPath.addSegment("accessPackageResources"));
    }

    @NavigationProperty(name="accessPackageResourceRequests")
    @JsonIgnore
    public AccessPackageResourceRequestCollectionRequest getAccessPackageResourceRequests() {
        return new AccessPackageResourceRequestCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRequests"));
    }

    @NavigationProperty(name="accessPackageResourceRoleScopes")
    @JsonIgnore
    public AccessPackageResourceRoleScopeCollectionRequest getAccessPackageResourceRoleScopes() {
        return new AccessPackageResourceRoleScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoleScopes"));
    }

    @NavigationProperty(name="accessPackages")
    @JsonIgnore
    public AccessPackageCollectionRequest getAccessPackages() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("accessPackages"));
    }

    @NavigationProperty(name="accessPackageAssignmentPolicies")
    @JsonIgnore
    public AccessPackageAssignmentPolicyCollectionRequest getAccessPackageAssignmentPolicies() {
        return new AccessPackageAssignmentPolicyCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentPolicies"));
    }

    @NavigationProperty(name="accessPackageAssignments")
    @JsonIgnore
    public AccessPackageAssignmentCollectionRequest getAccessPackageAssignments() {
        return new AccessPackageAssignmentCollectionRequest(
                        contextPath.addSegment("accessPackageAssignments"));
    }

    @NavigationProperty(name="accessPackageAssignmentRequests")
    @JsonIgnore
    public AccessPackageAssignmentRequestCollectionRequest getAccessPackageAssignmentRequests() {
        return new AccessPackageAssignmentRequestCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentRequests"));
    }

    @NavigationProperty(name="accessPackageAssignmentResourceRoles")
    @JsonIgnore
    public AccessPackageAssignmentResourceRoleCollectionRequest getAccessPackageAssignmentResourceRoles() {
        return new AccessPackageAssignmentResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentResourceRoles"));
    }

    @NavigationProperty(name="settings")
    @JsonIgnore
    public EntitlementManagementSettingsRequest getSettings() {
        return new EntitlementManagementSettingsRequest(contextPath.addSegment("settings"));
    }

    @NavigationProperty(name="connectedOrganizations")
    @JsonIgnore
    public ConnectedOrganizationCollectionRequest getConnectedOrganizations() {
        return new ConnectedOrganizationCollectionRequest(
                        contextPath.addSegment("connectedOrganizations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EntitlementManagement patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EntitlementManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EntitlementManagement put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EntitlementManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EntitlementManagement _copy() {
        EntitlementManagement _x = new EntitlementManagement();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntitlementManagement[");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
