package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CertificateStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "content", 
    "status", 
    "subjectName", 
    "subject", 
    "issuerName", 
    "issuer", 
    "expirationDateTime", 
    "uploadDateTime"})
@JsonInclude(Include.NON_NULL)
public class EnterpriseCodeSigningCertificate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.enterpriseCodeSigningCertificate";
    }

    @JsonProperty("content")
    protected byte[] content;

    @JsonProperty("status")
    protected CertificateStatus status;

    @JsonProperty("subjectName")
    protected String subjectName;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("issuerName")
    protected String issuerName;

    @JsonProperty("issuer")
    protected String issuer;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("uploadDateTime")
    protected OffsetDateTime uploadDateTime;

    protected EnterpriseCodeSigningCertificate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEnterpriseCodeSigningCertificate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private byte[] content;
        private CertificateStatus status;
        private String subjectName;
        private String subject;
        private String issuerName;
        private String issuer;
        private OffsetDateTime expirationDateTime;
        private OffsetDateTime uploadDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The Windows Enterprise Code-Signing Certificate in the raw data format.”</i>
         * 
         * @param content
         *            value of {@code content} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder content(byte[] content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        /**
         * <i>“The Certificate Status Provisioned or not Provisioned.”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(CertificateStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“The Subject Name for the cert.”</i>
         * 
         * @param subjectName
         *            value of {@code subjectName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectName(String subjectName) {
            this.subjectName = subjectName;
            this.changedFields = changedFields.add("subjectName");
            return this;
        }

        /**
         * <i>“The Subject Value for the cert.”</i>
         * 
         * @param subject
         *            value of {@code subject} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        /**
         * <i>“The Issuer Name for the cert.”</i>
         * 
         * @param issuerName
         *            value of {@code issuerName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder issuerName(String issuerName) {
            this.issuerName = issuerName;
            this.changedFields = changedFields.add("issuerName");
            return this;
        }

        /**
         * <i>“The Issuer value for the cert.”</i>
         * 
         * @param issuer
         *            value of {@code issuer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder issuer(String issuer) {
            this.issuer = issuer;
            this.changedFields = changedFields.add("issuer");
            return this;
        }

        /**
         * <i>“The Cert Expiration Date.”</i>
         * 
         * @param expirationDateTime
         *            value of {@code expirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        /**
         * <i>“The date time of CodeSigning Cert when it is uploaded.”</i>
         * 
         * @param uploadDateTime
         *            value of {@code uploadDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder uploadDateTime(OffsetDateTime uploadDateTime) {
            this.uploadDateTime = uploadDateTime;
            this.changedFields = changedFields.add("uploadDateTime");
            return this;
        }

        public EnterpriseCodeSigningCertificate build() {
            EnterpriseCodeSigningCertificate _x = new EnterpriseCodeSigningCertificate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.enterpriseCodeSigningCertificate";
            _x.id = id;
            _x.content = content;
            _x.status = status;
            _x.subjectName = subjectName;
            _x.subject = subject;
            _x.issuerName = issuerName;
            _x.issuer = issuer;
            _x.expirationDateTime = expirationDateTime;
            _x.uploadDateTime = uploadDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The Windows Enterprise Code-Signing Certificate in the raw data format.”</i>
     * 
     * @return property content
     */
    @Property(name="content")
    @JsonIgnore
    public Optional<byte[]> getContent() {
        return Optional.ofNullable(content);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code content} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Windows Enterprise Code-Signing Certificate in the raw data format.”</i>
     * 
     * @param content
     *            new value of {@code content} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code content} field changed
     */
    public EnterpriseCodeSigningCertificate withContent(byte[] content) {
        EnterpriseCodeSigningCertificate _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enterpriseCodeSigningCertificate");
        _x.content = content;
        return _x;
    }

    /**
     * <i>“The Certificate Status Provisioned or not Provisioned.”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<CertificateStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Certificate Status Provisioned or not Provisioned.”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public EnterpriseCodeSigningCertificate withStatus(CertificateStatus status) {
        EnterpriseCodeSigningCertificate _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enterpriseCodeSigningCertificate");
        _x.status = status;
        return _x;
    }

    /**
     * <i>“The Subject Name for the cert.”</i>
     * 
     * @return property subjectName
     */
    @Property(name="subjectName")
    @JsonIgnore
    public Optional<String> getSubjectName() {
        return Optional.ofNullable(subjectName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subjectName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Subject Name for the cert.”</i>
     * 
     * @param subjectName
     *            new value of {@code subjectName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectName} field changed
     */
    public EnterpriseCodeSigningCertificate withSubjectName(String subjectName) {
        EnterpriseCodeSigningCertificate _x = _copy();
        _x.changedFields = changedFields.add("subjectName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enterpriseCodeSigningCertificate");
        _x.subjectName = subjectName;
        return _x;
    }

    /**
     * <i>“The Subject Value for the cert.”</i>
     * 
     * @return property subject
     */
    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subject} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Subject Value for the cert.”</i>
     * 
     * @param subject
     *            new value of {@code subject} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subject} field changed
     */
    public EnterpriseCodeSigningCertificate withSubject(String subject) {
        EnterpriseCodeSigningCertificate _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enterpriseCodeSigningCertificate");
        _x.subject = subject;
        return _x;
    }

    /**
     * <i>“The Issuer Name for the cert.”</i>
     * 
     * @return property issuerName
     */
    @Property(name="issuerName")
    @JsonIgnore
    public Optional<String> getIssuerName() {
        return Optional.ofNullable(issuerName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code issuerName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Issuer Name for the cert.”</i>
     * 
     * @param issuerName
     *            new value of {@code issuerName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code issuerName} field changed
     */
    public EnterpriseCodeSigningCertificate withIssuerName(String issuerName) {
        EnterpriseCodeSigningCertificate _x = _copy();
        _x.changedFields = changedFields.add("issuerName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enterpriseCodeSigningCertificate");
        _x.issuerName = issuerName;
        return _x;
    }

    /**
     * <i>“The Issuer value for the cert.”</i>
     * 
     * @return property issuer
     */
    @Property(name="issuer")
    @JsonIgnore
    public Optional<String> getIssuer() {
        return Optional.ofNullable(issuer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code issuer} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Issuer value for the cert.”</i>
     * 
     * @param issuer
     *            new value of {@code issuer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code issuer} field changed
     */
    public EnterpriseCodeSigningCertificate withIssuer(String issuer) {
        EnterpriseCodeSigningCertificate _x = _copy();
        _x.changedFields = changedFields.add("issuer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enterpriseCodeSigningCertificate");
        _x.issuer = issuer;
        return _x;
    }

    /**
     * <i>“The Cert Expiration Date.”</i>
     * 
     * @return property expirationDateTime
     */
    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Cert Expiration Date.”</i>
     * 
     * @param expirationDateTime
     *            new value of {@code expirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTime} field changed
     */
    public EnterpriseCodeSigningCertificate withExpirationDateTime(OffsetDateTime expirationDateTime) {
        EnterpriseCodeSigningCertificate _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enterpriseCodeSigningCertificate");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    /**
     * <i>“The date time of CodeSigning Cert when it is uploaded.”</i>
     * 
     * @return property uploadDateTime
     */
    @Property(name="uploadDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getUploadDateTime() {
        return Optional.ofNullable(uploadDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code uploadDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date time of CodeSigning Cert when it is uploaded.”</i>
     * 
     * @param uploadDateTime
     *            new value of {@code uploadDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uploadDateTime} field changed
     */
    public EnterpriseCodeSigningCertificate withUploadDateTime(OffsetDateTime uploadDateTime) {
        EnterpriseCodeSigningCertificate _x = _copy();
        _x.changedFields = changedFields.add("uploadDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.enterpriseCodeSigningCertificate");
        _x.uploadDateTime = uploadDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EnterpriseCodeSigningCertificate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EnterpriseCodeSigningCertificate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EnterpriseCodeSigningCertificate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EnterpriseCodeSigningCertificate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EnterpriseCodeSigningCertificate _copy() {
        EnterpriseCodeSigningCertificate _x = new EnterpriseCodeSigningCertificate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.content = content;
        _x.status = status;
        _x.subjectName = subjectName;
        _x.subject = subject;
        _x.issuerName = issuerName;
        _x.issuer = issuer;
        _x.expirationDateTime = expirationDateTime;
        _x.uploadDateTime = uploadDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EnterpriseCodeSigningCertificate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("subjectName=");
        b.append(this.subjectName);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("issuerName=");
        b.append(this.issuerName);
        b.append(", ");
        b.append("issuer=");
        b.append(this.issuer);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("uploadDateTime=");
        b.append(this.uploadDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
