package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PostalAddressType;
import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "number", 
    "displayName", 
    "givenName", 
    "middleName", 
    "surname", 
    "jobTitle", 
    "address", 
    "phoneNumber", 
    "mobilePhone", 
    "email", 
    "personalEmail", 
    "employmentDate", 
    "terminationDate", 
    "status", 
    "birthDate", 
    "statisticsGroupCode", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class Employee extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.employee";
    }

    @JsonProperty("number")
    protected String number;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("givenName")
    protected String givenName;

    @JsonProperty("middleName")
    protected String middleName;

    @JsonProperty("surname")
    protected String surname;

    @JsonProperty("jobTitle")
    protected String jobTitle;

    @JsonProperty("address")
    protected PostalAddressType address;

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("mobilePhone")
    protected String mobilePhone;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("personalEmail")
    protected String personalEmail;

    @JsonProperty("employmentDate")
    protected LocalDate employmentDate;

    @JsonProperty("terminationDate")
    protected LocalDate terminationDate;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("birthDate")
    protected LocalDate birthDate;

    @JsonProperty("statisticsGroupCode")
    protected String statisticsGroupCode;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected Employee() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEmployee() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String number;
        private String displayName;
        private String givenName;
        private String middleName;
        private String surname;
        private String jobTitle;
        private PostalAddressType address;
        private String phoneNumber;
        private String mobilePhone;
        private String email;
        private String personalEmail;
        private LocalDate employmentDate;
        private LocalDate terminationDate;
        private String status;
        private LocalDate birthDate;
        private String statisticsGroupCode;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            this.changedFields = changedFields.add("givenName");
            return this;
        }

        public Builder middleName(String middleName) {
            this.middleName = middleName;
            this.changedFields = changedFields.add("middleName");
            return this;
        }

        public Builder surname(String surname) {
            this.surname = surname;
            this.changedFields = changedFields.add("surname");
            return this;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            this.changedFields = changedFields.add("jobTitle");
            return this;
        }

        public Builder address(PostalAddressType address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        public Builder mobilePhone(String mobilePhone) {
            this.mobilePhone = mobilePhone;
            this.changedFields = changedFields.add("mobilePhone");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder personalEmail(String personalEmail) {
            this.personalEmail = personalEmail;
            this.changedFields = changedFields.add("personalEmail");
            return this;
        }

        public Builder employmentDate(LocalDate employmentDate) {
            this.employmentDate = employmentDate;
            this.changedFields = changedFields.add("employmentDate");
            return this;
        }

        public Builder terminationDate(LocalDate terminationDate) {
            this.terminationDate = terminationDate;
            this.changedFields = changedFields.add("terminationDate");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder birthDate(LocalDate birthDate) {
            this.birthDate = birthDate;
            this.changedFields = changedFields.add("birthDate");
            return this;
        }

        public Builder statisticsGroupCode(String statisticsGroupCode) {
            this.statisticsGroupCode = statisticsGroupCode;
            this.changedFields = changedFields.add("statisticsGroupCode");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Employee build() {
            Employee _x = new Employee();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.employee";
            _x.id = id;
            _x.number = number;
            _x.displayName = displayName;
            _x.givenName = givenName;
            _x.middleName = middleName;
            _x.surname = surname;
            _x.jobTitle = jobTitle;
            _x.address = address;
            _x.phoneNumber = phoneNumber;
            _x.mobilePhone = mobilePhone;
            _x.email = email;
            _x.personalEmail = personalEmail;
            _x.employmentDate = employmentDate;
            _x.terminationDate = terminationDate;
            _x.status = status;
            _x.birthDate = birthDate;
            _x.statisticsGroupCode = statisticsGroupCode;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public Employee withNumber(String number) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.number = number;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Employee withDisplayName(String displayName) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="givenName")
    @JsonIgnore
    public Optional<String> getGivenName() {
        return Optional.ofNullable(givenName);
    }

    public Employee withGivenName(String givenName) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("givenName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.givenName = givenName;
        return _x;
    }

    @Property(name="middleName")
    @JsonIgnore
    public Optional<String> getMiddleName() {
        return Optional.ofNullable(middleName);
    }

    public Employee withMiddleName(String middleName) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("middleName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.middleName = middleName;
        return _x;
    }

    @Property(name="surname")
    @JsonIgnore
    public Optional<String> getSurname() {
        return Optional.ofNullable(surname);
    }

    public Employee withSurname(String surname) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("surname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.surname = surname;
        return _x;
    }

    @Property(name="jobTitle")
    @JsonIgnore
    public Optional<String> getJobTitle() {
        return Optional.ofNullable(jobTitle);
    }

    public Employee withJobTitle(String jobTitle) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("jobTitle");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.jobTitle = jobTitle;
        return _x;
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<PostalAddressType> getAddress() {
        return Optional.ofNullable(address);
    }

    public Employee withAddress(PostalAddressType address) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("address");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.address = address;
        return _x;
    }

    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    public Employee withPhoneNumber(String phoneNumber) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("phoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    @Property(name="mobilePhone")
    @JsonIgnore
    public Optional<String> getMobilePhone() {
        return Optional.ofNullable(mobilePhone);
    }

    public Employee withMobilePhone(String mobilePhone) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("mobilePhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.mobilePhone = mobilePhone;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public Employee withEmail(String email) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.email = email;
        return _x;
    }

    @Property(name="personalEmail")
    @JsonIgnore
    public Optional<String> getPersonalEmail() {
        return Optional.ofNullable(personalEmail);
    }

    public Employee withPersonalEmail(String personalEmail) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("personalEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.personalEmail = personalEmail;
        return _x;
    }

    @Property(name="employmentDate")
    @JsonIgnore
    public Optional<LocalDate> getEmploymentDate() {
        return Optional.ofNullable(employmentDate);
    }

    public Employee withEmploymentDate(LocalDate employmentDate) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("employmentDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.employmentDate = employmentDate;
        return _x;
    }

    @Property(name="terminationDate")
    @JsonIgnore
    public Optional<LocalDate> getTerminationDate() {
        return Optional.ofNullable(terminationDate);
    }

    public Employee withTerminationDate(LocalDate terminationDate) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("terminationDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.terminationDate = terminationDate;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public Employee withStatus(String status) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.status = status;
        return _x;
    }

    @Property(name="birthDate")
    @JsonIgnore
    public Optional<LocalDate> getBirthDate() {
        return Optional.ofNullable(birthDate);
    }

    public Employee withBirthDate(LocalDate birthDate) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("birthDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.birthDate = birthDate;
        return _x;
    }

    @Property(name="statisticsGroupCode")
    @JsonIgnore
    public Optional<String> getStatisticsGroupCode() {
        return Optional.ofNullable(statisticsGroupCode);
    }

    public Employee withStatisticsGroupCode(String statisticsGroupCode) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("statisticsGroupCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.statisticsGroupCode = statisticsGroupCode;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Employee withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Employee _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.employee");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @NavigationProperty(name="picture")
    @JsonIgnore
    public PictureCollectionRequest getPicture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Employee patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Employee _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Employee put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Employee _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Employee _copy() {
        Employee _x = new Employee();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.number = number;
        _x.displayName = displayName;
        _x.givenName = givenName;
        _x.middleName = middleName;
        _x.surname = surname;
        _x.jobTitle = jobTitle;
        _x.address = address;
        _x.phoneNumber = phoneNumber;
        _x.mobilePhone = mobilePhone;
        _x.email = email;
        _x.personalEmail = personalEmail;
        _x.employmentDate = employmentDate;
        _x.terminationDate = terminationDate;
        _x.status = status;
        _x.birthDate = birthDate;
        _x.statisticsGroupCode = statisticsGroupCode;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Employee[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("givenName=");
        b.append(this.givenName);
        b.append(", ");
        b.append("middleName=");
        b.append(this.middleName);
        b.append(", ");
        b.append("surname=");
        b.append(this.surname);
        b.append(", ");
        b.append("jobTitle=");
        b.append(this.jobTitle);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("mobilePhone=");
        b.append(this.mobilePhone);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("personalEmail=");
        b.append(this.personalEmail);
        b.append(", ");
        b.append("employmentDate=");
        b.append(this.employmentDate);
        b.append(", ");
        b.append("terminationDate=");
        b.append(this.terminationDate);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("birthDate=");
        b.append(this.birthDate);
        b.append(", ");
        b.append("statisticsGroupCode=");
        b.append(this.statisticsGroupCode);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
