package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "outlook2016", 
    "outlook2013", 
    "outlook2010", 
    "outlook2007", 
    "undetermined", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class EmailAppUsageVersionsUserCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.emailAppUsageVersionsUserCounts";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("outlook2016")
    protected Long outlook2016;

    @JsonProperty("outlook2013")
    protected Long outlook2013;

    @JsonProperty("outlook2010")
    protected Long outlook2010;

    @JsonProperty("outlook2007")
    protected Long outlook2007;

    @JsonProperty("undetermined")
    protected Long undetermined;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected EmailAppUsageVersionsUserCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEmailAppUsageVersionsUserCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private Long outlook2016;
        private Long outlook2013;
        private Long outlook2010;
        private Long outlook2007;
        private Long undetermined;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder outlook2016(Long outlook2016) {
            this.outlook2016 = outlook2016;
            this.changedFields = changedFields.add("outlook2016");
            return this;
        }

        public Builder outlook2013(Long outlook2013) {
            this.outlook2013 = outlook2013;
            this.changedFields = changedFields.add("outlook2013");
            return this;
        }

        public Builder outlook2010(Long outlook2010) {
            this.outlook2010 = outlook2010;
            this.changedFields = changedFields.add("outlook2010");
            return this;
        }

        public Builder outlook2007(Long outlook2007) {
            this.outlook2007 = outlook2007;
            this.changedFields = changedFields.add("outlook2007");
            return this;
        }

        public Builder undetermined(Long undetermined) {
            this.undetermined = undetermined;
            this.changedFields = changedFields.add("undetermined");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public EmailAppUsageVersionsUserCounts build() {
            EmailAppUsageVersionsUserCounts _x = new EmailAppUsageVersionsUserCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.emailAppUsageVersionsUserCounts";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.outlook2016 = outlook2016;
            _x.outlook2013 = outlook2013;
            _x.outlook2010 = outlook2010;
            _x.outlook2007 = outlook2007;
            _x.undetermined = undetermined;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public EmailAppUsageVersionsUserCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        EmailAppUsageVersionsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageVersionsUserCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="outlook2016")
    @JsonIgnore
    public Optional<Long> getOutlook2016() {
        return Optional.ofNullable(outlook2016);
    }

    public EmailAppUsageVersionsUserCounts withOutlook2016(Long outlook2016) {
        EmailAppUsageVersionsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("outlook2016");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageVersionsUserCounts");
        _x.outlook2016 = outlook2016;
        return _x;
    }

    @Property(name="outlook2013")
    @JsonIgnore
    public Optional<Long> getOutlook2013() {
        return Optional.ofNullable(outlook2013);
    }

    public EmailAppUsageVersionsUserCounts withOutlook2013(Long outlook2013) {
        EmailAppUsageVersionsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("outlook2013");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageVersionsUserCounts");
        _x.outlook2013 = outlook2013;
        return _x;
    }

    @Property(name="outlook2010")
    @JsonIgnore
    public Optional<Long> getOutlook2010() {
        return Optional.ofNullable(outlook2010);
    }

    public EmailAppUsageVersionsUserCounts withOutlook2010(Long outlook2010) {
        EmailAppUsageVersionsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("outlook2010");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageVersionsUserCounts");
        _x.outlook2010 = outlook2010;
        return _x;
    }

    @Property(name="outlook2007")
    @JsonIgnore
    public Optional<Long> getOutlook2007() {
        return Optional.ofNullable(outlook2007);
    }

    public EmailAppUsageVersionsUserCounts withOutlook2007(Long outlook2007) {
        EmailAppUsageVersionsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("outlook2007");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageVersionsUserCounts");
        _x.outlook2007 = outlook2007;
        return _x;
    }

    @Property(name="undetermined")
    @JsonIgnore
    public Optional<Long> getUndetermined() {
        return Optional.ofNullable(undetermined);
    }

    public EmailAppUsageVersionsUserCounts withUndetermined(Long undetermined) {
        EmailAppUsageVersionsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("undetermined");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageVersionsUserCounts");
        _x.undetermined = undetermined;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public EmailAppUsageVersionsUserCounts withReportPeriod(String reportPeriod) {
        EmailAppUsageVersionsUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageVersionsUserCounts");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailAppUsageVersionsUserCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EmailAppUsageVersionsUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailAppUsageVersionsUserCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EmailAppUsageVersionsUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EmailAppUsageVersionsUserCounts _copy() {
        EmailAppUsageVersionsUserCounts _x = new EmailAppUsageVersionsUserCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.outlook2016 = outlook2016;
        _x.outlook2013 = outlook2013;
        _x.outlook2010 = outlook2010;
        _x.outlook2007 = outlook2007;
        _x.undetermined = undetermined;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmailAppUsageVersionsUserCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("outlook2016=");
        b.append(this.outlook2016);
        b.append(", ");
        b.append("outlook2013=");
        b.append(this.outlook2013);
        b.append(", ");
        b.append("outlook2010=");
        b.append(this.outlook2010);
        b.append(", ");
        b.append("outlook2007=");
        b.append(this.outlook2007);
        b.append(", ");
        b.append("undetermined=");
        b.append(this.undetermined);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
