package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "displayName", 
    "isDeleted", 
    "deletedDate", 
    "lastActivityDate", 
    "mailForMac", 
    "outlookForMac", 
    "outlookForWindows", 
    "outlookForMobile", 
    "otherForMobile", 
    "outlookForWeb", 
    "pop3App", 
    "imap4App", 
    "smtpApp", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class EmailAppUsageUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.emailAppUsageUserDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("deletedDate")
    protected LocalDate deletedDate;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("mailForMac")
    protected List<String> mailForMac;

    @JsonProperty("mailForMac@nextLink")
    protected String mailForMacNextLink;

    @JsonProperty("outlookForMac")
    protected List<String> outlookForMac;

    @JsonProperty("outlookForMac@nextLink")
    protected String outlookForMacNextLink;

    @JsonProperty("outlookForWindows")
    protected List<String> outlookForWindows;

    @JsonProperty("outlookForWindows@nextLink")
    protected String outlookForWindowsNextLink;

    @JsonProperty("outlookForMobile")
    protected List<String> outlookForMobile;

    @JsonProperty("outlookForMobile@nextLink")
    protected String outlookForMobileNextLink;

    @JsonProperty("otherForMobile")
    protected List<String> otherForMobile;

    @JsonProperty("otherForMobile@nextLink")
    protected String otherForMobileNextLink;

    @JsonProperty("outlookForWeb")
    protected List<String> outlookForWeb;

    @JsonProperty("outlookForWeb@nextLink")
    protected String outlookForWebNextLink;

    @JsonProperty("pop3App")
    protected List<String> pop3App;

    @JsonProperty("pop3App@nextLink")
    protected String pop3AppNextLink;

    @JsonProperty("imap4App")
    protected List<String> imap4App;

    @JsonProperty("imap4App@nextLink")
    protected String imap4AppNextLink;

    @JsonProperty("smtpApp")
    protected List<String> smtpApp;

    @JsonProperty("smtpApp@nextLink")
    protected String smtpAppNextLink;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected EmailAppUsageUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEmailAppUsageUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private String displayName;
        private Boolean isDeleted;
        private LocalDate deletedDate;
        private LocalDate lastActivityDate;
        private List<String> mailForMac;
        private String mailForMacNextLink;
        private List<String> outlookForMac;
        private String outlookForMacNextLink;
        private List<String> outlookForWindows;
        private String outlookForWindowsNextLink;
        private List<String> outlookForMobile;
        private String outlookForMobileNextLink;
        private List<String> otherForMobile;
        private String otherForMobileNextLink;
        private List<String> outlookForWeb;
        private String outlookForWebNextLink;
        private List<String> pop3App;
        private String pop3AppNextLink;
        private List<String> imap4App;
        private String imap4AppNextLink;
        private List<String> smtpApp;
        private String smtpAppNextLink;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder deletedDate(LocalDate deletedDate) {
            this.deletedDate = deletedDate;
            this.changedFields = changedFields.add("deletedDate");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder mailForMac(List<String> mailForMac) {
            this.mailForMac = mailForMac;
            this.changedFields = changedFields.add("mailForMac");
            return this;
        }

        public Builder mailForMac(String... mailForMac) {
            return mailForMac(Arrays.asList(mailForMac));
        }

        public Builder mailForMacNextLink(String mailForMacNextLink) {
            this.mailForMacNextLink = mailForMacNextLink;
            this.changedFields = changedFields.add("mailForMac");
            return this;
        }

        public Builder outlookForMac(List<String> outlookForMac) {
            this.outlookForMac = outlookForMac;
            this.changedFields = changedFields.add("outlookForMac");
            return this;
        }

        public Builder outlookForMac(String... outlookForMac) {
            return outlookForMac(Arrays.asList(outlookForMac));
        }

        public Builder outlookForMacNextLink(String outlookForMacNextLink) {
            this.outlookForMacNextLink = outlookForMacNextLink;
            this.changedFields = changedFields.add("outlookForMac");
            return this;
        }

        public Builder outlookForWindows(List<String> outlookForWindows) {
            this.outlookForWindows = outlookForWindows;
            this.changedFields = changedFields.add("outlookForWindows");
            return this;
        }

        public Builder outlookForWindows(String... outlookForWindows) {
            return outlookForWindows(Arrays.asList(outlookForWindows));
        }

        public Builder outlookForWindowsNextLink(String outlookForWindowsNextLink) {
            this.outlookForWindowsNextLink = outlookForWindowsNextLink;
            this.changedFields = changedFields.add("outlookForWindows");
            return this;
        }

        public Builder outlookForMobile(List<String> outlookForMobile) {
            this.outlookForMobile = outlookForMobile;
            this.changedFields = changedFields.add("outlookForMobile");
            return this;
        }

        public Builder outlookForMobile(String... outlookForMobile) {
            return outlookForMobile(Arrays.asList(outlookForMobile));
        }

        public Builder outlookForMobileNextLink(String outlookForMobileNextLink) {
            this.outlookForMobileNextLink = outlookForMobileNextLink;
            this.changedFields = changedFields.add("outlookForMobile");
            return this;
        }

        public Builder otherForMobile(List<String> otherForMobile) {
            this.otherForMobile = otherForMobile;
            this.changedFields = changedFields.add("otherForMobile");
            return this;
        }

        public Builder otherForMobile(String... otherForMobile) {
            return otherForMobile(Arrays.asList(otherForMobile));
        }

        public Builder otherForMobileNextLink(String otherForMobileNextLink) {
            this.otherForMobileNextLink = otherForMobileNextLink;
            this.changedFields = changedFields.add("otherForMobile");
            return this;
        }

        public Builder outlookForWeb(List<String> outlookForWeb) {
            this.outlookForWeb = outlookForWeb;
            this.changedFields = changedFields.add("outlookForWeb");
            return this;
        }

        public Builder outlookForWeb(String... outlookForWeb) {
            return outlookForWeb(Arrays.asList(outlookForWeb));
        }

        public Builder outlookForWebNextLink(String outlookForWebNextLink) {
            this.outlookForWebNextLink = outlookForWebNextLink;
            this.changedFields = changedFields.add("outlookForWeb");
            return this;
        }

        public Builder pop3App(List<String> pop3App) {
            this.pop3App = pop3App;
            this.changedFields = changedFields.add("pop3App");
            return this;
        }

        public Builder pop3App(String... pop3App) {
            return pop3App(Arrays.asList(pop3App));
        }

        public Builder pop3AppNextLink(String pop3AppNextLink) {
            this.pop3AppNextLink = pop3AppNextLink;
            this.changedFields = changedFields.add("pop3App");
            return this;
        }

        public Builder imap4App(List<String> imap4App) {
            this.imap4App = imap4App;
            this.changedFields = changedFields.add("imap4App");
            return this;
        }

        public Builder imap4App(String... imap4App) {
            return imap4App(Arrays.asList(imap4App));
        }

        public Builder imap4AppNextLink(String imap4AppNextLink) {
            this.imap4AppNextLink = imap4AppNextLink;
            this.changedFields = changedFields.add("imap4App");
            return this;
        }

        public Builder smtpApp(List<String> smtpApp) {
            this.smtpApp = smtpApp;
            this.changedFields = changedFields.add("smtpApp");
            return this;
        }

        public Builder smtpApp(String... smtpApp) {
            return smtpApp(Arrays.asList(smtpApp));
        }

        public Builder smtpAppNextLink(String smtpAppNextLink) {
            this.smtpAppNextLink = smtpAppNextLink;
            this.changedFields = changedFields.add("smtpApp");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public EmailAppUsageUserDetail build() {
            EmailAppUsageUserDetail _x = new EmailAppUsageUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.emailAppUsageUserDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.displayName = displayName;
            _x.isDeleted = isDeleted;
            _x.deletedDate = deletedDate;
            _x.lastActivityDate = lastActivityDate;
            _x.mailForMac = mailForMac;
            _x.mailForMacNextLink = mailForMacNextLink;
            _x.outlookForMac = outlookForMac;
            _x.outlookForMacNextLink = outlookForMacNextLink;
            _x.outlookForWindows = outlookForWindows;
            _x.outlookForWindowsNextLink = outlookForWindowsNextLink;
            _x.outlookForMobile = outlookForMobile;
            _x.outlookForMobileNextLink = outlookForMobileNextLink;
            _x.otherForMobile = otherForMobile;
            _x.otherForMobileNextLink = otherForMobileNextLink;
            _x.outlookForWeb = outlookForWeb;
            _x.outlookForWebNextLink = outlookForWebNextLink;
            _x.pop3App = pop3App;
            _x.pop3AppNextLink = pop3AppNextLink;
            _x.imap4App = imap4App;
            _x.imap4AppNextLink = imap4AppNextLink;
            _x.smtpApp = smtpApp;
            _x.smtpAppNextLink = smtpAppNextLink;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public EmailAppUsageUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        EmailAppUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public EmailAppUsageUserDetail withUserPrincipalName(String userPrincipalName) {
        EmailAppUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EmailAppUsageUserDetail withDisplayName(String displayName) {
        EmailAppUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public EmailAppUsageUserDetail withIsDeleted(Boolean isDeleted) {
        EmailAppUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="deletedDate")
    @JsonIgnore
    public Optional<LocalDate> getDeletedDate() {
        return Optional.ofNullable(deletedDate);
    }

    public EmailAppUsageUserDetail withDeletedDate(LocalDate deletedDate) {
        EmailAppUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("deletedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserDetail");
        _x.deletedDate = deletedDate;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public EmailAppUsageUserDetail withLastActivityDate(LocalDate lastActivityDate) {
        EmailAppUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="mailForMac")
    @JsonIgnore
    public CollectionPage<String> getMailForMac() {
        return new CollectionPage<String>(contextPath, String.class, mailForMac, Optional.ofNullable(mailForMacNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="mailForMac")
    @JsonIgnore
    public CollectionPage<String> getMailForMac(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, mailForMac, Optional.ofNullable(mailForMacNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="outlookForMac")
    @JsonIgnore
    public CollectionPage<String> getOutlookForMac() {
        return new CollectionPage<String>(contextPath, String.class, outlookForMac, Optional.ofNullable(outlookForMacNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="outlookForMac")
    @JsonIgnore
    public CollectionPage<String> getOutlookForMac(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, outlookForMac, Optional.ofNullable(outlookForMacNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="outlookForWindows")
    @JsonIgnore
    public CollectionPage<String> getOutlookForWindows() {
        return new CollectionPage<String>(contextPath, String.class, outlookForWindows, Optional.ofNullable(outlookForWindowsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="outlookForWindows")
    @JsonIgnore
    public CollectionPage<String> getOutlookForWindows(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, outlookForWindows, Optional.ofNullable(outlookForWindowsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="outlookForMobile")
    @JsonIgnore
    public CollectionPage<String> getOutlookForMobile() {
        return new CollectionPage<String>(contextPath, String.class, outlookForMobile, Optional.ofNullable(outlookForMobileNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="outlookForMobile")
    @JsonIgnore
    public CollectionPage<String> getOutlookForMobile(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, outlookForMobile, Optional.ofNullable(outlookForMobileNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="otherForMobile")
    @JsonIgnore
    public CollectionPage<String> getOtherForMobile() {
        return new CollectionPage<String>(contextPath, String.class, otherForMobile, Optional.ofNullable(otherForMobileNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="otherForMobile")
    @JsonIgnore
    public CollectionPage<String> getOtherForMobile(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, otherForMobile, Optional.ofNullable(otherForMobileNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="outlookForWeb")
    @JsonIgnore
    public CollectionPage<String> getOutlookForWeb() {
        return new CollectionPage<String>(contextPath, String.class, outlookForWeb, Optional.ofNullable(outlookForWebNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="outlookForWeb")
    @JsonIgnore
    public CollectionPage<String> getOutlookForWeb(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, outlookForWeb, Optional.ofNullable(outlookForWebNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="pop3App")
    @JsonIgnore
    public CollectionPage<String> getPop3App() {
        return new CollectionPage<String>(contextPath, String.class, pop3App, Optional.ofNullable(pop3AppNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="pop3App")
    @JsonIgnore
    public CollectionPage<String> getPop3App(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, pop3App, Optional.ofNullable(pop3AppNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="imap4App")
    @JsonIgnore
    public CollectionPage<String> getImap4App() {
        return new CollectionPage<String>(contextPath, String.class, imap4App, Optional.ofNullable(imap4AppNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="imap4App")
    @JsonIgnore
    public CollectionPage<String> getImap4App(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, imap4App, Optional.ofNullable(imap4AppNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="smtpApp")
    @JsonIgnore
    public CollectionPage<String> getSmtpApp() {
        return new CollectionPage<String>(contextPath, String.class, smtpApp, Optional.ofNullable(smtpAppNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="smtpApp")
    @JsonIgnore
    public CollectionPage<String> getSmtpApp(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, smtpApp, Optional.ofNullable(smtpAppNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public EmailAppUsageUserDetail withReportPeriod(String reportPeriod) {
        EmailAppUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailAppUsageUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EmailAppUsageUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailAppUsageUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EmailAppUsageUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EmailAppUsageUserDetail _copy() {
        EmailAppUsageUserDetail _x = new EmailAppUsageUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.displayName = displayName;
        _x.isDeleted = isDeleted;
        _x.deletedDate = deletedDate;
        _x.lastActivityDate = lastActivityDate;
        _x.mailForMac = mailForMac;
        _x.outlookForMac = outlookForMac;
        _x.outlookForWindows = outlookForWindows;
        _x.outlookForMobile = outlookForMobile;
        _x.otherForMobile = otherForMobile;
        _x.outlookForWeb = outlookForWeb;
        _x.pop3App = pop3App;
        _x.imap4App = imap4App;
        _x.smtpApp = smtpApp;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmailAppUsageUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("deletedDate=");
        b.append(this.deletedDate);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("mailForMac=");
        b.append(this.mailForMac);
        b.append(", ");
        b.append("outlookForMac=");
        b.append(this.outlookForMac);
        b.append(", ");
        b.append("outlookForWindows=");
        b.append(this.outlookForWindows);
        b.append(", ");
        b.append("outlookForMobile=");
        b.append(this.outlookForMobile);
        b.append(", ");
        b.append("otherForMobile=");
        b.append(this.otherForMobile);
        b.append(", ");
        b.append("outlookForWeb=");
        b.append(this.outlookForWeb);
        b.append(", ");
        b.append("pop3App=");
        b.append(this.pop3App);
        b.append(", ");
        b.append("imap4App=");
        b.append(this.imap4App);
        b.append(", ");
        b.append("smtpApp=");
        b.append(this.smtpApp);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
