package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "mailForMac", 
    "outlookForMac", 
    "outlookForWindows", 
    "outlookForMobile", 
    "otherForMobile", 
    "outlookForWeb", 
    "pop3App", 
    "imap4App", 
    "smtpApp", 
    "reportDate", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class EmailAppUsageUserCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.emailAppUsageUserCounts";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("mailForMac")
    protected Long mailForMac;

    @JsonProperty("outlookForMac")
    protected Long outlookForMac;

    @JsonProperty("outlookForWindows")
    protected Long outlookForWindows;

    @JsonProperty("outlookForMobile")
    protected Long outlookForMobile;

    @JsonProperty("otherForMobile")
    protected Long otherForMobile;

    @JsonProperty("outlookForWeb")
    protected Long outlookForWeb;

    @JsonProperty("pop3App")
    protected Long pop3App;

    @JsonProperty("imap4App")
    protected Long imap4App;

    @JsonProperty("smtpApp")
    protected Long smtpApp;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected EmailAppUsageUserCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEmailAppUsageUserCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private Long mailForMac;
        private Long outlookForMac;
        private Long outlookForWindows;
        private Long outlookForMobile;
        private Long otherForMobile;
        private Long outlookForWeb;
        private Long pop3App;
        private Long imap4App;
        private Long smtpApp;
        private LocalDate reportDate;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder mailForMac(Long mailForMac) {
            this.mailForMac = mailForMac;
            this.changedFields = changedFields.add("mailForMac");
            return this;
        }

        public Builder outlookForMac(Long outlookForMac) {
            this.outlookForMac = outlookForMac;
            this.changedFields = changedFields.add("outlookForMac");
            return this;
        }

        public Builder outlookForWindows(Long outlookForWindows) {
            this.outlookForWindows = outlookForWindows;
            this.changedFields = changedFields.add("outlookForWindows");
            return this;
        }

        public Builder outlookForMobile(Long outlookForMobile) {
            this.outlookForMobile = outlookForMobile;
            this.changedFields = changedFields.add("outlookForMobile");
            return this;
        }

        public Builder otherForMobile(Long otherForMobile) {
            this.otherForMobile = otherForMobile;
            this.changedFields = changedFields.add("otherForMobile");
            return this;
        }

        public Builder outlookForWeb(Long outlookForWeb) {
            this.outlookForWeb = outlookForWeb;
            this.changedFields = changedFields.add("outlookForWeb");
            return this;
        }

        public Builder pop3App(Long pop3App) {
            this.pop3App = pop3App;
            this.changedFields = changedFields.add("pop3App");
            return this;
        }

        public Builder imap4App(Long imap4App) {
            this.imap4App = imap4App;
            this.changedFields = changedFields.add("imap4App");
            return this;
        }

        public Builder smtpApp(Long smtpApp) {
            this.smtpApp = smtpApp;
            this.changedFields = changedFields.add("smtpApp");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public EmailAppUsageUserCounts build() {
            EmailAppUsageUserCounts _x = new EmailAppUsageUserCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.emailAppUsageUserCounts";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.mailForMac = mailForMac;
            _x.outlookForMac = outlookForMac;
            _x.outlookForWindows = outlookForWindows;
            _x.outlookForMobile = outlookForMobile;
            _x.otherForMobile = otherForMobile;
            _x.outlookForWeb = outlookForWeb;
            _x.pop3App = pop3App;
            _x.imap4App = imap4App;
            _x.smtpApp = smtpApp;
            _x.reportDate = reportDate;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public EmailAppUsageUserCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="mailForMac")
    @JsonIgnore
    public Optional<Long> getMailForMac() {
        return Optional.ofNullable(mailForMac);
    }

    public EmailAppUsageUserCounts withMailForMac(Long mailForMac) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("mailForMac");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.mailForMac = mailForMac;
        return _x;
    }

    @Property(name="outlookForMac")
    @JsonIgnore
    public Optional<Long> getOutlookForMac() {
        return Optional.ofNullable(outlookForMac);
    }

    public EmailAppUsageUserCounts withOutlookForMac(Long outlookForMac) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("outlookForMac");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.outlookForMac = outlookForMac;
        return _x;
    }

    @Property(name="outlookForWindows")
    @JsonIgnore
    public Optional<Long> getOutlookForWindows() {
        return Optional.ofNullable(outlookForWindows);
    }

    public EmailAppUsageUserCounts withOutlookForWindows(Long outlookForWindows) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("outlookForWindows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.outlookForWindows = outlookForWindows;
        return _x;
    }

    @Property(name="outlookForMobile")
    @JsonIgnore
    public Optional<Long> getOutlookForMobile() {
        return Optional.ofNullable(outlookForMobile);
    }

    public EmailAppUsageUserCounts withOutlookForMobile(Long outlookForMobile) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("outlookForMobile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.outlookForMobile = outlookForMobile;
        return _x;
    }

    @Property(name="otherForMobile")
    @JsonIgnore
    public Optional<Long> getOtherForMobile() {
        return Optional.ofNullable(otherForMobile);
    }

    public EmailAppUsageUserCounts withOtherForMobile(Long otherForMobile) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("otherForMobile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.otherForMobile = otherForMobile;
        return _x;
    }

    @Property(name="outlookForWeb")
    @JsonIgnore
    public Optional<Long> getOutlookForWeb() {
        return Optional.ofNullable(outlookForWeb);
    }

    public EmailAppUsageUserCounts withOutlookForWeb(Long outlookForWeb) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("outlookForWeb");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.outlookForWeb = outlookForWeb;
        return _x;
    }

    @Property(name="pop3App")
    @JsonIgnore
    public Optional<Long> getPop3App() {
        return Optional.ofNullable(pop3App);
    }

    public EmailAppUsageUserCounts withPop3App(Long pop3App) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("pop3App");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.pop3App = pop3App;
        return _x;
    }

    @Property(name="imap4App")
    @JsonIgnore
    public Optional<Long> getImap4App() {
        return Optional.ofNullable(imap4App);
    }

    public EmailAppUsageUserCounts withImap4App(Long imap4App) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("imap4App");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.imap4App = imap4App;
        return _x;
    }

    @Property(name="smtpApp")
    @JsonIgnore
    public Optional<Long> getSmtpApp() {
        return Optional.ofNullable(smtpApp);
    }

    public EmailAppUsageUserCounts withSmtpApp(Long smtpApp) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("smtpApp");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.smtpApp = smtpApp;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public EmailAppUsageUserCounts withReportDate(LocalDate reportDate) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public EmailAppUsageUserCounts withReportPeriod(String reportPeriod) {
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAppUsageUserCounts");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailAppUsageUserCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailAppUsageUserCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EmailAppUsageUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EmailAppUsageUserCounts _copy() {
        EmailAppUsageUserCounts _x = new EmailAppUsageUserCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.mailForMac = mailForMac;
        _x.outlookForMac = outlookForMac;
        _x.outlookForWindows = outlookForWindows;
        _x.outlookForMobile = outlookForMobile;
        _x.otherForMobile = otherForMobile;
        _x.outlookForWeb = outlookForWeb;
        _x.pop3App = pop3App;
        _x.imap4App = imap4App;
        _x.smtpApp = smtpApp;
        _x.reportDate = reportDate;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmailAppUsageUserCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("mailForMac=");
        b.append(this.mailForMac);
        b.append(", ");
        b.append("outlookForMac=");
        b.append(this.outlookForMac);
        b.append(", ");
        b.append("outlookForWindows=");
        b.append(this.outlookForWindows);
        b.append(", ");
        b.append("outlookForMobile=");
        b.append(this.outlookForMobile);
        b.append(", ");
        b.append("otherForMobile=");
        b.append(this.otherForMobile);
        b.append(", ");
        b.append("outlookForWeb=");
        b.append(this.outlookForWeb);
        b.append(", ");
        b.append("pop3App=");
        b.append(this.pop3App);
        b.append(", ");
        b.append("imap4App=");
        b.append(this.imap4App);
        b.append(", ");
        b.append("smtpApp=");
        b.append(this.smtpApp);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
