package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "displayName", 
    "isDeleted", 
    "deletedDate", 
    "lastActivityDate", 
    "sendCount", 
    "receiveCount", 
    "readCount", 
    "assignedProducts", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class EmailActivityUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.emailActivityUserDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("deletedDate")
    protected LocalDate deletedDate;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("sendCount")
    protected Long sendCount;

    @JsonProperty("receiveCount")
    protected Long receiveCount;

    @JsonProperty("readCount")
    protected Long readCount;

    @JsonProperty("assignedProducts")
    protected List<String> assignedProducts;

    @JsonProperty("assignedProducts@nextLink")
    protected String assignedProductsNextLink;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected EmailActivityUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEmailActivityUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private String displayName;
        private Boolean isDeleted;
        private LocalDate deletedDate;
        private LocalDate lastActivityDate;
        private Long sendCount;
        private Long receiveCount;
        private Long readCount;
        private List<String> assignedProducts;
        private String assignedProductsNextLink;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder deletedDate(LocalDate deletedDate) {
            this.deletedDate = deletedDate;
            this.changedFields = changedFields.add("deletedDate");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder sendCount(Long sendCount) {
            this.sendCount = sendCount;
            this.changedFields = changedFields.add("sendCount");
            return this;
        }

        public Builder receiveCount(Long receiveCount) {
            this.receiveCount = receiveCount;
            this.changedFields = changedFields.add("receiveCount");
            return this;
        }

        public Builder readCount(Long readCount) {
            this.readCount = readCount;
            this.changedFields = changedFields.add("readCount");
            return this;
        }

        public Builder assignedProducts(List<String> assignedProducts) {
            this.assignedProducts = assignedProducts;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder assignedProducts(String... assignedProducts) {
            return assignedProducts(Arrays.asList(assignedProducts));
        }

        public Builder assignedProductsNextLink(String assignedProductsNextLink) {
            this.assignedProductsNextLink = assignedProductsNextLink;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public EmailActivityUserDetail build() {
            EmailActivityUserDetail _x = new EmailActivityUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.emailActivityUserDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.displayName = displayName;
            _x.isDeleted = isDeleted;
            _x.deletedDate = deletedDate;
            _x.lastActivityDate = lastActivityDate;
            _x.sendCount = sendCount;
            _x.receiveCount = receiveCount;
            _x.readCount = readCount;
            _x.assignedProducts = assignedProducts;
            _x.assignedProductsNextLink = assignedProductsNextLink;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public EmailActivityUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivityUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public EmailActivityUserDetail withUserPrincipalName(String userPrincipalName) {
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivityUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EmailActivityUserDetail withDisplayName(String displayName) {
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivityUserDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public EmailActivityUserDetail withIsDeleted(Boolean isDeleted) {
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivityUserDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="deletedDate")
    @JsonIgnore
    public Optional<LocalDate> getDeletedDate() {
        return Optional.ofNullable(deletedDate);
    }

    public EmailActivityUserDetail withDeletedDate(LocalDate deletedDate) {
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("deletedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivityUserDetail");
        _x.deletedDate = deletedDate;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public EmailActivityUserDetail withLastActivityDate(LocalDate lastActivityDate) {
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivityUserDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="sendCount")
    @JsonIgnore
    public Optional<Long> getSendCount() {
        return Optional.ofNullable(sendCount);
    }

    public EmailActivityUserDetail withSendCount(Long sendCount) {
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("sendCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivityUserDetail");
        _x.sendCount = sendCount;
        return _x;
    }

    @Property(name="receiveCount")
    @JsonIgnore
    public Optional<Long> getReceiveCount() {
        return Optional.ofNullable(receiveCount);
    }

    public EmailActivityUserDetail withReceiveCount(Long receiveCount) {
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("receiveCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivityUserDetail");
        _x.receiveCount = receiveCount;
        return _x;
    }

    @Property(name="readCount")
    @JsonIgnore
    public Optional<Long> getReadCount() {
        return Optional.ofNullable(readCount);
    }

    public EmailActivityUserDetail withReadCount(Long readCount) {
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("readCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivityUserDetail");
        _x.readCount = readCount;
        return _x;
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts() {
        return new CollectionPage<String>(contextPath, String.class, assignedProducts, Optional.ofNullable(assignedProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, assignedProducts, Optional.ofNullable(assignedProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public EmailActivityUserDetail withReportPeriod(String reportPeriod) {
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivityUserDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailActivityUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailActivityUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EmailActivityUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EmailActivityUserDetail _copy() {
        EmailActivityUserDetail _x = new EmailActivityUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.displayName = displayName;
        _x.isDeleted = isDeleted;
        _x.deletedDate = deletedDate;
        _x.lastActivityDate = lastActivityDate;
        _x.sendCount = sendCount;
        _x.receiveCount = receiveCount;
        _x.readCount = readCount;
        _x.assignedProducts = assignedProducts;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmailActivityUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("deletedDate=");
        b.append(this.deletedDate);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("sendCount=");
        b.append(this.sendCount);
        b.append(", ");
        b.append("receiveCount=");
        b.append(this.receiveCount);
        b.append(", ");
        b.append("readCount=");
        b.append(this.readCount);
        b.append(", ");
        b.append("assignedProducts=");
        b.append(this.assignedProducts);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
