package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "send", 
    "receive", 
    "read", 
    "reportDate", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class EmailActivitySummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.emailActivitySummary";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("send")
    protected Long send;

    @JsonProperty("receive")
    protected Long receive;

    @JsonProperty("read")
    protected Long read;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected EmailActivitySummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEmailActivitySummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private Long send;
        private Long receive;
        private Long read;
        private LocalDate reportDate;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder send(Long send) {
            this.send = send;
            this.changedFields = changedFields.add("send");
            return this;
        }

        public Builder receive(Long receive) {
            this.receive = receive;
            this.changedFields = changedFields.add("receive");
            return this;
        }

        public Builder read(Long read) {
            this.read = read;
            this.changedFields = changedFields.add("read");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public EmailActivitySummary build() {
            EmailActivitySummary _x = new EmailActivitySummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.emailActivitySummary";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.send = send;
            _x.receive = receive;
            _x.read = read;
            _x.reportDate = reportDate;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public EmailActivitySummary withReportRefreshDate(LocalDate reportRefreshDate) {
        EmailActivitySummary _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivitySummary");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="send")
    @JsonIgnore
    public Optional<Long> getSend() {
        return Optional.ofNullable(send);
    }

    public EmailActivitySummary withSend(Long send) {
        EmailActivitySummary _x = _copy();
        _x.changedFields = changedFields.add("send");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivitySummary");
        _x.send = send;
        return _x;
    }

    @Property(name="receive")
    @JsonIgnore
    public Optional<Long> getReceive() {
        return Optional.ofNullable(receive);
    }

    public EmailActivitySummary withReceive(Long receive) {
        EmailActivitySummary _x = _copy();
        _x.changedFields = changedFields.add("receive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivitySummary");
        _x.receive = receive;
        return _x;
    }

    @Property(name="read")
    @JsonIgnore
    public Optional<Long> getRead() {
        return Optional.ofNullable(read);
    }

    public EmailActivitySummary withRead(Long read) {
        EmailActivitySummary _x = _copy();
        _x.changedFields = changedFields.add("read");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivitySummary");
        _x.read = read;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public EmailActivitySummary withReportDate(LocalDate reportDate) {
        EmailActivitySummary _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivitySummary");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public EmailActivitySummary withReportPeriod(String reportPeriod) {
        EmailActivitySummary _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailActivitySummary");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailActivitySummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EmailActivitySummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EmailActivitySummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EmailActivitySummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EmailActivitySummary _copy() {
        EmailActivitySummary _x = new EmailActivitySummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.send = send;
        _x.receive = receive;
        _x.read = read;
        _x.reportDate = reportDate;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmailActivitySummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("send=");
        b.append(this.send);
        b.append(", ");
        b.append("receive=");
        b.append(this.receive);
        b.append(", ");
        b.append("read=");
        b.append(this.read);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
