package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AssignedLicense;
import odata.msgraph.client.beta.complex.AssignedPlan;
import odata.msgraph.client.beta.complex.EducationOnPremisesInfo;
import odata.msgraph.client.beta.complex.EducationStudent;
import odata.msgraph.client.beta.complex.EducationTeacher;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.PasswordProfile;
import odata.msgraph.client.beta.complex.PhysicalAddress;
import odata.msgraph.client.beta.complex.ProvisionedPlan;
import odata.msgraph.client.beta.complex.RelatedContact;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationClassCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationRubricCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSchoolCollectionRequest;
import odata.msgraph.client.beta.entity.request.UserRequest;
import odata.msgraph.client.beta.enums.EducationExternalSource;
import odata.msgraph.client.beta.enums.EducationUserRole;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "relatedContacts", 
    "primaryRole", 
    "middleName", 
    "externalSource", 
    "residenceAddress", 
    "mailingAddress", 
    "student", 
    "teacher", 
    "createdBy", 
    "accountEnabled", 
    "assignedLicenses", 
    "assignedPlans", 
    "businessPhones", 
    "department", 
    "displayName", 
    "givenName", 
    "mail", 
    "mailNickname", 
    "mobilePhone", 
    "passwordPolicies", 
    "passwordProfile", 
    "officeLocation", 
    "preferredLanguage", 
    "provisionedPlans", 
    "refreshTokensValidFromDateTime", 
    "showInAddressList", 
    "surname", 
    "usageLocation", 
    "userPrincipalName", 
    "userType", 
    "onPremisesInfo"})
@JsonInclude(Include.NON_NULL)
public class EducationUser extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationUser";
    }

    @JsonProperty("relatedContacts")
    protected List<RelatedContact> relatedContacts;

    @JsonProperty("relatedContacts@nextLink")
    protected String relatedContactsNextLink;

    @JsonProperty("primaryRole")
    protected EducationUserRole primaryRole;

    @JsonProperty("middleName")
    protected String middleName;

    @JsonProperty("externalSource")
    protected EducationExternalSource externalSource;

    @JsonProperty("residenceAddress")
    protected PhysicalAddress residenceAddress;

    @JsonProperty("mailingAddress")
    protected PhysicalAddress mailingAddress;

    @JsonProperty("student")
    protected EducationStudent student;

    @JsonProperty("teacher")
    protected EducationTeacher teacher;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("accountEnabled")
    protected Boolean accountEnabled;

    @JsonProperty("assignedLicenses")
    protected List<AssignedLicense> assignedLicenses;

    @JsonProperty("assignedLicenses@nextLink")
    protected String assignedLicensesNextLink;

    @JsonProperty("assignedPlans")
    protected List<AssignedPlan> assignedPlans;

    @JsonProperty("assignedPlans@nextLink")
    protected String assignedPlansNextLink;

    @JsonProperty("businessPhones")
    protected List<String> businessPhones;

    @JsonProperty("businessPhones@nextLink")
    protected String businessPhonesNextLink;

    @JsonProperty("department")
    protected String department;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("givenName")
    protected String givenName;

    @JsonProperty("mail")
    protected String mail;

    @JsonProperty("mailNickname")
    protected String mailNickname;

    @JsonProperty("mobilePhone")
    protected String mobilePhone;

    @JsonProperty("passwordPolicies")
    protected String passwordPolicies;

    @JsonProperty("passwordProfile")
    protected PasswordProfile passwordProfile;

    @JsonProperty("officeLocation")
    protected String officeLocation;

    @JsonProperty("preferredLanguage")
    protected String preferredLanguage;

    @JsonProperty("provisionedPlans")
    protected List<ProvisionedPlan> provisionedPlans;

    @JsonProperty("provisionedPlans@nextLink")
    protected String provisionedPlansNextLink;

    @JsonProperty("refreshTokensValidFromDateTime")
    protected OffsetDateTime refreshTokensValidFromDateTime;

    @JsonProperty("showInAddressList")
    protected Boolean showInAddressList;

    @JsonProperty("surname")
    protected String surname;

    @JsonProperty("usageLocation")
    protected String usageLocation;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("userType")
    protected String userType;

    @JsonProperty("onPremisesInfo")
    protected EducationOnPremisesInfo onPremisesInfo;

    protected EducationUser() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationUser() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<RelatedContact> relatedContacts;
        private String relatedContactsNextLink;
        private EducationUserRole primaryRole;
        private String middleName;
        private EducationExternalSource externalSource;
        private PhysicalAddress residenceAddress;
        private PhysicalAddress mailingAddress;
        private EducationStudent student;
        private EducationTeacher teacher;
        private IdentitySet createdBy;
        private Boolean accountEnabled;
        private List<AssignedLicense> assignedLicenses;
        private String assignedLicensesNextLink;
        private List<AssignedPlan> assignedPlans;
        private String assignedPlansNextLink;
        private List<String> businessPhones;
        private String businessPhonesNextLink;
        private String department;
        private String displayName;
        private String givenName;
        private String mail;
        private String mailNickname;
        private String mobilePhone;
        private String passwordPolicies;
        private PasswordProfile passwordProfile;
        private String officeLocation;
        private String preferredLanguage;
        private List<ProvisionedPlan> provisionedPlans;
        private String provisionedPlansNextLink;
        private OffsetDateTime refreshTokensValidFromDateTime;
        private Boolean showInAddressList;
        private String surname;
        private String usageLocation;
        private String userPrincipalName;
        private String userType;
        private EducationOnPremisesInfo onPremisesInfo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder relatedContacts(List<RelatedContact> relatedContacts) {
            this.relatedContacts = relatedContacts;
            this.changedFields = changedFields.add("relatedContacts");
            return this;
        }

        public Builder relatedContacts(RelatedContact... relatedContacts) {
            return relatedContacts(Arrays.asList(relatedContacts));
        }

        public Builder relatedContactsNextLink(String relatedContactsNextLink) {
            this.relatedContactsNextLink = relatedContactsNextLink;
            this.changedFields = changedFields.add("relatedContacts");
            return this;
        }

        public Builder primaryRole(EducationUserRole primaryRole) {
            this.primaryRole = primaryRole;
            this.changedFields = changedFields.add("primaryRole");
            return this;
        }

        public Builder middleName(String middleName) {
            this.middleName = middleName;
            this.changedFields = changedFields.add("middleName");
            return this;
        }

        public Builder externalSource(EducationExternalSource externalSource) {
            this.externalSource = externalSource;
            this.changedFields = changedFields.add("externalSource");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceAddress
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceCity
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceState
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceCountry
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceZip
         * 
         * @param residenceAddress
         *            value of {@code residenceAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder residenceAddress(PhysicalAddress residenceAddress) {
            this.residenceAddress = residenceAddress;
            this.changedFields = changedFields.add("residenceAddress");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_MailingAddress
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_MailingCity
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_MailingState
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_MailingCountry
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_MailingZip
         * 
         * @param mailingAddress
         *            value of {@code mailingAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mailingAddress(PhysicalAddress mailingAddress) {
            this.mailingAddress = mailingAddress;
            this.changedFields = changedFields.add("mailingAddress");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_GraduationYear
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_Grade
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_DateOfBirth
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_Gender
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_StudentNumber
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_StudentId
         * 
         * @param student
         *            value of {@code student} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder student(EducationStudent student) {
            this.student = student;
            this.changedFields = changedFields.add("student");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_TeacherNumber
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_TeacherId
         * 
         * @param teacher
         *            value of {@code teacher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder teacher(EducationTeacher teacher) {
            this.teacher = teacher;
            this.changedFields = changedFields.add("teacher");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppDisplayName
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppId
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserDisplayName
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserId
         * 
         * @param createdBy
         *            value of {@code createdBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder accountEnabled(Boolean accountEnabled) {
            this.accountEnabled = accountEnabled;
            this.changedFields = changedFields.add("accountEnabled");
            return this;
        }

        public Builder assignedLicenses(List<AssignedLicense> assignedLicenses) {
            this.assignedLicenses = assignedLicenses;
            this.changedFields = changedFields.add("assignedLicenses");
            return this;
        }

        public Builder assignedLicenses(AssignedLicense... assignedLicenses) {
            return assignedLicenses(Arrays.asList(assignedLicenses));
        }

        public Builder assignedLicensesNextLink(String assignedLicensesNextLink) {
            this.assignedLicensesNextLink = assignedLicensesNextLink;
            this.changedFields = changedFields.add("assignedLicenses");
            return this;
        }

        public Builder assignedPlans(List<AssignedPlan> assignedPlans) {
            this.assignedPlans = assignedPlans;
            this.changedFields = changedFields.add("assignedPlans");
            return this;
        }

        public Builder assignedPlans(AssignedPlan... assignedPlans) {
            return assignedPlans(Arrays.asList(assignedPlans));
        }

        public Builder assignedPlansNextLink(String assignedPlansNextLink) {
            this.assignedPlansNextLink = assignedPlansNextLink;
            this.changedFields = changedFields.add("assignedPlans");
            return this;
        }

        public Builder businessPhones(List<String> businessPhones) {
            this.businessPhones = businessPhones;
            this.changedFields = changedFields.add("businessPhones");
            return this;
        }

        public Builder businessPhones(String... businessPhones) {
            return businessPhones(Arrays.asList(businessPhones));
        }

        public Builder businessPhonesNextLink(String businessPhonesNextLink) {
            this.businessPhonesNextLink = businessPhonesNextLink;
            this.changedFields = changedFields.add("businessPhones");
            return this;
        }

        public Builder department(String department) {
            this.department = department;
            this.changedFields = changedFields.add("department");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            this.changedFields = changedFields.add("givenName");
            return this;
        }

        public Builder mail(String mail) {
            this.mail = mail;
            this.changedFields = changedFields.add("mail");
            return this;
        }

        public Builder mailNickname(String mailNickname) {
            this.mailNickname = mailNickname;
            this.changedFields = changedFields.add("mailNickname");
            return this;
        }

        public Builder mobilePhone(String mobilePhone) {
            this.mobilePhone = mobilePhone;
            this.changedFields = changedFields.add("mobilePhone");
            return this;
        }

        public Builder passwordPolicies(String passwordPolicies) {
            this.passwordPolicies = passwordPolicies;
            this.changedFields = changedFields.add("passwordPolicies");
            return this;
        }

        public Builder passwordProfile(PasswordProfile passwordProfile) {
            this.passwordProfile = passwordProfile;
            this.changedFields = changedFields.add("passwordProfile");
            return this;
        }

        public Builder officeLocation(String officeLocation) {
            this.officeLocation = officeLocation;
            this.changedFields = changedFields.add("officeLocation");
            return this;
        }

        public Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            this.changedFields = changedFields.add("preferredLanguage");
            return this;
        }

        public Builder provisionedPlans(List<ProvisionedPlan> provisionedPlans) {
            this.provisionedPlans = provisionedPlans;
            this.changedFields = changedFields.add("provisionedPlans");
            return this;
        }

        public Builder provisionedPlans(ProvisionedPlan... provisionedPlans) {
            return provisionedPlans(Arrays.asList(provisionedPlans));
        }

        public Builder provisionedPlansNextLink(String provisionedPlansNextLink) {
            this.provisionedPlansNextLink = provisionedPlansNextLink;
            this.changedFields = changedFields.add("provisionedPlans");
            return this;
        }

        public Builder refreshTokensValidFromDateTime(OffsetDateTime refreshTokensValidFromDateTime) {
            this.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
            this.changedFields = changedFields.add("refreshTokensValidFromDateTime");
            return this;
        }

        public Builder showInAddressList(Boolean showInAddressList) {
            this.showInAddressList = showInAddressList;
            this.changedFields = changedFields.add("showInAddressList");
            return this;
        }

        public Builder surname(String surname) {
            this.surname = surname;
            this.changedFields = changedFields.add("surname");
            return this;
        }

        public Builder usageLocation(String usageLocation) {
            this.usageLocation = usageLocation;
            this.changedFields = changedFields.add("usageLocation");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder userType(String userType) {
            this.userType = userType;
            this.changedFields = changedFields.add("userType");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * onPremisesImmutableId
         * 
         * @param onPremisesInfo
         *            value of {@code onPremisesInfo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder onPremisesInfo(EducationOnPremisesInfo onPremisesInfo) {
            this.onPremisesInfo = onPremisesInfo;
            this.changedFields = changedFields.add("onPremisesInfo");
            return this;
        }

        public EducationUser build() {
            EducationUser _x = new EducationUser();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationUser";
            _x.id = id;
            _x.relatedContacts = relatedContacts;
            _x.relatedContactsNextLink = relatedContactsNextLink;
            _x.primaryRole = primaryRole;
            _x.middleName = middleName;
            _x.externalSource = externalSource;
            _x.residenceAddress = residenceAddress;
            _x.mailingAddress = mailingAddress;
            _x.student = student;
            _x.teacher = teacher;
            _x.createdBy = createdBy;
            _x.accountEnabled = accountEnabled;
            _x.assignedLicenses = assignedLicenses;
            _x.assignedLicensesNextLink = assignedLicensesNextLink;
            _x.assignedPlans = assignedPlans;
            _x.assignedPlansNextLink = assignedPlansNextLink;
            _x.businessPhones = businessPhones;
            _x.businessPhonesNextLink = businessPhonesNextLink;
            _x.department = department;
            _x.displayName = displayName;
            _x.givenName = givenName;
            _x.mail = mail;
            _x.mailNickname = mailNickname;
            _x.mobilePhone = mobilePhone;
            _x.passwordPolicies = passwordPolicies;
            _x.passwordProfile = passwordProfile;
            _x.officeLocation = officeLocation;
            _x.preferredLanguage = preferredLanguage;
            _x.provisionedPlans = provisionedPlans;
            _x.provisionedPlansNextLink = provisionedPlansNextLink;
            _x.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
            _x.showInAddressList = showInAddressList;
            _x.surname = surname;
            _x.usageLocation = usageLocation;
            _x.userPrincipalName = userPrincipalName;
            _x.userType = userType;
            _x.onPremisesInfo = onPremisesInfo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="relatedContacts")
    @JsonIgnore
    public CollectionPage<RelatedContact> getRelatedContacts() {
        return new CollectionPage<RelatedContact>(contextPath, RelatedContact.class, relatedContacts, Optional.ofNullable(relatedContactsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="relatedContacts")
    @JsonIgnore
    public CollectionPage<RelatedContact> getRelatedContacts(HttpRequestOptions options) {
        return new CollectionPage<RelatedContact>(contextPath, RelatedContact.class, relatedContacts, Optional.ofNullable(relatedContactsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="primaryRole")
    @JsonIgnore
    public Optional<EducationUserRole> getPrimaryRole() {
        return Optional.ofNullable(primaryRole);
    }

    public EducationUser withPrimaryRole(EducationUserRole primaryRole) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("primaryRole");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.primaryRole = primaryRole;
        return _x;
    }

    @Property(name="middleName")
    @JsonIgnore
    public Optional<String> getMiddleName() {
        return Optional.ofNullable(middleName);
    }

    public EducationUser withMiddleName(String middleName) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("middleName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.middleName = middleName;
        return _x;
    }

    @Property(name="externalSource")
    @JsonIgnore
    public Optional<EducationExternalSource> getExternalSource() {
        return Optional.ofNullable(externalSource);
    }

    public EducationUser withExternalSource(EducationExternalSource externalSource) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("externalSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.externalSource = externalSource;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceAddress
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceCity
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceState
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceCountry
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceZip
     * 
     * @return property residenceAddress
     */
    @Property(name="residenceAddress")
    @JsonIgnore
    public Optional<PhysicalAddress> getResidenceAddress() {
        return Optional.ofNullable(residenceAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code residenceAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceAddress
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceCity
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceState
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceCountry
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_ResidenceZip
     * 
     * @param residenceAddress
     *            new value of {@code residenceAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code residenceAddress} field changed
     */
    public EducationUser withResidenceAddress(PhysicalAddress residenceAddress) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("residenceAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.residenceAddress = residenceAddress;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_MailingAddress
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_MailingCity
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_MailingState
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_MailingCountry
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_MailingZip
     * 
     * @return property mailingAddress
     */
    @Property(name="mailingAddress")
    @JsonIgnore
    public Optional<PhysicalAddress> getMailingAddress() {
        return Optional.ofNullable(mailingAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mailingAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_MailingAddress
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_MailingCity
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_MailingState
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_MailingCountry
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_MailingZip
     * 
     * @param mailingAddress
     *            new value of {@code mailingAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mailingAddress} field changed
     */
    public EducationUser withMailingAddress(PhysicalAddress mailingAddress) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("mailingAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.mailingAddress = mailingAddress;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_GraduationYear
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_Grade
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_DateOfBirth
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_Gender
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_StudentNumber
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_StudentId
     * 
     * @return property student
     */
    @Property(name="student")
    @JsonIgnore
    public Optional<EducationStudent> getStudent() {
        return Optional.ofNullable(student);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code student} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_GraduationYear
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_Grade
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_DateOfBirth
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_Gender
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_StudentNumber
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_StudentId
     * 
     * @param student
     *            new value of {@code student} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code student} field changed
     */
    public EducationUser withStudent(EducationStudent student) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("student");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.student = student;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_TeacherNumber
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_TeacherId
     * 
     * @return property teacher
     */
    @Property(name="teacher")
    @JsonIgnore
    public Optional<EducationTeacher> getTeacher() {
        return Optional.ofNullable(teacher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code teacher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_TeacherNumber
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_TeacherId
     * 
     * @param teacher
     *            new value of {@code teacher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code teacher} field changed
     */
    public EducationUser withTeacher(EducationTeacher teacher) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("teacher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.teacher = teacher;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppId
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserId
     * 
     * @return property createdBy
     */
    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdBy} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppId
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserId
     * 
     * @param createdBy
     *            new value of {@code createdBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdBy} field changed
     */
    public EducationUser withCreatedBy(IdentitySet createdBy) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="accountEnabled")
    @JsonIgnore
    public Optional<Boolean> getAccountEnabled() {
        return Optional.ofNullable(accountEnabled);
    }

    public EducationUser withAccountEnabled(Boolean accountEnabled) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("accountEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.accountEnabled = accountEnabled;
        return _x;
    }

    @Property(name="assignedLicenses")
    @JsonIgnore
    public CollectionPage<AssignedLicense> getAssignedLicenses() {
        return new CollectionPage<AssignedLicense>(contextPath, AssignedLicense.class, assignedLicenses, Optional.ofNullable(assignedLicensesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedLicenses")
    @JsonIgnore
    public CollectionPage<AssignedLicense> getAssignedLicenses(HttpRequestOptions options) {
        return new CollectionPage<AssignedLicense>(contextPath, AssignedLicense.class, assignedLicenses, Optional.ofNullable(assignedLicensesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="assignedPlans")
    @JsonIgnore
    public CollectionPage<AssignedPlan> getAssignedPlans() {
        return new CollectionPage<AssignedPlan>(contextPath, AssignedPlan.class, assignedPlans, Optional.ofNullable(assignedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedPlans")
    @JsonIgnore
    public CollectionPage<AssignedPlan> getAssignedPlans(HttpRequestOptions options) {
        return new CollectionPage<AssignedPlan>(contextPath, AssignedPlan.class, assignedPlans, Optional.ofNullable(assignedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="businessPhones")
    @JsonIgnore
    public CollectionPage<String> getBusinessPhones() {
        return new CollectionPage<String>(contextPath, String.class, businessPhones, Optional.ofNullable(businessPhonesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="businessPhones")
    @JsonIgnore
    public CollectionPage<String> getBusinessPhones(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, businessPhones, Optional.ofNullable(businessPhonesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="department")
    @JsonIgnore
    public Optional<String> getDepartment() {
        return Optional.ofNullable(department);
    }

    public EducationUser withDepartment(String department) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("department");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.department = department;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationUser withDisplayName(String displayName) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="givenName")
    @JsonIgnore
    public Optional<String> getGivenName() {
        return Optional.ofNullable(givenName);
    }

    public EducationUser withGivenName(String givenName) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("givenName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.givenName = givenName;
        return _x;
    }

    @Property(name="mail")
    @JsonIgnore
    public Optional<String> getMail() {
        return Optional.ofNullable(mail);
    }

    public EducationUser withMail(String mail) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("mail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.mail = mail;
        return _x;
    }

    @Property(name="mailNickname")
    @JsonIgnore
    public Optional<String> getMailNickname() {
        return Optional.ofNullable(mailNickname);
    }

    public EducationUser withMailNickname(String mailNickname) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("mailNickname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.mailNickname = mailNickname;
        return _x;
    }

    @Property(name="mobilePhone")
    @JsonIgnore
    public Optional<String> getMobilePhone() {
        return Optional.ofNullable(mobilePhone);
    }

    public EducationUser withMobilePhone(String mobilePhone) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("mobilePhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.mobilePhone = mobilePhone;
        return _x;
    }

    @Property(name="passwordPolicies")
    @JsonIgnore
    public Optional<String> getPasswordPolicies() {
        return Optional.ofNullable(passwordPolicies);
    }

    public EducationUser withPasswordPolicies(String passwordPolicies) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("passwordPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.passwordPolicies = passwordPolicies;
        return _x;
    }

    @Property(name="passwordProfile")
    @JsonIgnore
    public Optional<PasswordProfile> getPasswordProfile() {
        return Optional.ofNullable(passwordProfile);
    }

    public EducationUser withPasswordProfile(PasswordProfile passwordProfile) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("passwordProfile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.passwordProfile = passwordProfile;
        return _x;
    }

    @Property(name="officeLocation")
    @JsonIgnore
    public Optional<String> getOfficeLocation() {
        return Optional.ofNullable(officeLocation);
    }

    public EducationUser withOfficeLocation(String officeLocation) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("officeLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.officeLocation = officeLocation;
        return _x;
    }

    @Property(name="preferredLanguage")
    @JsonIgnore
    public Optional<String> getPreferredLanguage() {
        return Optional.ofNullable(preferredLanguage);
    }

    public EducationUser withPreferredLanguage(String preferredLanguage) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("preferredLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.preferredLanguage = preferredLanguage;
        return _x;
    }

    @Property(name="provisionedPlans")
    @JsonIgnore
    public CollectionPage<ProvisionedPlan> getProvisionedPlans() {
        return new CollectionPage<ProvisionedPlan>(contextPath, ProvisionedPlan.class, provisionedPlans, Optional.ofNullable(provisionedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="provisionedPlans")
    @JsonIgnore
    public CollectionPage<ProvisionedPlan> getProvisionedPlans(HttpRequestOptions options) {
        return new CollectionPage<ProvisionedPlan>(contextPath, ProvisionedPlan.class, provisionedPlans, Optional.ofNullable(provisionedPlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="refreshTokensValidFromDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRefreshTokensValidFromDateTime() {
        return Optional.ofNullable(refreshTokensValidFromDateTime);
    }

    public EducationUser withRefreshTokensValidFromDateTime(OffsetDateTime refreshTokensValidFromDateTime) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("refreshTokensValidFromDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
        return _x;
    }

    @Property(name="showInAddressList")
    @JsonIgnore
    public Optional<Boolean> getShowInAddressList() {
        return Optional.ofNullable(showInAddressList);
    }

    public EducationUser withShowInAddressList(Boolean showInAddressList) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("showInAddressList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.showInAddressList = showInAddressList;
        return _x;
    }

    @Property(name="surname")
    @JsonIgnore
    public Optional<String> getSurname() {
        return Optional.ofNullable(surname);
    }

    public EducationUser withSurname(String surname) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("surname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.surname = surname;
        return _x;
    }

    @Property(name="usageLocation")
    @JsonIgnore
    public Optional<String> getUsageLocation() {
        return Optional.ofNullable(usageLocation);
    }

    public EducationUser withUsageLocation(String usageLocation) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("usageLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.usageLocation = usageLocation;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public EducationUser withUserPrincipalName(String userPrincipalName) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="userType")
    @JsonIgnore
    public Optional<String> getUserType() {
        return Optional.ofNullable(userType);
    }

    public EducationUser withUserType(String userType) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("userType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.userType = userType;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * onPremisesImmutableId
     * 
     * @return property onPremisesInfo
     */
    @Property(name="onPremisesInfo")
    @JsonIgnore
    public Optional<EducationOnPremisesInfo> getOnPremisesInfo() {
        return Optional.ofNullable(onPremisesInfo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code onPremisesInfo}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * onPremisesImmutableId
     * 
     * @param onPremisesInfo
     *            new value of {@code onPremisesInfo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code onPremisesInfo} field changed
     */
    public EducationUser withOnPremisesInfo(EducationOnPremisesInfo onPremisesInfo) {
        EducationUser _x = _copy();
        _x.changedFields = changedFields.add("onPremisesInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationUser");
        _x.onPremisesInfo = onPremisesInfo;
        return _x;
    }

    @NavigationProperty(name="assignments")
    @JsonIgnore
    public EducationAssignmentCollectionRequest getAssignments() {
        return new EducationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    @NavigationProperty(name="rubrics")
    @JsonIgnore
    public EducationRubricCollectionRequest getRubrics() {
        return new EducationRubricCollectionRequest(
                        contextPath.addSegment("rubrics"));
    }

    @NavigationProperty(name="classes")
    @JsonIgnore
    public EducationClassCollectionRequest getClasses() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("classes"));
    }

    @NavigationProperty(name="taughtClasses")
    @JsonIgnore
    public EducationClassCollectionRequest getTaughtClasses() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("taughtClasses"));
    }

    @NavigationProperty(name="schools")
    @JsonIgnore
    public EducationSchoolCollectionRequest getSchools() {
        return new EducationSchoolCollectionRequest(
                        contextPath.addSegment("schools"));
    }

    @NavigationProperty(name="user")
    @JsonIgnore
    public UserRequest getUser() {
        return new UserRequest(contextPath.addSegment("user"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationUser patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationUser put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationUser _copy() {
        EducationUser _x = new EducationUser();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.relatedContacts = relatedContacts;
        _x.primaryRole = primaryRole;
        _x.middleName = middleName;
        _x.externalSource = externalSource;
        _x.residenceAddress = residenceAddress;
        _x.mailingAddress = mailingAddress;
        _x.student = student;
        _x.teacher = teacher;
        _x.createdBy = createdBy;
        _x.accountEnabled = accountEnabled;
        _x.assignedLicenses = assignedLicenses;
        _x.assignedPlans = assignedPlans;
        _x.businessPhones = businessPhones;
        _x.department = department;
        _x.displayName = displayName;
        _x.givenName = givenName;
        _x.mail = mail;
        _x.mailNickname = mailNickname;
        _x.mobilePhone = mobilePhone;
        _x.passwordPolicies = passwordPolicies;
        _x.passwordProfile = passwordProfile;
        _x.officeLocation = officeLocation;
        _x.preferredLanguage = preferredLanguage;
        _x.provisionedPlans = provisionedPlans;
        _x.refreshTokensValidFromDateTime = refreshTokensValidFromDateTime;
        _x.showInAddressList = showInAddressList;
        _x.surname = surname;
        _x.usageLocation = usageLocation;
        _x.userPrincipalName = userPrincipalName;
        _x.userType = userType;
        _x.onPremisesInfo = onPremisesInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationUser[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("relatedContacts=");
        b.append(this.relatedContacts);
        b.append(", ");
        b.append("primaryRole=");
        b.append(this.primaryRole);
        b.append(", ");
        b.append("middleName=");
        b.append(this.middleName);
        b.append(", ");
        b.append("externalSource=");
        b.append(this.externalSource);
        b.append(", ");
        b.append("residenceAddress=");
        b.append(this.residenceAddress);
        b.append(", ");
        b.append("mailingAddress=");
        b.append(this.mailingAddress);
        b.append(", ");
        b.append("student=");
        b.append(this.student);
        b.append(", ");
        b.append("teacher=");
        b.append(this.teacher);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("accountEnabled=");
        b.append(this.accountEnabled);
        b.append(", ");
        b.append("assignedLicenses=");
        b.append(this.assignedLicenses);
        b.append(", ");
        b.append("assignedPlans=");
        b.append(this.assignedPlans);
        b.append(", ");
        b.append("businessPhones=");
        b.append(this.businessPhones);
        b.append(", ");
        b.append("department=");
        b.append(this.department);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("givenName=");
        b.append(this.givenName);
        b.append(", ");
        b.append("mail=");
        b.append(this.mail);
        b.append(", ");
        b.append("mailNickname=");
        b.append(this.mailNickname);
        b.append(", ");
        b.append("mobilePhone=");
        b.append(this.mobilePhone);
        b.append(", ");
        b.append("passwordPolicies=");
        b.append(this.passwordPolicies);
        b.append(", ");
        b.append("passwordProfile=");
        b.append(this.passwordProfile);
        b.append(", ");
        b.append("officeLocation=");
        b.append(this.officeLocation);
        b.append(", ");
        b.append("preferredLanguage=");
        b.append(this.preferredLanguage);
        b.append(", ");
        b.append("provisionedPlans=");
        b.append(this.provisionedPlans);
        b.append(", ");
        b.append("refreshTokensValidFromDateTime=");
        b.append(this.refreshTokensValidFromDateTime);
        b.append(", ");
        b.append("showInAddressList=");
        b.append(this.showInAddressList);
        b.append(", ");
        b.append("surname=");
        b.append(this.surname);
        b.append(", ");
        b.append("usageLocation=");
        b.append(this.usageLocation);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("userType=");
        b.append(this.userType);
        b.append(", ");
        b.append("onPremisesInfo=");
        b.append(this.onPremisesInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
