package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EducationSynchronizationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "status", 
    "lastSynchronizationDateTime"})
@JsonInclude(Include.NON_NULL)
public class EducationSynchronizationProfileStatus extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSynchronizationProfileStatus";
    }

    @JsonProperty("status")
    protected EducationSynchronizationStatus status;

    @JsonProperty("lastSynchronizationDateTime")
    protected OffsetDateTime lastSynchronizationDateTime;

    protected EducationSynchronizationProfileStatus() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationSynchronizationProfileStatus() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private EducationSynchronizationStatus status;
        private OffsetDateTime lastSynchronizationDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder status(EducationSynchronizationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder lastSynchronizationDateTime(OffsetDateTime lastSynchronizationDateTime) {
            this.lastSynchronizationDateTime = lastSynchronizationDateTime;
            this.changedFields = changedFields.add("lastSynchronizationDateTime");
            return this;
        }

        public EducationSynchronizationProfileStatus build() {
            EducationSynchronizationProfileStatus _x = new EducationSynchronizationProfileStatus();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationSynchronizationProfileStatus";
            _x.id = id;
            _x.status = status;
            _x.lastSynchronizationDateTime = lastSynchronizationDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<EducationSynchronizationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public EducationSynchronizationProfileStatus withStatus(EducationSynchronizationStatus status) {
        EducationSynchronizationProfileStatus _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationProfileStatus");
        _x.status = status;
        return _x;
    }

    @Property(name="lastSynchronizationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSynchronizationDateTime() {
        return Optional.ofNullable(lastSynchronizationDateTime);
    }

    public EducationSynchronizationProfileStatus withLastSynchronizationDateTime(OffsetDateTime lastSynchronizationDateTime) {
        EducationSynchronizationProfileStatus _x = _copy();
        _x.changedFields = changedFields.add("lastSynchronizationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationProfileStatus");
        _x.lastSynchronizationDateTime = lastSynchronizationDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSynchronizationProfileStatus patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationSynchronizationProfileStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSynchronizationProfileStatus put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationSynchronizationProfileStatus _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationSynchronizationProfileStatus _copy() {
        EducationSynchronizationProfileStatus _x = new EducationSynchronizationProfileStatus();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.status = status;
        _x.lastSynchronizationDateTime = lastSynchronizationDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSynchronizationProfileStatus[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("lastSynchronizationDateTime=");
        b.append(this.lastSynchronizationDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
