package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationFileSynchronizationVerificationMessage;
import odata.msgraph.client.beta.complex.EducationIdentitySynchronizationConfiguration;
import odata.msgraph.client.beta.complex.EducationSynchronizationDataProvider;
import odata.msgraph.client.beta.complex.EducationSynchronizationLicenseAssignment;
import odata.msgraph.client.beta.entity.collection.request.EducationSynchronizationErrorCollectionRequest;
import odata.msgraph.client.beta.entity.request.EducationSynchronizationProfileStatusRequest;
import odata.msgraph.client.beta.enums.EducationSynchronizationProfileState;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "dataProvider", 
    "identitySynchronizationConfiguration", 
    "licensesToAssign", 
    "state", 
    "handleSpecialCharacterConstraint"})
@JsonInclude(Include.NON_NULL)
public class EducationSynchronizationProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSynchronizationProfile";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("dataProvider")
    protected EducationSynchronizationDataProvider dataProvider;

    @JsonProperty("identitySynchronizationConfiguration")
    protected EducationIdentitySynchronizationConfiguration identitySynchronizationConfiguration;

    @JsonProperty("licensesToAssign")
    protected List<EducationSynchronizationLicenseAssignment> licensesToAssign;

    @JsonProperty("licensesToAssign@nextLink")
    protected String licensesToAssignNextLink;

    @JsonProperty("state")
    protected EducationSynchronizationProfileState state;

    @JsonProperty("handleSpecialCharacterConstraint")
    protected Boolean handleSpecialCharacterConstraint;

    protected EducationSynchronizationProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationSynchronizationProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private EducationSynchronizationDataProvider dataProvider;
        private EducationIdentitySynchronizationConfiguration identitySynchronizationConfiguration;
        private List<EducationSynchronizationLicenseAssignment> licensesToAssign;
        private String licensesToAssignNextLink;
        private EducationSynchronizationProfileState state;
        private Boolean handleSpecialCharacterConstraint;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder dataProvider(EducationSynchronizationDataProvider dataProvider) {
            this.dataProvider = dataProvider;
            this.changedFields = changedFields.add("dataProvider");
            return this;
        }

        public Builder identitySynchronizationConfiguration(EducationIdentitySynchronizationConfiguration identitySynchronizationConfiguration) {
            this.identitySynchronizationConfiguration = identitySynchronizationConfiguration;
            this.changedFields = changedFields.add("identitySynchronizationConfiguration");
            return this;
        }

        public Builder licensesToAssign(List<EducationSynchronizationLicenseAssignment> licensesToAssign) {
            this.licensesToAssign = licensesToAssign;
            this.changedFields = changedFields.add("licensesToAssign");
            return this;
        }

        public Builder licensesToAssign(EducationSynchronizationLicenseAssignment... licensesToAssign) {
            return licensesToAssign(Arrays.asList(licensesToAssign));
        }

        public Builder licensesToAssignNextLink(String licensesToAssignNextLink) {
            this.licensesToAssignNextLink = licensesToAssignNextLink;
            this.changedFields = changedFields.add("licensesToAssign");
            return this;
        }

        public Builder state(EducationSynchronizationProfileState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder handleSpecialCharacterConstraint(Boolean handleSpecialCharacterConstraint) {
            this.handleSpecialCharacterConstraint = handleSpecialCharacterConstraint;
            this.changedFields = changedFields.add("handleSpecialCharacterConstraint");
            return this;
        }

        public EducationSynchronizationProfile build() {
            EducationSynchronizationProfile _x = new EducationSynchronizationProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationSynchronizationProfile";
            _x.id = id;
            _x.displayName = displayName;
            _x.dataProvider = dataProvider;
            _x.identitySynchronizationConfiguration = identitySynchronizationConfiguration;
            _x.licensesToAssign = licensesToAssign;
            _x.licensesToAssignNextLink = licensesToAssignNextLink;
            _x.state = state;
            _x.handleSpecialCharacterConstraint = handleSpecialCharacterConstraint;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationSynchronizationProfile withDisplayName(String displayName) {
        EducationSynchronizationProfile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationProfile");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="dataProvider")
    @JsonIgnore
    public Optional<EducationSynchronizationDataProvider> getDataProvider() {
        return Optional.ofNullable(dataProvider);
    }

    public EducationSynchronizationProfile withDataProvider(EducationSynchronizationDataProvider dataProvider) {
        EducationSynchronizationProfile _x = _copy();
        _x.changedFields = changedFields.add("dataProvider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationProfile");
        _x.dataProvider = dataProvider;
        return _x;
    }

    @Property(name="identitySynchronizationConfiguration")
    @JsonIgnore
    public Optional<EducationIdentitySynchronizationConfiguration> getIdentitySynchronizationConfiguration() {
        return Optional.ofNullable(identitySynchronizationConfiguration);
    }

    public EducationSynchronizationProfile withIdentitySynchronizationConfiguration(EducationIdentitySynchronizationConfiguration identitySynchronizationConfiguration) {
        EducationSynchronizationProfile _x = _copy();
        _x.changedFields = changedFields.add("identitySynchronizationConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationProfile");
        _x.identitySynchronizationConfiguration = identitySynchronizationConfiguration;
        return _x;
    }

    @Property(name="licensesToAssign")
    @JsonIgnore
    public CollectionPage<EducationSynchronizationLicenseAssignment> getLicensesToAssign() {
        return new CollectionPage<EducationSynchronizationLicenseAssignment>(contextPath, EducationSynchronizationLicenseAssignment.class, licensesToAssign, Optional.ofNullable(licensesToAssignNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="licensesToAssign")
    @JsonIgnore
    public CollectionPage<EducationSynchronizationLicenseAssignment> getLicensesToAssign(HttpRequestOptions options) {
        return new CollectionPage<EducationSynchronizationLicenseAssignment>(contextPath, EducationSynchronizationLicenseAssignment.class, licensesToAssign, Optional.ofNullable(licensesToAssignNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<EducationSynchronizationProfileState> getState() {
        return Optional.ofNullable(state);
    }

    public EducationSynchronizationProfile withState(EducationSynchronizationProfileState state) {
        EducationSynchronizationProfile _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationProfile");
        _x.state = state;
        return _x;
    }

    @Property(name="handleSpecialCharacterConstraint")
    @JsonIgnore
    public Optional<Boolean> getHandleSpecialCharacterConstraint() {
        return Optional.ofNullable(handleSpecialCharacterConstraint);
    }

    public EducationSynchronizationProfile withHandleSpecialCharacterConstraint(Boolean handleSpecialCharacterConstraint) {
        EducationSynchronizationProfile _x = _copy();
        _x.changedFields = changedFields.add("handleSpecialCharacterConstraint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationProfile");
        _x.handleSpecialCharacterConstraint = handleSpecialCharacterConstraint;
        return _x;
    }

    @NavigationProperty(name="errors")
    @JsonIgnore
    public EducationSynchronizationErrorCollectionRequest getErrors() {
        return new EducationSynchronizationErrorCollectionRequest(
                        contextPath.addSegment("errors"));
    }

    @NavigationProperty(name="profileStatus")
    @JsonIgnore
    public EducationSynchronizationProfileStatusRequest getProfileStatus() {
        return new EducationSynchronizationProfileStatusRequest(contextPath.addSegment("profileStatus"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSynchronizationProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationSynchronizationProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSynchronizationProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationSynchronizationProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationSynchronizationProfile _copy() {
        EducationSynchronizationProfile _x = new EducationSynchronizationProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.dataProvider = dataProvider;
        _x.identitySynchronizationConfiguration = identitySynchronizationConfiguration;
        _x.licensesToAssign = licensesToAssign;
        _x.state = state;
        _x.handleSpecialCharacterConstraint = handleSpecialCharacterConstraint;
        return _x;
    }

    @Action(name = "resume")
    @JsonIgnore
    public ActionRequestNoReturn resume() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resume"), _parameters);
    }

    @Action(name = "pause")
    @JsonIgnore
    public ActionRequestNoReturn pause() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.pause"), _parameters);
    }

    @Action(name = "reset")
    @JsonIgnore
    public ActionRequestNoReturn reset() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reset"), _parameters);
    }

    @Action(name = "start")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EducationFileSynchronizationVerificationMessage> start() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.start"), EducationFileSynchronizationVerificationMessage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "uploadUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> uploadUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadUrl"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSynchronizationProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("dataProvider=");
        b.append(this.dataProvider);
        b.append(", ");
        b.append("identitySynchronizationConfiguration=");
        b.append(this.identitySynchronizationConfiguration);
        b.append(", ");
        b.append("licensesToAssign=");
        b.append(this.licensesToAssign);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("handleSpecialCharacterConstraint=");
        b.append(this.handleSpecialCharacterConstraint);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
