package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "entryType", 
    "errorCode", 
    "errorMessage", 
    "joiningValue", 
    "recordedDateTime", 
    "reportableIdentifier"})
@JsonInclude(Include.NON_NULL)
public class EducationSynchronizationError extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSynchronizationError";
    }

    @JsonProperty("entryType")
    protected String entryType;

    @JsonProperty("errorCode")
    protected String errorCode;

    @JsonProperty("errorMessage")
    protected String errorMessage;

    @JsonProperty("joiningValue")
    protected String joiningValue;

    @JsonProperty("recordedDateTime")
    protected OffsetDateTime recordedDateTime;

    @JsonProperty("reportableIdentifier")
    protected String reportableIdentifier;

    protected EducationSynchronizationError() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationSynchronizationError() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String entryType;
        private String errorCode;
        private String errorMessage;
        private String joiningValue;
        private OffsetDateTime recordedDateTime;
        private String reportableIdentifier;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder entryType(String entryType) {
            this.entryType = entryType;
            this.changedFields = changedFields.add("entryType");
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.changedFields = changedFields.add("errorMessage");
            return this;
        }

        public Builder joiningValue(String joiningValue) {
            this.joiningValue = joiningValue;
            this.changedFields = changedFields.add("joiningValue");
            return this;
        }

        public Builder recordedDateTime(OffsetDateTime recordedDateTime) {
            this.recordedDateTime = recordedDateTime;
            this.changedFields = changedFields.add("recordedDateTime");
            return this;
        }

        public Builder reportableIdentifier(String reportableIdentifier) {
            this.reportableIdentifier = reportableIdentifier;
            this.changedFields = changedFields.add("reportableIdentifier");
            return this;
        }

        public EducationSynchronizationError build() {
            EducationSynchronizationError _x = new EducationSynchronizationError();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationSynchronizationError";
            _x.id = id;
            _x.entryType = entryType;
            _x.errorCode = errorCode;
            _x.errorMessage = errorMessage;
            _x.joiningValue = joiningValue;
            _x.recordedDateTime = recordedDateTime;
            _x.reportableIdentifier = reportableIdentifier;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="entryType")
    @JsonIgnore
    public Optional<String> getEntryType() {
        return Optional.ofNullable(entryType);
    }

    public EducationSynchronizationError withEntryType(String entryType) {
        EducationSynchronizationError _x = _copy();
        _x.changedFields = changedFields.add("entryType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationError");
        _x.entryType = entryType;
        return _x;
    }

    @Property(name="errorCode")
    @JsonIgnore
    public Optional<String> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    public EducationSynchronizationError withErrorCode(String errorCode) {
        EducationSynchronizationError _x = _copy();
        _x.changedFields = changedFields.add("errorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationError");
        _x.errorCode = errorCode;
        return _x;
    }

    @Property(name="errorMessage")
    @JsonIgnore
    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(errorMessage);
    }

    public EducationSynchronizationError withErrorMessage(String errorMessage) {
        EducationSynchronizationError _x = _copy();
        _x.changedFields = changedFields.add("errorMessage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationError");
        _x.errorMessage = errorMessage;
        return _x;
    }

    @Property(name="joiningValue")
    @JsonIgnore
    public Optional<String> getJoiningValue() {
        return Optional.ofNullable(joiningValue);
    }

    public EducationSynchronizationError withJoiningValue(String joiningValue) {
        EducationSynchronizationError _x = _copy();
        _x.changedFields = changedFields.add("joiningValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationError");
        _x.joiningValue = joiningValue;
        return _x;
    }

    @Property(name="recordedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRecordedDateTime() {
        return Optional.ofNullable(recordedDateTime);
    }

    public EducationSynchronizationError withRecordedDateTime(OffsetDateTime recordedDateTime) {
        EducationSynchronizationError _x = _copy();
        _x.changedFields = changedFields.add("recordedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationError");
        _x.recordedDateTime = recordedDateTime;
        return _x;
    }

    @Property(name="reportableIdentifier")
    @JsonIgnore
    public Optional<String> getReportableIdentifier() {
        return Optional.ofNullable(reportableIdentifier);
    }

    public EducationSynchronizationError withReportableIdentifier(String reportableIdentifier) {
        EducationSynchronizationError _x = _copy();
        _x.changedFields = changedFields.add("reportableIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationError");
        _x.reportableIdentifier = reportableIdentifier;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSynchronizationError patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationSynchronizationError _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSynchronizationError put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationSynchronizationError _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationSynchronizationError _copy() {
        EducationSynchronizationError _x = new EducationSynchronizationError();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.entryType = entryType;
        _x.errorCode = errorCode;
        _x.errorMessage = errorMessage;
        _x.joiningValue = joiningValue;
        _x.recordedDateTime = recordedDateTime;
        _x.reportableIdentifier = reportableIdentifier;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSynchronizationError[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("entryType=");
        b.append(this.entryType);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("errorMessage=");
        b.append(this.errorMessage);
        b.append(", ");
        b.append("joiningValue=");
        b.append(this.joiningValue);
        b.append(", ");
        b.append("recordedDateTime=");
        b.append(this.recordedDateTime);
        b.append(", ");
        b.append("reportableIdentifier=");
        b.append(this.reportableIdentifier);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
