package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationSubmissionRecipient;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.collection.request.EducationOutcomeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSubmissionResourceCollectionRequest;
import odata.msgraph.client.beta.enums.EducationSubmissionStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "recipient", 
    "status", 
    "submittedBy", 
    "submittedDateTime", 
    "unsubmittedBy", 
    "unsubmittedDateTime", 
    "releasedBy", 
    "releasedDateTime", 
    "returnedBy", 
    "returnedDateTime", 
    "resourcesFolderUrl"})
@JsonInclude(Include.NON_NULL)
public class EducationSubmission extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSubmission";
    }

    @JsonProperty("recipient")
    protected EducationSubmissionRecipient recipient;

    @JsonProperty("status")
    protected EducationSubmissionStatus status;

    @JsonProperty("submittedBy")
    protected IdentitySet submittedBy;

    @JsonProperty("submittedDateTime")
    protected OffsetDateTime submittedDateTime;

    @JsonProperty("unsubmittedBy")
    protected IdentitySet unsubmittedBy;

    @JsonProperty("unsubmittedDateTime")
    protected OffsetDateTime unsubmittedDateTime;

    @JsonProperty("releasedBy")
    protected IdentitySet releasedBy;

    @JsonProperty("releasedDateTime")
    protected OffsetDateTime releasedDateTime;

    @JsonProperty("returnedBy")
    protected IdentitySet returnedBy;

    @JsonProperty("returnedDateTime")
    protected OffsetDateTime returnedDateTime;

    @JsonProperty("resourcesFolderUrl")
    protected String resourcesFolderUrl;

    protected EducationSubmission() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationSubmission() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private EducationSubmissionRecipient recipient;
        private EducationSubmissionStatus status;
        private IdentitySet submittedBy;
        private OffsetDateTime submittedDateTime;
        private IdentitySet unsubmittedBy;
        private OffsetDateTime unsubmittedDateTime;
        private IdentitySet releasedBy;
        private OffsetDateTime releasedDateTime;
        private IdentitySet returnedBy;
        private OffsetDateTime returnedDateTime;
        private String resourcesFolderUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder recipient(EducationSubmissionRecipient recipient) {
            this.recipient = recipient;
            this.changedFields = changedFields.add("recipient");
            return this;
        }

        public Builder status(EducationSubmissionStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder submittedBy(IdentitySet submittedBy) {
            this.submittedBy = submittedBy;
            this.changedFields = changedFields.add("submittedBy");
            return this;
        }

        public Builder submittedDateTime(OffsetDateTime submittedDateTime) {
            this.submittedDateTime = submittedDateTime;
            this.changedFields = changedFields.add("submittedDateTime");
            return this;
        }

        public Builder unsubmittedBy(IdentitySet unsubmittedBy) {
            this.unsubmittedBy = unsubmittedBy;
            this.changedFields = changedFields.add("unsubmittedBy");
            return this;
        }

        public Builder unsubmittedDateTime(OffsetDateTime unsubmittedDateTime) {
            this.unsubmittedDateTime = unsubmittedDateTime;
            this.changedFields = changedFields.add("unsubmittedDateTime");
            return this;
        }

        public Builder releasedBy(IdentitySet releasedBy) {
            this.releasedBy = releasedBy;
            this.changedFields = changedFields.add("releasedBy");
            return this;
        }

        public Builder releasedDateTime(OffsetDateTime releasedDateTime) {
            this.releasedDateTime = releasedDateTime;
            this.changedFields = changedFields.add("releasedDateTime");
            return this;
        }

        public Builder returnedBy(IdentitySet returnedBy) {
            this.returnedBy = returnedBy;
            this.changedFields = changedFields.add("returnedBy");
            return this;
        }

        public Builder returnedDateTime(OffsetDateTime returnedDateTime) {
            this.returnedDateTime = returnedDateTime;
            this.changedFields = changedFields.add("returnedDateTime");
            return this;
        }

        public Builder resourcesFolderUrl(String resourcesFolderUrl) {
            this.resourcesFolderUrl = resourcesFolderUrl;
            this.changedFields = changedFields.add("resourcesFolderUrl");
            return this;
        }

        public EducationSubmission build() {
            EducationSubmission _x = new EducationSubmission();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationSubmission";
            _x.id = id;
            _x.recipient = recipient;
            _x.status = status;
            _x.submittedBy = submittedBy;
            _x.submittedDateTime = submittedDateTime;
            _x.unsubmittedBy = unsubmittedBy;
            _x.unsubmittedDateTime = unsubmittedDateTime;
            _x.releasedBy = releasedBy;
            _x.releasedDateTime = releasedDateTime;
            _x.returnedBy = returnedBy;
            _x.returnedDateTime = returnedDateTime;
            _x.resourcesFolderUrl = resourcesFolderUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="recipient")
    @JsonIgnore
    public Optional<EducationSubmissionRecipient> getRecipient() {
        return Optional.ofNullable(recipient);
    }

    public EducationSubmission withRecipient(EducationSubmissionRecipient recipient) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("recipient");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.recipient = recipient;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<EducationSubmissionStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public EducationSubmission withStatus(EducationSubmissionStatus status) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.status = status;
        return _x;
    }

    @Property(name="submittedBy")
    @JsonIgnore
    public Optional<IdentitySet> getSubmittedBy() {
        return Optional.ofNullable(submittedBy);
    }

    public EducationSubmission withSubmittedBy(IdentitySet submittedBy) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("submittedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.submittedBy = submittedBy;
        return _x;
    }

    @Property(name="submittedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSubmittedDateTime() {
        return Optional.ofNullable(submittedDateTime);
    }

    public EducationSubmission withSubmittedDateTime(OffsetDateTime submittedDateTime) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("submittedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.submittedDateTime = submittedDateTime;
        return _x;
    }

    @Property(name="unsubmittedBy")
    @JsonIgnore
    public Optional<IdentitySet> getUnsubmittedBy() {
        return Optional.ofNullable(unsubmittedBy);
    }

    public EducationSubmission withUnsubmittedBy(IdentitySet unsubmittedBy) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("unsubmittedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.unsubmittedBy = unsubmittedBy;
        return _x;
    }

    @Property(name="unsubmittedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getUnsubmittedDateTime() {
        return Optional.ofNullable(unsubmittedDateTime);
    }

    public EducationSubmission withUnsubmittedDateTime(OffsetDateTime unsubmittedDateTime) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("unsubmittedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.unsubmittedDateTime = unsubmittedDateTime;
        return _x;
    }

    @Property(name="releasedBy")
    @JsonIgnore
    public Optional<IdentitySet> getReleasedBy() {
        return Optional.ofNullable(releasedBy);
    }

    public EducationSubmission withReleasedBy(IdentitySet releasedBy) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("releasedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.releasedBy = releasedBy;
        return _x;
    }

    @Property(name="releasedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReleasedDateTime() {
        return Optional.ofNullable(releasedDateTime);
    }

    public EducationSubmission withReleasedDateTime(OffsetDateTime releasedDateTime) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("releasedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.releasedDateTime = releasedDateTime;
        return _x;
    }

    @Property(name="returnedBy")
    @JsonIgnore
    public Optional<IdentitySet> getReturnedBy() {
        return Optional.ofNullable(returnedBy);
    }

    public EducationSubmission withReturnedBy(IdentitySet returnedBy) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("returnedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.returnedBy = returnedBy;
        return _x;
    }

    @Property(name="returnedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReturnedDateTime() {
        return Optional.ofNullable(returnedDateTime);
    }

    public EducationSubmission withReturnedDateTime(OffsetDateTime returnedDateTime) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("returnedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.returnedDateTime = returnedDateTime;
        return _x;
    }

    @Property(name="resourcesFolderUrl")
    @JsonIgnore
    public Optional<String> getResourcesFolderUrl() {
        return Optional.ofNullable(resourcesFolderUrl);
    }

    public EducationSubmission withResourcesFolderUrl(String resourcesFolderUrl) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("resourcesFolderUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.resourcesFolderUrl = resourcesFolderUrl;
        return _x;
    }

    @NavigationProperty(name="resources")
    @JsonIgnore
    public EducationSubmissionResourceCollectionRequest getResources() {
        return new EducationSubmissionResourceCollectionRequest(
                        contextPath.addSegment("resources"));
    }

    @NavigationProperty(name="submittedResources")
    @JsonIgnore
    public EducationSubmissionResourceCollectionRequest getSubmittedResources() {
        return new EducationSubmissionResourceCollectionRequest(
                        contextPath.addSegment("submittedResources"));
    }

    @NavigationProperty(name="outcomes")
    @JsonIgnore
    public EducationOutcomeCollectionRequest getOutcomes() {
        return new EducationOutcomeCollectionRequest(
                        contextPath.addSegment("outcomes"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSubmission patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationSubmission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSubmission put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationSubmission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationSubmission _copy() {
        EducationSubmission _x = new EducationSubmission();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.recipient = recipient;
        _x.status = status;
        _x.submittedBy = submittedBy;
        _x.submittedDateTime = submittedDateTime;
        _x.unsubmittedBy = unsubmittedBy;
        _x.unsubmittedDateTime = unsubmittedDateTime;
        _x.releasedBy = releasedBy;
        _x.releasedDateTime = releasedDateTime;
        _x.returnedBy = returnedBy;
        _x.returnedDateTime = returnedDateTime;
        _x.resourcesFolderUrl = resourcesFolderUrl;
        return _x;
    }

    @Action(name = "return")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> return_() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.return"), EducationSubmission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "submit")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> submit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.submit"), EducationSubmission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "unsubmit")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> unsubmit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unsubmit"), EducationSubmission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSubmission[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("recipient=");
        b.append(this.recipient);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("submittedBy=");
        b.append(this.submittedBy);
        b.append(", ");
        b.append("submittedDateTime=");
        b.append(this.submittedDateTime);
        b.append(", ");
        b.append("unsubmittedBy=");
        b.append(this.unsubmittedBy);
        b.append(", ");
        b.append("unsubmittedDateTime=");
        b.append(this.unsubmittedDateTime);
        b.append(", ");
        b.append("releasedBy=");
        b.append(this.releasedBy);
        b.append(", ");
        b.append("releasedDateTime=");
        b.append(this.releasedDateTime);
        b.append(", ");
        b.append("returnedBy=");
        b.append(this.returnedBy);
        b.append(", ");
        b.append("returnedDateTime=");
        b.append(this.returnedDateTime);
        b.append(", ");
        b.append("resourcesFolderUrl=");
        b.append(this.resourcesFolderUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
