package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.PhysicalAddress;
import odata.msgraph.client.beta.entity.collection.request.EducationClassCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationUserCollectionRequest;
import odata.msgraph.client.beta.entity.request.AdministrativeUnitRequest;
import odata.msgraph.client.beta.enums.EducationExternalSource;

@JsonPropertyOrder({
    "@odata.type", 
    "principalEmail", 
    "principalName", 
    "externalPrincipalId", 
    "lowestGrade", 
    "highestGrade", 
    "schoolNumber", 
    "externalId", 
    "phone", 
    "fax", 
    "createdBy", 
    "address"})
@JsonInclude(Include.NON_NULL)
public class EducationSchool extends EducationOrganization implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSchool";
    }

    @JsonProperty("principalEmail")
    protected String principalEmail;

    @JsonProperty("principalName")
    protected String principalName;

    @JsonProperty("externalPrincipalId")
    protected String externalPrincipalId;

    @JsonProperty("lowestGrade")
    protected String lowestGrade;

    @JsonProperty("highestGrade")
    protected String highestGrade;

    @JsonProperty("schoolNumber")
    protected String schoolNumber;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("phone")
    protected String phone;

    @JsonProperty("fax")
    protected String fax;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("address")
    protected PhysicalAddress address;

    protected EducationSchool() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationSchool() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private EducationExternalSource externalSource;
        private String principalEmail;
        private String principalName;
        private String externalPrincipalId;
        private String lowestGrade;
        private String highestGrade;
        private String schoolNumber;
        private String externalId;
        private String phone;
        private String fax;
        private IdentitySet createdBy;
        private PhysicalAddress address;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder externalSource(EducationExternalSource externalSource) {
            this.externalSource = externalSource;
            this.changedFields = changedFields.add("externalSource");
            return this;
        }

        public Builder principalEmail(String principalEmail) {
            this.principalEmail = principalEmail;
            this.changedFields = changedFields.add("principalEmail");
            return this;
        }

        public Builder principalName(String principalName) {
            this.principalName = principalName;
            this.changedFields = changedFields.add("principalName");
            return this;
        }

        public Builder externalPrincipalId(String externalPrincipalId) {
            this.externalPrincipalId = externalPrincipalId;
            this.changedFields = changedFields.add("externalPrincipalId");
            return this;
        }

        public Builder lowestGrade(String lowestGrade) {
            this.lowestGrade = lowestGrade;
            this.changedFields = changedFields.add("lowestGrade");
            return this;
        }

        public Builder highestGrade(String highestGrade) {
            this.highestGrade = highestGrade;
            this.changedFields = changedFields.add("highestGrade");
            return this;
        }

        public Builder schoolNumber(String schoolNumber) {
            this.schoolNumber = schoolNumber;
            this.changedFields = changedFields.add("schoolNumber");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            this.changedFields = changedFields.add("phone");
            return this;
        }

        public Builder fax(String fax) {
            this.fax = fax;
            this.changedFields = changedFields.add("fax");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppDisplayName
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppId
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserDisplayName
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserId
         * 
         * @param createdBy
         *            value of {@code createdBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_Address
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_City
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_State
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_Country
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_Zip
         * 
         * @param address
         *            value of {@code address} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder address(PhysicalAddress address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public EducationSchool build() {
            EducationSchool _x = new EducationSchool();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationSchool";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.externalSource = externalSource;
            _x.principalEmail = principalEmail;
            _x.principalName = principalName;
            _x.externalPrincipalId = externalPrincipalId;
            _x.lowestGrade = lowestGrade;
            _x.highestGrade = highestGrade;
            _x.schoolNumber = schoolNumber;
            _x.externalId = externalId;
            _x.phone = phone;
            _x.fax = fax;
            _x.createdBy = createdBy;
            _x.address = address;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="principalEmail")
    @JsonIgnore
    public Optional<String> getPrincipalEmail() {
        return Optional.ofNullable(principalEmail);
    }

    public EducationSchool withPrincipalEmail(String principalEmail) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("principalEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.principalEmail = principalEmail;
        return _x;
    }

    @Property(name="principalName")
    @JsonIgnore
    public Optional<String> getPrincipalName() {
        return Optional.ofNullable(principalName);
    }

    public EducationSchool withPrincipalName(String principalName) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("principalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.principalName = principalName;
        return _x;
    }

    @Property(name="externalPrincipalId")
    @JsonIgnore
    public Optional<String> getExternalPrincipalId() {
        return Optional.ofNullable(externalPrincipalId);
    }

    public EducationSchool withExternalPrincipalId(String externalPrincipalId) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("externalPrincipalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.externalPrincipalId = externalPrincipalId;
        return _x;
    }

    @Property(name="lowestGrade")
    @JsonIgnore
    public Optional<String> getLowestGrade() {
        return Optional.ofNullable(lowestGrade);
    }

    public EducationSchool withLowestGrade(String lowestGrade) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("lowestGrade");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.lowestGrade = lowestGrade;
        return _x;
    }

    @Property(name="highestGrade")
    @JsonIgnore
    public Optional<String> getHighestGrade() {
        return Optional.ofNullable(highestGrade);
    }

    public EducationSchool withHighestGrade(String highestGrade) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("highestGrade");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.highestGrade = highestGrade;
        return _x;
    }

    @Property(name="schoolNumber")
    @JsonIgnore
    public Optional<String> getSchoolNumber() {
        return Optional.ofNullable(schoolNumber);
    }

    public EducationSchool withSchoolNumber(String schoolNumber) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("schoolNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.schoolNumber = schoolNumber;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public EducationSchool withExternalId(String externalId) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="phone")
    @JsonIgnore
    public Optional<String> getPhone() {
        return Optional.ofNullable(phone);
    }

    public EducationSchool withPhone(String phone) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("phone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.phone = phone;
        return _x;
    }

    @Property(name="fax")
    @JsonIgnore
    public Optional<String> getFax() {
        return Optional.ofNullable(fax);
    }

    public EducationSchool withFax(String fax) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("fax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.fax = fax;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppId
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserId
     * 
     * @return property createdBy
     */
    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdBy} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppId
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserId
     * 
     * @param createdBy
     *            new value of {@code createdBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdBy} field changed
     */
    public EducationSchool withCreatedBy(IdentitySet createdBy) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.createdBy = createdBy;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_Address
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_City
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_State
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_Country
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_Zip
     * 
     * @return property address
     */
    @Property(name="address")
    @JsonIgnore
    public Optional<PhysicalAddress> getAddress() {
        return Optional.ofNullable(address);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code address} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_Address
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_City
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_State
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_Country
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_Zip
     * 
     * @param address
     *            new value of {@code address} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code address} field changed
     */
    public EducationSchool withAddress(PhysicalAddress address) {
        EducationSchool _x = _copy();
        _x.changedFields = changedFields.add("address");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSchool");
        _x.address = address;
        return _x;
    }

    @NavigationProperty(name="classes")
    @JsonIgnore
    public EducationClassCollectionRequest getClasses() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("classes"));
    }

    @NavigationProperty(name="users")
    @JsonIgnore
    public EducationUserCollectionRequest getUsers() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("users"));
    }

    @NavigationProperty(name="administrativeUnit")
    @JsonIgnore
    public AdministrativeUnitRequest getAdministrativeUnit() {
        return new AdministrativeUnitRequest(contextPath.addSegment("administrativeUnit"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSchool patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationSchool _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSchool put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationSchool _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationSchool _copy() {
        EducationSchool _x = new EducationSchool();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.externalSource = externalSource;
        _x.principalEmail = principalEmail;
        _x.principalName = principalName;
        _x.externalPrincipalId = externalPrincipalId;
        _x.lowestGrade = lowestGrade;
        _x.highestGrade = highestGrade;
        _x.schoolNumber = schoolNumber;
        _x.externalId = externalId;
        _x.phone = phone;
        _x.fax = fax;
        _x.createdBy = createdBy;
        _x.address = address;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSchool[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("externalSource=");
        b.append(this.externalSource);
        b.append(", ");
        b.append("principalEmail=");
        b.append(this.principalEmail);
        b.append(", ");
        b.append("principalName=");
        b.append(this.principalName);
        b.append(", ");
        b.append("externalPrincipalId=");
        b.append(this.externalPrincipalId);
        b.append(", ");
        b.append("lowestGrade=");
        b.append(this.lowestGrade);
        b.append(", ");
        b.append("highestGrade=");
        b.append(this.highestGrade);
        b.append(", ");
        b.append("schoolNumber=");
        b.append(this.schoolNumber);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("phone=");
        b.append(this.phone);
        b.append(", ");
        b.append("fax=");
        b.append(this.fax);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
