package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.RubricQualityFeedbackModel;
import odata.msgraph.client.beta.complex.RubricQualitySelectedColumnModel;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "rubricQualityFeedback", 
    "rubricQualitySelectedLevels", 
    "publishedRubricQualityFeedback", 
    "publishedRubricQualitySelectedLevels"})
@JsonInclude(Include.NON_NULL)
public class EducationRubricOutcome extends EducationOutcome implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationRubricOutcome";
    }

    @JsonProperty("rubricQualityFeedback")
    protected List<RubricQualityFeedbackModel> rubricQualityFeedback;

    @JsonProperty("rubricQualityFeedback@nextLink")
    protected String rubricQualityFeedbackNextLink;

    @JsonProperty("rubricQualitySelectedLevels")
    protected List<RubricQualitySelectedColumnModel> rubricQualitySelectedLevels;

    @JsonProperty("rubricQualitySelectedLevels@nextLink")
    protected String rubricQualitySelectedLevelsNextLink;

    @JsonProperty("publishedRubricQualityFeedback")
    protected List<RubricQualityFeedbackModel> publishedRubricQualityFeedback;

    @JsonProperty("publishedRubricQualityFeedback@nextLink")
    protected String publishedRubricQualityFeedbackNextLink;

    @JsonProperty("publishedRubricQualitySelectedLevels")
    protected List<RubricQualitySelectedColumnModel> publishedRubricQualitySelectedLevels;

    @JsonProperty("publishedRubricQualitySelectedLevels@nextLink")
    protected String publishedRubricQualitySelectedLevelsNextLink;

    protected EducationRubricOutcome() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationRubricOutcome() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private List<RubricQualityFeedbackModel> rubricQualityFeedback;
        private String rubricQualityFeedbackNextLink;
        private List<RubricQualitySelectedColumnModel> rubricQualitySelectedLevels;
        private String rubricQualitySelectedLevelsNextLink;
        private List<RubricQualityFeedbackModel> publishedRubricQualityFeedback;
        private String publishedRubricQualityFeedbackNextLink;
        private List<RubricQualitySelectedColumnModel> publishedRubricQualitySelectedLevels;
        private String publishedRubricQualitySelectedLevelsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder rubricQualityFeedback(List<RubricQualityFeedbackModel> rubricQualityFeedback) {
            this.rubricQualityFeedback = rubricQualityFeedback;
            this.changedFields = changedFields.add("rubricQualityFeedback");
            return this;
        }

        public Builder rubricQualityFeedback(RubricQualityFeedbackModel... rubricQualityFeedback) {
            return rubricQualityFeedback(Arrays.asList(rubricQualityFeedback));
        }

        public Builder rubricQualityFeedbackNextLink(String rubricQualityFeedbackNextLink) {
            this.rubricQualityFeedbackNextLink = rubricQualityFeedbackNextLink;
            this.changedFields = changedFields.add("rubricQualityFeedback");
            return this;
        }

        public Builder rubricQualitySelectedLevels(List<RubricQualitySelectedColumnModel> rubricQualitySelectedLevels) {
            this.rubricQualitySelectedLevels = rubricQualitySelectedLevels;
            this.changedFields = changedFields.add("rubricQualitySelectedLevels");
            return this;
        }

        public Builder rubricQualitySelectedLevels(RubricQualitySelectedColumnModel... rubricQualitySelectedLevels) {
            return rubricQualitySelectedLevels(Arrays.asList(rubricQualitySelectedLevels));
        }

        public Builder rubricQualitySelectedLevelsNextLink(String rubricQualitySelectedLevelsNextLink) {
            this.rubricQualitySelectedLevelsNextLink = rubricQualitySelectedLevelsNextLink;
            this.changedFields = changedFields.add("rubricQualitySelectedLevels");
            return this;
        }

        public Builder publishedRubricQualityFeedback(List<RubricQualityFeedbackModel> publishedRubricQualityFeedback) {
            this.publishedRubricQualityFeedback = publishedRubricQualityFeedback;
            this.changedFields = changedFields.add("publishedRubricQualityFeedback");
            return this;
        }

        public Builder publishedRubricQualityFeedback(RubricQualityFeedbackModel... publishedRubricQualityFeedback) {
            return publishedRubricQualityFeedback(Arrays.asList(publishedRubricQualityFeedback));
        }

        public Builder publishedRubricQualityFeedbackNextLink(String publishedRubricQualityFeedbackNextLink) {
            this.publishedRubricQualityFeedbackNextLink = publishedRubricQualityFeedbackNextLink;
            this.changedFields = changedFields.add("publishedRubricQualityFeedback");
            return this;
        }

        public Builder publishedRubricQualitySelectedLevels(List<RubricQualitySelectedColumnModel> publishedRubricQualitySelectedLevels) {
            this.publishedRubricQualitySelectedLevels = publishedRubricQualitySelectedLevels;
            this.changedFields = changedFields.add("publishedRubricQualitySelectedLevels");
            return this;
        }

        public Builder publishedRubricQualitySelectedLevels(RubricQualitySelectedColumnModel... publishedRubricQualitySelectedLevels) {
            return publishedRubricQualitySelectedLevels(Arrays.asList(publishedRubricQualitySelectedLevels));
        }

        public Builder publishedRubricQualitySelectedLevelsNextLink(String publishedRubricQualitySelectedLevelsNextLink) {
            this.publishedRubricQualitySelectedLevelsNextLink = publishedRubricQualitySelectedLevelsNextLink;
            this.changedFields = changedFields.add("publishedRubricQualitySelectedLevels");
            return this;
        }

        public EducationRubricOutcome build() {
            EducationRubricOutcome _x = new EducationRubricOutcome();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationRubricOutcome";
            _x.id = id;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.rubricQualityFeedback = rubricQualityFeedback;
            _x.rubricQualityFeedbackNextLink = rubricQualityFeedbackNextLink;
            _x.rubricQualitySelectedLevels = rubricQualitySelectedLevels;
            _x.rubricQualitySelectedLevelsNextLink = rubricQualitySelectedLevelsNextLink;
            _x.publishedRubricQualityFeedback = publishedRubricQualityFeedback;
            _x.publishedRubricQualityFeedbackNextLink = publishedRubricQualityFeedbackNextLink;
            _x.publishedRubricQualitySelectedLevels = publishedRubricQualitySelectedLevels;
            _x.publishedRubricQualitySelectedLevelsNextLink = publishedRubricQualitySelectedLevelsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="rubricQualityFeedback")
    @JsonIgnore
    public CollectionPage<RubricQualityFeedbackModel> getRubricQualityFeedback() {
        return new CollectionPage<RubricQualityFeedbackModel>(contextPath, RubricQualityFeedbackModel.class, rubricQualityFeedback, Optional.ofNullable(rubricQualityFeedbackNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="rubricQualityFeedback")
    @JsonIgnore
    public CollectionPage<RubricQualityFeedbackModel> getRubricQualityFeedback(HttpRequestOptions options) {
        return new CollectionPage<RubricQualityFeedbackModel>(contextPath, RubricQualityFeedbackModel.class, rubricQualityFeedback, Optional.ofNullable(rubricQualityFeedbackNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="rubricQualitySelectedLevels")
    @JsonIgnore
    public CollectionPage<RubricQualitySelectedColumnModel> getRubricQualitySelectedLevels() {
        return new CollectionPage<RubricQualitySelectedColumnModel>(contextPath, RubricQualitySelectedColumnModel.class, rubricQualitySelectedLevels, Optional.ofNullable(rubricQualitySelectedLevelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="rubricQualitySelectedLevels")
    @JsonIgnore
    public CollectionPage<RubricQualitySelectedColumnModel> getRubricQualitySelectedLevels(HttpRequestOptions options) {
        return new CollectionPage<RubricQualitySelectedColumnModel>(contextPath, RubricQualitySelectedColumnModel.class, rubricQualitySelectedLevels, Optional.ofNullable(rubricQualitySelectedLevelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="publishedRubricQualityFeedback")
    @JsonIgnore
    public CollectionPage<RubricQualityFeedbackModel> getPublishedRubricQualityFeedback() {
        return new CollectionPage<RubricQualityFeedbackModel>(contextPath, RubricQualityFeedbackModel.class, publishedRubricQualityFeedback, Optional.ofNullable(publishedRubricQualityFeedbackNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="publishedRubricQualityFeedback")
    @JsonIgnore
    public CollectionPage<RubricQualityFeedbackModel> getPublishedRubricQualityFeedback(HttpRequestOptions options) {
        return new CollectionPage<RubricQualityFeedbackModel>(contextPath, RubricQualityFeedbackModel.class, publishedRubricQualityFeedback, Optional.ofNullable(publishedRubricQualityFeedbackNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="publishedRubricQualitySelectedLevels")
    @JsonIgnore
    public CollectionPage<RubricQualitySelectedColumnModel> getPublishedRubricQualitySelectedLevels() {
        return new CollectionPage<RubricQualitySelectedColumnModel>(contextPath, RubricQualitySelectedColumnModel.class, publishedRubricQualitySelectedLevels, Optional.ofNullable(publishedRubricQualitySelectedLevelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="publishedRubricQualitySelectedLevels")
    @JsonIgnore
    public CollectionPage<RubricQualitySelectedColumnModel> getPublishedRubricQualitySelectedLevels(HttpRequestOptions options) {
        return new CollectionPage<RubricQualitySelectedColumnModel>(contextPath, RubricQualitySelectedColumnModel.class, publishedRubricQualitySelectedLevels, Optional.ofNullable(publishedRubricQualitySelectedLevelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationRubricOutcome patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationRubricOutcome _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationRubricOutcome put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationRubricOutcome _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationRubricOutcome _copy() {
        EducationRubricOutcome _x = new EducationRubricOutcome();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.rubricQualityFeedback = rubricQualityFeedback;
        _x.rubricQualitySelectedLevels = rubricQualitySelectedLevels;
        _x.publishedRubricQualityFeedback = publishedRubricQualityFeedback;
        _x.publishedRubricQualitySelectedLevels = publishedRubricQualitySelectedLevels;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationRubricOutcome[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("rubricQualityFeedback=");
        b.append(this.rubricQualityFeedback);
        b.append(", ");
        b.append("rubricQualitySelectedLevels=");
        b.append(this.rubricQualitySelectedLevels);
        b.append(", ");
        b.append("publishedRubricQualityFeedback=");
        b.append(this.publishedRubricQualityFeedback);
        b.append(", ");
        b.append("publishedRubricQualitySelectedLevels=");
        b.append(this.publishedRubricQualitySelectedLevels);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
