package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationAssignmentGradeType;
import odata.msgraph.client.beta.complex.EducationItemBody;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.RubricLevel;
import odata.msgraph.client.beta.complex.RubricQuality;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "description", 
    "qualities", 
    "levels", 
    "grading", 
    "createdDateTime", 
    "createdBy", 
    "lastModifiedDateTime", 
    "lastModifiedBy"})
@JsonInclude(Include.NON_NULL)
public class EducationRubric extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationRubric";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected EducationItemBody description;

    @JsonProperty("qualities")
    protected List<RubricQuality> qualities;

    @JsonProperty("qualities@nextLink")
    protected String qualitiesNextLink;

    @JsonProperty("levels")
    protected List<RubricLevel> levels;

    @JsonProperty("levels@nextLink")
    protected String levelsNextLink;

    @JsonProperty("grading")
    protected EducationAssignmentGradeType grading;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    protected EducationRubric() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationRubric() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private EducationItemBody description;
        private List<RubricQuality> qualities;
        private String qualitiesNextLink;
        private List<RubricLevel> levels;
        private String levelsNextLink;
        private EducationAssignmentGradeType grading;
        private OffsetDateTime createdDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(EducationItemBody description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder qualities(List<RubricQuality> qualities) {
            this.qualities = qualities;
            this.changedFields = changedFields.add("qualities");
            return this;
        }

        public Builder qualities(RubricQuality... qualities) {
            return qualities(Arrays.asList(qualities));
        }

        public Builder qualitiesNextLink(String qualitiesNextLink) {
            this.qualitiesNextLink = qualitiesNextLink;
            this.changedFields = changedFields.add("qualities");
            return this;
        }

        public Builder levels(List<RubricLevel> levels) {
            this.levels = levels;
            this.changedFields = changedFields.add("levels");
            return this;
        }

        public Builder levels(RubricLevel... levels) {
            return levels(Arrays.asList(levels));
        }

        public Builder levelsNextLink(String levelsNextLink) {
            this.levelsNextLink = levelsNextLink;
            this.changedFields = changedFields.add("levels");
            return this;
        }

        public Builder grading(EducationAssignmentGradeType grading) {
            this.grading = grading;
            this.changedFields = changedFields.add("grading");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public EducationRubric build() {
            EducationRubric _x = new EducationRubric();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationRubric";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.qualities = qualities;
            _x.qualitiesNextLink = qualitiesNextLink;
            _x.levels = levels;
            _x.levelsNextLink = levelsNextLink;
            _x.grading = grading;
            _x.createdDateTime = createdDateTime;
            _x.createdBy = createdBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationRubric withDisplayName(String displayName) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<EducationItemBody> getDescription() {
        return Optional.ofNullable(description);
    }

    public EducationRubric withDescription(EducationItemBody description) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.description = description;
        return _x;
    }

    @Property(name="qualities")
    @JsonIgnore
    public CollectionPage<RubricQuality> getQualities() {
        return new CollectionPage<RubricQuality>(contextPath, RubricQuality.class, qualities, Optional.ofNullable(qualitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="qualities")
    @JsonIgnore
    public CollectionPage<RubricQuality> getQualities(HttpRequestOptions options) {
        return new CollectionPage<RubricQuality>(contextPath, RubricQuality.class, qualities, Optional.ofNullable(qualitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="levels")
    @JsonIgnore
    public CollectionPage<RubricLevel> getLevels() {
        return new CollectionPage<RubricLevel>(contextPath, RubricLevel.class, levels, Optional.ofNullable(levelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="levels")
    @JsonIgnore
    public CollectionPage<RubricLevel> getLevels(HttpRequestOptions options) {
        return new CollectionPage<RubricLevel>(contextPath, RubricLevel.class, levels, Optional.ofNullable(levelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="grading")
    @JsonIgnore
    public Optional<EducationAssignmentGradeType> getGrading() {
        return Optional.ofNullable(grading);
    }

    public EducationRubric withGrading(EducationAssignmentGradeType grading) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("grading");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.grading = grading;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public EducationRubric withCreatedDateTime(OffsetDateTime createdDateTime) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public EducationRubric withCreatedBy(IdentitySet createdBy) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public EducationRubric withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public EducationRubric withLastModifiedBy(IdentitySet lastModifiedBy) {
        EducationRubric _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubric");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationRubric patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationRubric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationRubric put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationRubric _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationRubric _copy() {
        EducationRubric _x = new EducationRubric();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.qualities = qualities;
        _x.levels = levels;
        _x.grading = grading;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationRubric[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("qualities=");
        b.append(this.qualities);
        b.append(", ");
        b.append("levels=");
        b.append(this.levels);
        b.append(", ");
        b.append("grading=");
        b.append(this.grading);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
