package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationFeedback;
import odata.msgraph.client.beta.complex.IdentitySet;

@JsonPropertyOrder({
    "@odata.type", 
    "feedback", 
    "publishedFeedback"})
@JsonInclude(Include.NON_NULL)
public class EducationFeedbackOutcome extends EducationOutcome implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationFeedbackOutcome";
    }

    @JsonProperty("feedback")
    protected EducationFeedback feedback;

    @JsonProperty("publishedFeedback")
    protected EducationFeedback publishedFeedback;

    protected EducationFeedbackOutcome() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationFeedbackOutcome() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private EducationFeedback feedback;
        private EducationFeedback publishedFeedback;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder feedback(EducationFeedback feedback) {
            this.feedback = feedback;
            this.changedFields = changedFields.add("feedback");
            return this;
        }

        public Builder publishedFeedback(EducationFeedback publishedFeedback) {
            this.publishedFeedback = publishedFeedback;
            this.changedFields = changedFields.add("publishedFeedback");
            return this;
        }

        public EducationFeedbackOutcome build() {
            EducationFeedbackOutcome _x = new EducationFeedbackOutcome();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationFeedbackOutcome";
            _x.id = id;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.feedback = feedback;
            _x.publishedFeedback = publishedFeedback;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="feedback")
    @JsonIgnore
    public Optional<EducationFeedback> getFeedback() {
        return Optional.ofNullable(feedback);
    }

    public EducationFeedbackOutcome withFeedback(EducationFeedback feedback) {
        EducationFeedbackOutcome _x = _copy();
        _x.changedFields = changedFields.add("feedback");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFeedbackOutcome");
        _x.feedback = feedback;
        return _x;
    }

    @Property(name="publishedFeedback")
    @JsonIgnore
    public Optional<EducationFeedback> getPublishedFeedback() {
        return Optional.ofNullable(publishedFeedback);
    }

    public EducationFeedbackOutcome withPublishedFeedback(EducationFeedback publishedFeedback) {
        EducationFeedbackOutcome _x = _copy();
        _x.changedFields = changedFields.add("publishedFeedback");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFeedbackOutcome");
        _x.publishedFeedback = publishedFeedback;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationFeedbackOutcome patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationFeedbackOutcome _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationFeedbackOutcome put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationFeedbackOutcome _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationFeedbackOutcome _copy() {
        EducationFeedbackOutcome _x = new EducationFeedbackOutcome();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.feedback = feedback;
        _x.publishedFeedback = publishedFeedback;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationFeedbackOutcome[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("feedback=");
        b.append(this.feedback);
        b.append(", ");
        b.append("publishedFeedback=");
        b.append(this.publishedFeedback);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
