package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationCourse;
import odata.msgraph.client.beta.complex.EducationTerm;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSchoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationUserCollectionRequest;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.enums.EducationExternalSource;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "mailNickname", 
    "description", 
    "createdBy", 
    "classCode", 
    "externalName", 
    "externalId", 
    "externalSource", 
    "grade", 
    "term", 
    "course"})
@JsonInclude(Include.NON_NULL)
public class EducationClass extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationClass";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("mailNickname")
    protected String mailNickname;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("classCode")
    protected String classCode;

    @JsonProperty("externalName")
    protected String externalName;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("externalSource")
    protected EducationExternalSource externalSource;

    @JsonProperty("grade")
    protected String grade;

    @JsonProperty("term")
    protected EducationTerm term;

    @JsonProperty("course")
    protected EducationCourse course;

    protected EducationClass() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationClass() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String mailNickname;
        private String description;
        private IdentitySet createdBy;
        private String classCode;
        private String externalName;
        private String externalId;
        private EducationExternalSource externalSource;
        private String grade;
        private EducationTerm term;
        private EducationCourse course;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder mailNickname(String mailNickname) {
            this.mailNickname = mailNickname;
            this.changedFields = changedFields.add("mailNickname");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppDisplayName
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppId
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserDisplayName
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserId
         * 
         * @param createdBy
         *            value of {@code createdBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder classCode(String classCode) {
            this.classCode = classCode;
            this.changedFields = changedFields.add("classCode");
            return this;
        }

        public Builder externalName(String externalName) {
            this.externalName = externalName;
            this.changedFields = changedFields.add("externalName");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder externalSource(EducationExternalSource externalSource) {
            this.externalSource = externalSource;
            this.changedFields = changedFields.add("externalSource");
            return this;
        }

        public Builder grade(String grade) {
            this.grade = grade;
            this.changedFields = changedFields.add("grade");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_TermId
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_TermStartDate
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_TermEndDate
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_TermName
         * 
         * @param term
         *            value of {@code term} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder term(EducationTerm term) {
            this.term = term;
            this.changedFields = changedFields.add("term");
            return this;
        }

        /**
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CourseSubject
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CourseNumber
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CourseDescription
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_CourseName
         * <p>
         * <b>graph.TransparentContainerProperty</b>
         * <p>
         * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_CourseId
         * 
         * @param course
         *            value of {@code course} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder course(EducationCourse course) {
            this.course = course;
            this.changedFields = changedFields.add("course");
            return this;
        }

        public EducationClass build() {
            EducationClass _x = new EducationClass();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationClass";
            _x.id = id;
            _x.displayName = displayName;
            _x.mailNickname = mailNickname;
            _x.description = description;
            _x.createdBy = createdBy;
            _x.classCode = classCode;
            _x.externalName = externalName;
            _x.externalId = externalId;
            _x.externalSource = externalSource;
            _x.grade = grade;
            _x.term = term;
            _x.course = course;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationClass withDisplayName(String displayName) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="mailNickname")
    @JsonIgnore
    public Optional<String> getMailNickname() {
        return Optional.ofNullable(mailNickname);
    }

    public EducationClass withMailNickname(String mailNickname) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("mailNickname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.mailNickname = mailNickname;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public EducationClass withDescription(String description) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.description = description;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppId
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserId
     * 
     * @return property createdBy
     */
    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdBy} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByAppId
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserDisplayName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CreatedByUserId
     * 
     * @param createdBy
     *            new value of {@code createdBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdBy} field changed
     */
    public EducationClass withCreatedBy(IdentitySet createdBy) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="classCode")
    @JsonIgnore
    public Optional<String> getClassCode() {
        return Optional.ofNullable(classCode);
    }

    public EducationClass withClassCode(String classCode) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("classCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.classCode = classCode;
        return _x;
    }

    @Property(name="externalName")
    @JsonIgnore
    public Optional<String> getExternalName() {
        return Optional.ofNullable(externalName);
    }

    public EducationClass withExternalName(String externalName) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("externalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.externalName = externalName;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public EducationClass withExternalId(String externalId) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="externalSource")
    @JsonIgnore
    public Optional<EducationExternalSource> getExternalSource() {
        return Optional.ofNullable(externalSource);
    }

    public EducationClass withExternalSource(EducationExternalSource externalSource) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("externalSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.externalSource = externalSource;
        return _x;
    }

    @Property(name="grade")
    @JsonIgnore
    public Optional<String> getGrade() {
        return Optional.ofNullable(grade);
    }

    public EducationClass withGrade(String grade) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("grade");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.grade = grade;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_TermId
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_TermStartDate
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_TermEndDate
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_TermName
     * 
     * @return property term
     */
    @Property(name="term")
    @JsonIgnore
    public Optional<EducationTerm> getTerm() {
        return Optional.ofNullable(term);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code term} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_TermId
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_TermStartDate
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_TermEndDate
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_TermName
     * 
     * @param term
     *            new value of {@code term} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code term} field changed
     */
    public EducationClass withTerm(EducationTerm term) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("term");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.term = term;
        return _x;
    }

    /**
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CourseSubject
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CourseNumber
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CourseDescription
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CourseName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_CourseId
     * 
     * @return property course
     */
    @Property(name="course")
    @JsonIgnore
    public Optional<EducationCourse> getCourse() {
        return Optional.ofNullable(course);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code course} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CourseSubject
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CourseNumber
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CourseDescription
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_CourseName
     * <p>
     * <b>graph.TransparentContainerProperty</b>
     * <p>
     * extension_fe2174665583431c953114ff7268b7b3_Education_SyncSource_CourseId
     * 
     * @param course
     *            new value of {@code course} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code course} field changed
     */
    public EducationClass withCourse(EducationCourse course) {
        EducationClass _x = _copy();
        _x.changedFields = changedFields.add("course");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationClass");
        _x.course = course;
        return _x;
    }

    @NavigationProperty(name="assignments")
    @JsonIgnore
    public EducationAssignmentCollectionRequest getAssignments() {
        return new EducationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    @NavigationProperty(name="assignmentCategories")
    @JsonIgnore
    public EducationCategoryCollectionRequest getAssignmentCategories() {
        return new EducationCategoryCollectionRequest(
                        contextPath.addSegment("assignmentCategories"));
    }

    @NavigationProperty(name="members")
    @JsonIgnore
    public EducationUserCollectionRequest getMembers() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("members"));
    }

    @NavigationProperty(name="teachers")
    @JsonIgnore
    public EducationUserCollectionRequest getTeachers() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("teachers"));
    }

    @NavigationProperty(name="schools")
    @JsonIgnore
    public EducationSchoolCollectionRequest getSchools() {
        return new EducationSchoolCollectionRequest(
                        contextPath.addSegment("schools"));
    }

    @NavigationProperty(name="group")
    @JsonIgnore
    public GroupRequest getGroup() {
        return new GroupRequest(contextPath.addSegment("group"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationClass patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationClass _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationClass put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationClass _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationClass _copy() {
        EducationClass _x = new EducationClass();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.mailNickname = mailNickname;
        _x.description = description;
        _x.createdBy = createdBy;
        _x.classCode = classCode;
        _x.externalName = externalName;
        _x.externalId = externalId;
        _x.externalSource = externalSource;
        _x.grade = grade;
        _x.term = term;
        _x.course = course;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationClass[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("mailNickname=");
        b.append(this.mailNickname);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("classCode=");
        b.append(this.classCode);
        b.append(", ");
        b.append("externalName=");
        b.append(this.externalName);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("externalSource=");
        b.append(this.externalSource);
        b.append(", ");
        b.append("grade=");
        b.append(this.grade);
        b.append(", ");
        b.append("term=");
        b.append(this.term);
        b.append(", ");
        b.append("course=");
        b.append(this.course);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
