package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationResource;

@JsonPropertyOrder({
    "@odata.type", 
    "distributeForStudentWork", 
    "resource"})
@JsonInclude(Include.NON_NULL)
public class EducationAssignmentResource extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationAssignmentResource";
    }

    @JsonProperty("distributeForStudentWork")
    protected Boolean distributeForStudentWork;

    @JsonProperty("resource")
    protected EducationResource resource;

    protected EducationAssignmentResource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationAssignmentResource() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean distributeForStudentWork;
        private EducationResource resource;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder distributeForStudentWork(Boolean distributeForStudentWork) {
            this.distributeForStudentWork = distributeForStudentWork;
            this.changedFields = changedFields.add("distributeForStudentWork");
            return this;
        }

        public Builder resource(EducationResource resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public EducationAssignmentResource build() {
            EducationAssignmentResource _x = new EducationAssignmentResource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationAssignmentResource";
            _x.id = id;
            _x.distributeForStudentWork = distributeForStudentWork;
            _x.resource = resource;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="distributeForStudentWork")
    @JsonIgnore
    public Optional<Boolean> getDistributeForStudentWork() {
        return Optional.ofNullable(distributeForStudentWork);
    }

    public EducationAssignmentResource withDistributeForStudentWork(Boolean distributeForStudentWork) {
        EducationAssignmentResource _x = _copy();
        _x.changedFields = changedFields.add("distributeForStudentWork");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignmentResource");
        _x.distributeForStudentWork = distributeForStudentWork;
        return _x;
    }

    @Property(name="resource")
    @JsonIgnore
    public Optional<EducationResource> getResource() {
        return Optional.ofNullable(resource);
    }

    public EducationAssignmentResource withResource(EducationResource resource) {
        EducationAssignmentResource _x = _copy();
        _x.changedFields = changedFields.add("resource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignmentResource");
        _x.resource = resource;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationAssignmentResource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationAssignmentResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationAssignmentResource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationAssignmentResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationAssignmentResource _copy() {
        EducationAssignmentResource _x = new EducationAssignmentResource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.distributeForStudentWork = distributeForStudentWork;
        _x.resource = resource;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationAssignmentResource[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("distributeForStudentWork=");
        b.append(this.distributeForStudentWork);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
