package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationAssignmentGradeType;
import odata.msgraph.client.beta.complex.EducationAssignmentRecipient;
import odata.msgraph.client.beta.complex.EducationItemBody;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSubmissionCollectionRequest;
import odata.msgraph.client.beta.entity.request.EducationRubricRequest;
import odata.msgraph.client.beta.enums.EducationAssignmentStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "classId", 
    "displayName", 
    "instructions", 
    "closeDateTime", 
    "dueDateTime", 
    "assignDateTime", 
    "assignedDateTime", 
    "grading", 
    "assignTo", 
    "allowLateSubmissions", 
    "createdDateTime", 
    "createdBy", 
    "lastModifiedDateTime", 
    "lastModifiedBy", 
    "allowStudentsToAddResourcesToSubmission", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class EducationAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationAssignment";
    }

    @JsonProperty("classId")
    protected String classId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("instructions")
    protected EducationItemBody instructions;

    @JsonProperty("closeDateTime")
    protected OffsetDateTime closeDateTime;

    @JsonProperty("dueDateTime")
    protected OffsetDateTime dueDateTime;

    @JsonProperty("assignDateTime")
    protected OffsetDateTime assignDateTime;

    @JsonProperty("assignedDateTime")
    protected OffsetDateTime assignedDateTime;

    @JsonProperty("grading")
    protected EducationAssignmentGradeType grading;

    @JsonProperty("assignTo")
    protected EducationAssignmentRecipient assignTo;

    @JsonProperty("allowLateSubmissions")
    protected Boolean allowLateSubmissions;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    @JsonProperty("allowStudentsToAddResourcesToSubmission")
    protected Boolean allowStudentsToAddResourcesToSubmission;

    @JsonProperty("status")
    protected EducationAssignmentStatus status;

    protected EducationAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String classId;
        private String displayName;
        private EducationItemBody instructions;
        private OffsetDateTime closeDateTime;
        private OffsetDateTime dueDateTime;
        private OffsetDateTime assignDateTime;
        private OffsetDateTime assignedDateTime;
        private EducationAssignmentGradeType grading;
        private EducationAssignmentRecipient assignTo;
        private Boolean allowLateSubmissions;
        private OffsetDateTime createdDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private Boolean allowStudentsToAddResourcesToSubmission;
        private EducationAssignmentStatus status;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder classId(String classId) {
            this.classId = classId;
            this.changedFields = changedFields.add("classId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder instructions(EducationItemBody instructions) {
            this.instructions = instructions;
            this.changedFields = changedFields.add("instructions");
            return this;
        }

        public Builder closeDateTime(OffsetDateTime closeDateTime) {
            this.closeDateTime = closeDateTime;
            this.changedFields = changedFields.add("closeDateTime");
            return this;
        }

        public Builder dueDateTime(OffsetDateTime dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        public Builder assignDateTime(OffsetDateTime assignDateTime) {
            this.assignDateTime = assignDateTime;
            this.changedFields = changedFields.add("assignDateTime");
            return this;
        }

        public Builder assignedDateTime(OffsetDateTime assignedDateTime) {
            this.assignedDateTime = assignedDateTime;
            this.changedFields = changedFields.add("assignedDateTime");
            return this;
        }

        public Builder grading(EducationAssignmentGradeType grading) {
            this.grading = grading;
            this.changedFields = changedFields.add("grading");
            return this;
        }

        public Builder assignTo(EducationAssignmentRecipient assignTo) {
            this.assignTo = assignTo;
            this.changedFields = changedFields.add("assignTo");
            return this;
        }

        public Builder allowLateSubmissions(Boolean allowLateSubmissions) {
            this.allowLateSubmissions = allowLateSubmissions;
            this.changedFields = changedFields.add("allowLateSubmissions");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder allowStudentsToAddResourcesToSubmission(Boolean allowStudentsToAddResourcesToSubmission) {
            this.allowStudentsToAddResourcesToSubmission = allowStudentsToAddResourcesToSubmission;
            this.changedFields = changedFields.add("allowStudentsToAddResourcesToSubmission");
            return this;
        }

        public Builder status(EducationAssignmentStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public EducationAssignment build() {
            EducationAssignment _x = new EducationAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationAssignment";
            _x.id = id;
            _x.classId = classId;
            _x.displayName = displayName;
            _x.instructions = instructions;
            _x.closeDateTime = closeDateTime;
            _x.dueDateTime = dueDateTime;
            _x.assignDateTime = assignDateTime;
            _x.assignedDateTime = assignedDateTime;
            _x.grading = grading;
            _x.assignTo = assignTo;
            _x.allowLateSubmissions = allowLateSubmissions;
            _x.createdDateTime = createdDateTime;
            _x.createdBy = createdBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.allowStudentsToAddResourcesToSubmission = allowStudentsToAddResourcesToSubmission;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="classId")
    @JsonIgnore
    public Optional<String> getClassId() {
        return Optional.ofNullable(classId);
    }

    public EducationAssignment withClassId(String classId) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("classId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.classId = classId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationAssignment withDisplayName(String displayName) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="instructions")
    @JsonIgnore
    public Optional<EducationItemBody> getInstructions() {
        return Optional.ofNullable(instructions);
    }

    public EducationAssignment withInstructions(EducationItemBody instructions) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("instructions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.instructions = instructions;
        return _x;
    }

    @Property(name="closeDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCloseDateTime() {
        return Optional.ofNullable(closeDateTime);
    }

    public EducationAssignment withCloseDateTime(OffsetDateTime closeDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("closeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.closeDateTime = closeDateTime;
        return _x;
    }

    @Property(name="dueDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDueDateTime() {
        return Optional.ofNullable(dueDateTime);
    }

    public EducationAssignment withDueDateTime(OffsetDateTime dueDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("dueDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.dueDateTime = dueDateTime;
        return _x;
    }

    @Property(name="assignDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAssignDateTime() {
        return Optional.ofNullable(assignDateTime);
    }

    public EducationAssignment withAssignDateTime(OffsetDateTime assignDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("assignDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.assignDateTime = assignDateTime;
        return _x;
    }

    @Property(name="assignedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAssignedDateTime() {
        return Optional.ofNullable(assignedDateTime);
    }

    public EducationAssignment withAssignedDateTime(OffsetDateTime assignedDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("assignedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.assignedDateTime = assignedDateTime;
        return _x;
    }

    @Property(name="grading")
    @JsonIgnore
    public Optional<EducationAssignmentGradeType> getGrading() {
        return Optional.ofNullable(grading);
    }

    public EducationAssignment withGrading(EducationAssignmentGradeType grading) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("grading");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.grading = grading;
        return _x;
    }

    @Property(name="assignTo")
    @JsonIgnore
    public Optional<EducationAssignmentRecipient> getAssignTo() {
        return Optional.ofNullable(assignTo);
    }

    public EducationAssignment withAssignTo(EducationAssignmentRecipient assignTo) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("assignTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.assignTo = assignTo;
        return _x;
    }

    @Property(name="allowLateSubmissions")
    @JsonIgnore
    public Optional<Boolean> getAllowLateSubmissions() {
        return Optional.ofNullable(allowLateSubmissions);
    }

    public EducationAssignment withAllowLateSubmissions(Boolean allowLateSubmissions) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("allowLateSubmissions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.allowLateSubmissions = allowLateSubmissions;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public EducationAssignment withCreatedDateTime(OffsetDateTime createdDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public EducationAssignment withCreatedBy(IdentitySet createdBy) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public EducationAssignment withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public EducationAssignment withLastModifiedBy(IdentitySet lastModifiedBy) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="allowStudentsToAddResourcesToSubmission")
    @JsonIgnore
    public Optional<Boolean> getAllowStudentsToAddResourcesToSubmission() {
        return Optional.ofNullable(allowStudentsToAddResourcesToSubmission);
    }

    public EducationAssignment withAllowStudentsToAddResourcesToSubmission(Boolean allowStudentsToAddResourcesToSubmission) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("allowStudentsToAddResourcesToSubmission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.allowStudentsToAddResourcesToSubmission = allowStudentsToAddResourcesToSubmission;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<EducationAssignmentStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public EducationAssignment withStatus(EducationAssignmentStatus status) {
        EducationAssignment _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignment");
        _x.status = status;
        return _x;
    }

    @NavigationProperty(name="resources")
    @JsonIgnore
    public EducationAssignmentResourceCollectionRequest getResources() {
        return new EducationAssignmentResourceCollectionRequest(
                        contextPath.addSegment("resources"));
    }

    @NavigationProperty(name="submissions")
    @JsonIgnore
    public EducationSubmissionCollectionRequest getSubmissions() {
        return new EducationSubmissionCollectionRequest(
                        contextPath.addSegment("submissions"));
    }

    @NavigationProperty(name="categories")
    @JsonIgnore
    public EducationCategoryCollectionRequest getCategories() {
        return new EducationCategoryCollectionRequest(
                        contextPath.addSegment("categories"));
    }

    @NavigationProperty(name="rubric")
    @JsonIgnore
    public EducationRubricRequest getRubric() {
        return new EducationRubricRequest(contextPath.addSegment("rubric"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationAssignment _copy() {
        EducationAssignment _x = new EducationAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.classId = classId;
        _x.displayName = displayName;
        _x.instructions = instructions;
        _x.closeDateTime = closeDateTime;
        _x.dueDateTime = dueDateTime;
        _x.assignDateTime = assignDateTime;
        _x.assignedDateTime = assignedDateTime;
        _x.grading = grading;
        _x.assignTo = assignTo;
        _x.allowLateSubmissions = allowLateSubmissions;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.allowStudentsToAddResourcesToSubmission = allowStudentsToAddResourcesToSubmission;
        _x.status = status;
        return _x;
    }

    @Action(name = "publish")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationAssignment> publish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.publish"), EducationAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getResourcesFolderUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getResourcesFolderUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getResourcesFolderUrl"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("classId=");
        b.append(this.classId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("instructions=");
        b.append(this.instructions);
        b.append(", ");
        b.append("closeDateTime=");
        b.append(this.closeDateTime);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("assignDateTime=");
        b.append(this.assignDateTime);
        b.append(", ");
        b.append("assignedDateTime=");
        b.append(this.assignedDateTime);
        b.append(", ");
        b.append("grading=");
        b.append(this.grading);
        b.append(", ");
        b.append("assignTo=");
        b.append(this.assignTo);
        b.append(", ");
        b.append("allowLateSubmissions=");
        b.append(this.allowLateSubmissions);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("allowStudentsToAddResourcesToSubmission=");
        b.append(this.allowStudentsToAddResourcesToSubmission);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
