package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.EditionUpgradeLicenseType;
import odata.msgraph.client.beta.enums.Windows10EditionType;
import odata.msgraph.client.beta.enums.WindowsSModeConfiguration;


/**
 * <i>“Windows 10 Edition Upgrade configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "licenseType", 
    "targetEdition", 
    "license", 
    "productKey", 
    "windowsSMode"})
@JsonInclude(Include.NON_NULL)
public class EditionUpgradeConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.editionUpgradeConfiguration";
    }

    @JsonProperty("licenseType")
    protected EditionUpgradeLicenseType licenseType;

    @JsonProperty("targetEdition")
    protected Windows10EditionType targetEdition;

    @JsonProperty("license")
    protected String license;

    @JsonProperty("productKey")
    protected String productKey;

    @JsonProperty("windowsSMode")
    protected WindowsSModeConfiguration windowsSMode;

    protected EditionUpgradeConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEditionUpgradeConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private EditionUpgradeLicenseType licenseType;
        private Windows10EditionType targetEdition;
        private String license;
        private String productKey;
        private WindowsSModeConfiguration windowsSMode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Edition Upgrade License Type.”</i>
         * 
         * @param licenseType
         *            value of {@code licenseType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder licenseType(EditionUpgradeLicenseType licenseType) {
            this.licenseType = licenseType;
            this.changedFields = changedFields.add("licenseType");
            return this;
        }

        /**
         * <i>“Edition Upgrade Target Edition.”</i>
         * 
         * @param targetEdition
         *            value of {@code targetEdition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetEdition(Windows10EditionType targetEdition) {
            this.targetEdition = targetEdition;
            this.changedFields = changedFields.add("targetEdition");
            return this;
        }

        /**
         * <i>“Edition Upgrade License File Content.”</i>
         * 
         * @param license
         *            value of {@code license} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder license(String license) {
            this.license = license;
            this.changedFields = changedFields.add("license");
            return this;
        }

        /**
         * <i>“Edition Upgrade Product Key.”</i>
         * 
         * @param productKey
         *            value of {@code productKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productKey(String productKey) {
            this.productKey = productKey;
            this.changedFields = changedFields.add("productKey");
            return this;
        }

        /**
         * <i>“S mode configuration.”</i>
         * 
         * @param windowsSMode
         *            value of {@code windowsSMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsSMode(WindowsSModeConfiguration windowsSMode) {
            this.windowsSMode = windowsSMode;
            this.changedFields = changedFields.add("windowsSMode");
            return this;
        }

        public EditionUpgradeConfiguration build() {
            EditionUpgradeConfiguration _x = new EditionUpgradeConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.editionUpgradeConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.licenseType = licenseType;
            _x.targetEdition = targetEdition;
            _x.license = license;
            _x.productKey = productKey;
            _x.windowsSMode = windowsSMode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Edition Upgrade License Type.”</i>
     * 
     * @return property licenseType
     */
    @Property(name="licenseType")
    @JsonIgnore
    public Optional<EditionUpgradeLicenseType> getLicenseType() {
        return Optional.ofNullable(licenseType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code licenseType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Edition Upgrade License Type.”</i>
     * 
     * @param licenseType
     *            new value of {@code licenseType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code licenseType} field changed
     */
    public EditionUpgradeConfiguration withLicenseType(EditionUpgradeLicenseType licenseType) {
        EditionUpgradeConfiguration _x = _copy();
        _x.changedFields = changedFields.add("licenseType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.editionUpgradeConfiguration");
        _x.licenseType = licenseType;
        return _x;
    }

    /**
     * <i>“Edition Upgrade Target Edition.”</i>
     * 
     * @return property targetEdition
     */
    @Property(name="targetEdition")
    @JsonIgnore
    public Optional<Windows10EditionType> getTargetEdition() {
        return Optional.ofNullable(targetEdition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetEdition}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Edition Upgrade Target Edition.”</i>
     * 
     * @param targetEdition
     *            new value of {@code targetEdition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetEdition} field changed
     */
    public EditionUpgradeConfiguration withTargetEdition(Windows10EditionType targetEdition) {
        EditionUpgradeConfiguration _x = _copy();
        _x.changedFields = changedFields.add("targetEdition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.editionUpgradeConfiguration");
        _x.targetEdition = targetEdition;
        return _x;
    }

    /**
     * <i>“Edition Upgrade License File Content.”</i>
     * 
     * @return property license
     */
    @Property(name="license")
    @JsonIgnore
    public Optional<String> getLicense() {
        return Optional.ofNullable(license);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code license} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Edition Upgrade License File Content.”</i>
     * 
     * @param license
     *            new value of {@code license} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code license} field changed
     */
    public EditionUpgradeConfiguration withLicense(String license) {
        EditionUpgradeConfiguration _x = _copy();
        _x.changedFields = changedFields.add("license");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.editionUpgradeConfiguration");
        _x.license = license;
        return _x;
    }

    /**
     * <i>“Edition Upgrade Product Key.”</i>
     * 
     * @return property productKey
     */
    @Property(name="productKey")
    @JsonIgnore
    public Optional<String> getProductKey() {
        return Optional.ofNullable(productKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productKey} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Edition Upgrade Product Key.”</i>
     * 
     * @param productKey
     *            new value of {@code productKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productKey} field changed
     */
    public EditionUpgradeConfiguration withProductKey(String productKey) {
        EditionUpgradeConfiguration _x = _copy();
        _x.changedFields = changedFields.add("productKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.editionUpgradeConfiguration");
        _x.productKey = productKey;
        return _x;
    }

    /**
     * <i>“S mode configuration.”</i>
     * 
     * @return property windowsSMode
     */
    @Property(name="windowsSMode")
    @JsonIgnore
    public Optional<WindowsSModeConfiguration> getWindowsSMode() {
        return Optional.ofNullable(windowsSMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code windowsSMode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“S mode configuration.”</i>
     * 
     * @param windowsSMode
     *            new value of {@code windowsSMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsSMode} field changed
     */
    public EditionUpgradeConfiguration withWindowsSMode(WindowsSModeConfiguration windowsSMode) {
        EditionUpgradeConfiguration _x = _copy();
        _x.changedFields = changedFields.add("windowsSMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.editionUpgradeConfiguration");
        _x.windowsSMode = windowsSMode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EditionUpgradeConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EditionUpgradeConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EditionUpgradeConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EditionUpgradeConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EditionUpgradeConfiguration _copy() {
        EditionUpgradeConfiguration _x = new EditionUpgradeConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.licenseType = licenseType;
        _x.targetEdition = targetEdition;
        _x.license = license;
        _x.productKey = productKey;
        _x.windowsSMode = windowsSMode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EditionUpgradeConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("licenseType=");
        b.append(this.licenseType);
        b.append(", ");
        b.append("targetEdition=");
        b.append(this.targetEdition);
        b.append(", ");
        b.append("license=");
        b.append(this.license);
        b.append(", ");
        b.append("productKey=");
        b.append(this.productKey);
        b.append(", ");
        b.append("windowsSMode=");
        b.append(this.windowsSMode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
