package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ReviewSetCollectionRequest;
import odata.msgraph.client.beta.enums.CaseStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "createdBy", 
    "lastModifiedBy", 
    "lastModifiedDateTime", 
    "status", 
    "closedBy", 
    "closedDateTime", 
    "externalId", 
    "displayName", 
    "createdDateTime"})
@JsonInclude(Include.NON_NULL)
public class EdiscoveryCase extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ediscoveryCase";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("createdBy")
    protected String createdBy;

    @JsonProperty("lastModifiedBy")
    protected String lastModifiedBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("status")
    protected CaseStatus status;

    @JsonProperty("closedBy")
    protected String closedBy;

    @JsonProperty("closedDateTime")
    protected OffsetDateTime closedDateTime;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    protected EdiscoveryCase() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEdiscoveryCase() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String createdBy;
        private String lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private CaseStatus status;
        private String closedBy;
        private OffsetDateTime closedDateTime;
        private String externalId;
        private String displayName;
        private OffsetDateTime createdDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder status(CaseStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder closedBy(String closedBy) {
            this.closedBy = closedBy;
            this.changedFields = changedFields.add("closedBy");
            return this;
        }

        public Builder closedDateTime(OffsetDateTime closedDateTime) {
            this.closedDateTime = closedDateTime;
            this.changedFields = changedFields.add("closedDateTime");
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public EdiscoveryCase build() {
            EdiscoveryCase _x = new EdiscoveryCase();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.ediscoveryCase";
            _x.id = id;
            _x.description = description;
            _x.createdBy = createdBy;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.status = status;
            _x.closedBy = closedBy;
            _x.closedDateTime = closedDateTime;
            _x.externalId = externalId;
            _x.displayName = displayName;
            _x.createdDateTime = createdDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public EdiscoveryCase withDescription(String description) {
        EdiscoveryCase _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscoveryCase");
        _x.description = description;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public EdiscoveryCase withCreatedBy(String createdBy) {
        EdiscoveryCase _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscoveryCase");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<String> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public EdiscoveryCase withLastModifiedBy(String lastModifiedBy) {
        EdiscoveryCase _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscoveryCase");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public EdiscoveryCase withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        EdiscoveryCase _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscoveryCase");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<CaseStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public EdiscoveryCase withStatus(CaseStatus status) {
        EdiscoveryCase _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscoveryCase");
        _x.status = status;
        return _x;
    }

    @Property(name="closedBy")
    @JsonIgnore
    public Optional<String> getClosedBy() {
        return Optional.ofNullable(closedBy);
    }

    public EdiscoveryCase withClosedBy(String closedBy) {
        EdiscoveryCase _x = _copy();
        _x.changedFields = changedFields.add("closedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscoveryCase");
        _x.closedBy = closedBy;
        return _x;
    }

    @Property(name="closedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getClosedDateTime() {
        return Optional.ofNullable(closedDateTime);
    }

    public EdiscoveryCase withClosedDateTime(OffsetDateTime closedDateTime) {
        EdiscoveryCase _x = _copy();
        _x.changedFields = changedFields.add("closedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscoveryCase");
        _x.closedDateTime = closedDateTime;
        return _x;
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public EdiscoveryCase withExternalId(String externalId) {
        EdiscoveryCase _x = _copy();
        _x.changedFields = changedFields.add("externalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscoveryCase");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EdiscoveryCase withDisplayName(String displayName) {
        EdiscoveryCase _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscoveryCase");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public EdiscoveryCase withCreatedDateTime(OffsetDateTime createdDateTime) {
        EdiscoveryCase _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ediscoveryCase");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @NavigationProperty(name="reviewSets")
    @JsonIgnore
    public ReviewSetCollectionRequest getReviewSets() {
        return new ReviewSetCollectionRequest(
                        contextPath.addSegment("reviewSets"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EdiscoveryCase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EdiscoveryCase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EdiscoveryCase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EdiscoveryCase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EdiscoveryCase _copy() {
        EdiscoveryCase _x = new EdiscoveryCase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.createdBy = createdBy;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.status = status;
        _x.closedBy = closedBy;
        _x.closedDateTime = closedDateTime;
        _x.externalId = externalId;
        _x.displayName = displayName;
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EdiscoveryCase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("closedBy=");
        b.append(this.closedBy);
        b.append(", ");
        b.append("closedDateTime=");
        b.append(this.closedDateTime);
        b.append(", ");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
