package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.DomainNameSource;
import odata.msgraph.client.beta.enums.UserEmailSource;
import odata.msgraph.client.beta.enums.UsernameSource;


/**
 * <i>“Apple device features configuration profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "usernameSource", 
    "usernameAADSource", 
    "userDomainNameSource", 
    "customDomainName"})
@JsonInclude(Include.NON_NULL)
public class EasEmailProfileConfigurationBase extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.easEmailProfileConfigurationBase";
    }

    @JsonProperty("usernameSource")
    protected UserEmailSource usernameSource;

    @JsonProperty("usernameAADSource")
    protected UsernameSource usernameAADSource;

    @JsonProperty("userDomainNameSource")
    protected DomainNameSource userDomainNameSource;

    @JsonProperty("customDomainName")
    protected String customDomainName;

    protected EasEmailProfileConfigurationBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Username attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @return property usernameSource
     */
    @Property(name="usernameSource")
    @JsonIgnore
    public Optional<UserEmailSource> getUsernameSource() {
        return Optional.ofNullable(usernameSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usernameSource}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Username attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @param usernameSource
     *            new value of {@code usernameSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usernameSource} field changed
     */
    public EasEmailProfileConfigurationBase withUsernameSource(UserEmailSource usernameSource) {
        EasEmailProfileConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("usernameSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.easEmailProfileConfigurationBase");
        _x.usernameSource = usernameSource;
        return _x;
    }

    /**
     * <i>“Name of the AAD field, that will be used to retrieve UserName for email profile.”</i>
     * 
     * @return property usernameAADSource
     */
    @Property(name="usernameAADSource")
    @JsonIgnore
    public Optional<UsernameSource> getUsernameAADSource() {
        return Optional.ofNullable(usernameAADSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usernameAADSource
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the AAD field, that will be used to retrieve UserName for email profile.”</i>
     * 
     * @param usernameAADSource
     *            new value of {@code usernameAADSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usernameAADSource} field changed
     */
    public EasEmailProfileConfigurationBase withUsernameAADSource(UsernameSource usernameAADSource) {
        EasEmailProfileConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("usernameAADSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.easEmailProfileConfigurationBase");
        _x.usernameAADSource = usernameAADSource;
        return _x;
    }

    /**
     * <i>“UserDomainname attribute that is picked from AAD and injected into this profile
     * before installing on the device.”</i>
     * 
     * @return property userDomainNameSource
     */
    @Property(name="userDomainNameSource")
    @JsonIgnore
    public Optional<DomainNameSource> getUserDomainNameSource() {
        return Optional.ofNullable(userDomainNameSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userDomainNameSource} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“UserDomainname attribute that is picked from AAD and injected into this profile
     * before installing on the device.”</i>
     * 
     * @param userDomainNameSource
     *            new value of {@code userDomainNameSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userDomainNameSource} field changed
     */
    public EasEmailProfileConfigurationBase withUserDomainNameSource(DomainNameSource userDomainNameSource) {
        EasEmailProfileConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("userDomainNameSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.easEmailProfileConfigurationBase");
        _x.userDomainNameSource = userDomainNameSource;
        return _x;
    }

    /**
     * <i>“Custom domain name value used while generating an email profile before
     * installing on the device.”</i>
     * 
     * @return property customDomainName
     */
    @Property(name="customDomainName")
    @JsonIgnore
    public Optional<String> getCustomDomainName() {
        return Optional.ofNullable(customDomainName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customDomainName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Custom domain name value used while generating an email profile before
     * installing on the device.”</i>
     * 
     * @param customDomainName
     *            new value of {@code customDomainName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customDomainName} field changed
     */
    public EasEmailProfileConfigurationBase withCustomDomainName(String customDomainName) {
        EasEmailProfileConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("customDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.easEmailProfileConfigurationBase");
        _x.customDomainName = customDomainName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EasEmailProfileConfigurationBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EasEmailProfileConfigurationBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EasEmailProfileConfigurationBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EasEmailProfileConfigurationBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EasEmailProfileConfigurationBase _copy() {
        EasEmailProfileConfigurationBase _x = new EasEmailProfileConfigurationBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.usernameSource = usernameSource;
        _x.usernameAADSource = usernameAADSource;
        _x.userDomainNameSource = userDomainNameSource;
        _x.customDomainName = customDomainName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EasEmailProfileConfigurationBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("usernameSource=");
        b.append(this.usernameSource);
        b.append(", ");
        b.append("usernameAADSource=");
        b.append(this.usernameAADSource);
        b.append(", ");
        b.append("userDomainNameSource=");
        b.append(this.userDomainNameSource);
        b.append(", ");
        b.append("customDomainName=");
        b.append(this.customDomainName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
