package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Contains properties for the installation summary of a book for a device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "installedDeviceCount", 
    "failedDeviceCount", 
    "notInstalledDeviceCount", 
    "installedUserCount", 
    "failedUserCount", 
    "notInstalledUserCount"})
@JsonInclude(Include.NON_NULL)
public class EBookInstallSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.eBookInstallSummary";
    }

    @JsonProperty("installedDeviceCount")
    protected Integer installedDeviceCount;

    @JsonProperty("failedDeviceCount")
    protected Integer failedDeviceCount;

    @JsonProperty("notInstalledDeviceCount")
    protected Integer notInstalledDeviceCount;

    @JsonProperty("installedUserCount")
    protected Integer installedUserCount;

    @JsonProperty("failedUserCount")
    protected Integer failedUserCount;

    @JsonProperty("notInstalledUserCount")
    protected Integer notInstalledUserCount;

    protected EBookInstallSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEBookInstallSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer installedDeviceCount;
        private Integer failedDeviceCount;
        private Integer notInstalledDeviceCount;
        private Integer installedUserCount;
        private Integer failedUserCount;
        private Integer notInstalledUserCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of Devices that have successfully installed this book.”</i>
         * 
         * @param installedDeviceCount
         *            value of {@code installedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installedDeviceCount(Integer installedDeviceCount) {
            this.installedDeviceCount = installedDeviceCount;
            this.changedFields = changedFields.add("installedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of Devices that have failed to install this book.”</i>
         * 
         * @param failedDeviceCount
         *            value of {@code failedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDeviceCount(Integer failedDeviceCount) {
            this.failedDeviceCount = failedDeviceCount;
            this.changedFields = changedFields.add("failedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of Devices that does not have this book installed.”</i>
         * 
         * @param notInstalledDeviceCount
         *            value of {@code notInstalledDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notInstalledDeviceCount(Integer notInstalledDeviceCount) {
            this.notInstalledDeviceCount = notInstalledDeviceCount;
            this.changedFields = changedFields.add("notInstalledDeviceCount");
            return this;
        }

        /**
         * <i>“Number of Users whose devices have all succeeded to install this book.”</i>
         * 
         * @param installedUserCount
         *            value of {@code installedUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installedUserCount(Integer installedUserCount) {
            this.installedUserCount = installedUserCount;
            this.changedFields = changedFields.add("installedUserCount");
            return this;
        }

        /**
         * <i>“Number of Users that have 1 or more device that failed to install this book.”</i>
         * 
         * @param failedUserCount
         *            value of {@code failedUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedUserCount(Integer failedUserCount) {
            this.failedUserCount = failedUserCount;
            this.changedFields = changedFields.add("failedUserCount");
            return this;
        }

        /**
         * <i>“Number of Users that did not install this book.”</i>
         * 
         * @param notInstalledUserCount
         *            value of {@code notInstalledUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notInstalledUserCount(Integer notInstalledUserCount) {
            this.notInstalledUserCount = notInstalledUserCount;
            this.changedFields = changedFields.add("notInstalledUserCount");
            return this;
        }

        public EBookInstallSummary build() {
            EBookInstallSummary _x = new EBookInstallSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.eBookInstallSummary";
            _x.id = id;
            _x.installedDeviceCount = installedDeviceCount;
            _x.failedDeviceCount = failedDeviceCount;
            _x.notInstalledDeviceCount = notInstalledDeviceCount;
            _x.installedUserCount = installedUserCount;
            _x.failedUserCount = failedUserCount;
            _x.notInstalledUserCount = notInstalledUserCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Number of Devices that have successfully installed this book.”</i>
     * 
     * @return property installedDeviceCount
     */
    @Property(name="installedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getInstalledDeviceCount() {
        return Optional.ofNullable(installedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of Devices that have successfully installed this book.”</i>
     * 
     * @param installedDeviceCount
     *            new value of {@code installedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installedDeviceCount} field changed
     */
    public EBookInstallSummary withInstalledDeviceCount(Integer installedDeviceCount) {
        EBookInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("installedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.eBookInstallSummary");
        _x.installedDeviceCount = installedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of Devices that have failed to install this book.”</i>
     * 
     * @return property failedDeviceCount
     */
    @Property(name="failedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getFailedDeviceCount() {
        return Optional.ofNullable(failedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of Devices that have failed to install this book.”</i>
     * 
     * @param failedDeviceCount
     *            new value of {@code failedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedDeviceCount} field changed
     */
    public EBookInstallSummary withFailedDeviceCount(Integer failedDeviceCount) {
        EBookInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("failedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.eBookInstallSummary");
        _x.failedDeviceCount = failedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of Devices that does not have this book installed.”</i>
     * 
     * @return property notInstalledDeviceCount
     */
    @Property(name="notInstalledDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNotInstalledDeviceCount() {
        return Optional.ofNullable(notInstalledDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notInstalledDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of Devices that does not have this book installed.”</i>
     * 
     * @param notInstalledDeviceCount
     *            new value of {@code notInstalledDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notInstalledDeviceCount} field changed
     */
    public EBookInstallSummary withNotInstalledDeviceCount(Integer notInstalledDeviceCount) {
        EBookInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("notInstalledDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.eBookInstallSummary");
        _x.notInstalledDeviceCount = notInstalledDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of Users whose devices have all succeeded to install this book.”</i>
     * 
     * @return property installedUserCount
     */
    @Property(name="installedUserCount")
    @JsonIgnore
    public Optional<Integer> getInstalledUserCount() {
        return Optional.ofNullable(installedUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installedUserCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of Users whose devices have all succeeded to install this book.”</i>
     * 
     * @param installedUserCount
     *            new value of {@code installedUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installedUserCount} field changed
     */
    public EBookInstallSummary withInstalledUserCount(Integer installedUserCount) {
        EBookInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("installedUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.eBookInstallSummary");
        _x.installedUserCount = installedUserCount;
        return _x;
    }

    /**
     * <i>“Number of Users that have 1 or more device that failed to install this book.”</i>
     * 
     * @return property failedUserCount
     */
    @Property(name="failedUserCount")
    @JsonIgnore
    public Optional<Integer> getFailedUserCount() {
        return Optional.ofNullable(failedUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedUserCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of Users that have 1 or more device that failed to install this book.”</i>
     * 
     * @param failedUserCount
     *            new value of {@code failedUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedUserCount} field changed
     */
    public EBookInstallSummary withFailedUserCount(Integer failedUserCount) {
        EBookInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("failedUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.eBookInstallSummary");
        _x.failedUserCount = failedUserCount;
        return _x;
    }

    /**
     * <i>“Number of Users that did not install this book.”</i>
     * 
     * @return property notInstalledUserCount
     */
    @Property(name="notInstalledUserCount")
    @JsonIgnore
    public Optional<Integer> getNotInstalledUserCount() {
        return Optional.ofNullable(notInstalledUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notInstalledUserCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of Users that did not install this book.”</i>
     * 
     * @param notInstalledUserCount
     *            new value of {@code notInstalledUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notInstalledUserCount} field changed
     */
    public EBookInstallSummary withNotInstalledUserCount(Integer notInstalledUserCount) {
        EBookInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("notInstalledUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.eBookInstallSummary");
        _x.notInstalledUserCount = notInstalledUserCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EBookInstallSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EBookInstallSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EBookInstallSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EBookInstallSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EBookInstallSummary _copy() {
        EBookInstallSummary _x = new EBookInstallSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.installedDeviceCount = installedDeviceCount;
        _x.failedDeviceCount = failedDeviceCount;
        _x.notInstalledDeviceCount = notInstalledDeviceCount;
        _x.installedUserCount = installedUserCount;
        _x.failedUserCount = failedUserCount;
        _x.notInstalledUserCount = notInstalledUserCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EBookInstallSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("installedDeviceCount=");
        b.append(this.installedDeviceCount);
        b.append(", ");
        b.append("failedDeviceCount=");
        b.append(this.failedDeviceCount);
        b.append(", ");
        b.append("notInstalledDeviceCount=");
        b.append(this.notInstalledDeviceCount);
        b.append(", ");
        b.append("installedUserCount=");
        b.append(this.installedUserCount);
        b.append(", ");
        b.append("failedUserCount=");
        b.append(this.failedUserCount);
        b.append(", ");
        b.append("notInstalledUserCount=");
        b.append(this.notInstalledUserCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
