package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "text"})
@JsonInclude(Include.NON_NULL)
public class DomainDnsTxtRecord extends DomainDnsRecord implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.domainDnsTxtRecord";
    }

    @JsonProperty("text")
    protected String text;

    protected DomainDnsTxtRecord() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDomainDnsTxtRecord() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isOptional;
        private String label;
        private String recordType;
        private String supportedService;
        private Integer ttl;
        private String text;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isOptional(Boolean isOptional) {
            this.isOptional = isOptional;
            this.changedFields = changedFields.add("isOptional");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder recordType(String recordType) {
            this.recordType = recordType;
            this.changedFields = changedFields.add("recordType");
            return this;
        }

        public Builder supportedService(String supportedService) {
            this.supportedService = supportedService;
            this.changedFields = changedFields.add("supportedService");
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            this.changedFields = changedFields.add("ttl");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public DomainDnsTxtRecord build() {
            DomainDnsTxtRecord _x = new DomainDnsTxtRecord();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.domainDnsTxtRecord";
            _x.id = id;
            _x.isOptional = isOptional;
            _x.label = label;
            _x.recordType = recordType;
            _x.supportedService = supportedService;
            _x.ttl = ttl;
            _x.text = text;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public DomainDnsTxtRecord withText(String text) {
        DomainDnsTxtRecord _x = _copy();
        _x.changedFields = changedFields.add("text");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainDnsTxtRecord");
        _x.text = text;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DomainDnsTxtRecord patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DomainDnsTxtRecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DomainDnsTxtRecord put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DomainDnsTxtRecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DomainDnsTxtRecord _copy() {
        DomainDnsTxtRecord _x = new DomainDnsTxtRecord();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.isOptional = isOptional;
        _x.label = label;
        _x.recordType = recordType;
        _x.supportedService = supportedService;
        _x.ttl = ttl;
        _x.text = text;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DomainDnsTxtRecord[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isOptional=");
        b.append(this.isOptional);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("recordType=");
        b.append(this.recordType);
        b.append(", ");
        b.append("supportedService=");
        b.append(this.supportedService);
        b.append(", ");
        b.append("ttl=");
        b.append(this.ttl);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
