package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DomainState;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DomainDnsRecordCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationType", 
    "availabilityStatus", 
    "isAdminManaged", 
    "isDefault", 
    "isInitial", 
    "isRoot", 
    "isVerified", 
    "passwordNotificationWindowInDays", 
    "passwordValidityPeriodInDays", 
    "supportedServices", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class Domain extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.domain";
    }

    @JsonProperty("authenticationType")
    protected String authenticationType;

    @JsonProperty("availabilityStatus")
    protected String availabilityStatus;

    @JsonProperty("isAdminManaged")
    protected Boolean isAdminManaged;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("isInitial")
    protected Boolean isInitial;

    @JsonProperty("isRoot")
    protected Boolean isRoot;

    @JsonProperty("isVerified")
    protected Boolean isVerified;

    @JsonProperty("passwordNotificationWindowInDays")
    protected Integer passwordNotificationWindowInDays;

    @JsonProperty("passwordValidityPeriodInDays")
    protected Integer passwordValidityPeriodInDays;

    @JsonProperty("supportedServices")
    protected List<String> supportedServices;

    @JsonProperty("supportedServices@nextLink")
    protected String supportedServicesNextLink;

    @JsonProperty("state")
    protected DomainState state;

    protected Domain() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDomain() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String authenticationType;
        private String availabilityStatus;
        private Boolean isAdminManaged;
        private Boolean isDefault;
        private Boolean isInitial;
        private Boolean isRoot;
        private Boolean isVerified;
        private Integer passwordNotificationWindowInDays;
        private Integer passwordValidityPeriodInDays;
        private List<String> supportedServices;
        private String supportedServicesNextLink;
        private DomainState state;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            this.changedFields = changedFields.add("authenticationType");
            return this;
        }

        public Builder availabilityStatus(String availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
            this.changedFields = changedFields.add("availabilityStatus");
            return this;
        }

        public Builder isAdminManaged(Boolean isAdminManaged) {
            this.isAdminManaged = isAdminManaged;
            this.changedFields = changedFields.add("isAdminManaged");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder isInitial(Boolean isInitial) {
            this.isInitial = isInitial;
            this.changedFields = changedFields.add("isInitial");
            return this;
        }

        public Builder isRoot(Boolean isRoot) {
            this.isRoot = isRoot;
            this.changedFields = changedFields.add("isRoot");
            return this;
        }

        public Builder isVerified(Boolean isVerified) {
            this.isVerified = isVerified;
            this.changedFields = changedFields.add("isVerified");
            return this;
        }

        public Builder passwordNotificationWindowInDays(Integer passwordNotificationWindowInDays) {
            this.passwordNotificationWindowInDays = passwordNotificationWindowInDays;
            this.changedFields = changedFields.add("passwordNotificationWindowInDays");
            return this;
        }

        public Builder passwordValidityPeriodInDays(Integer passwordValidityPeriodInDays) {
            this.passwordValidityPeriodInDays = passwordValidityPeriodInDays;
            this.changedFields = changedFields.add("passwordValidityPeriodInDays");
            return this;
        }

        public Builder supportedServices(List<String> supportedServices) {
            this.supportedServices = supportedServices;
            this.changedFields = changedFields.add("supportedServices");
            return this;
        }

        public Builder supportedServices(String... supportedServices) {
            return supportedServices(Arrays.asList(supportedServices));
        }

        public Builder supportedServicesNextLink(String supportedServicesNextLink) {
            this.supportedServicesNextLink = supportedServicesNextLink;
            this.changedFields = changedFields.add("supportedServices");
            return this;
        }

        public Builder state(DomainState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Domain build() {
            Domain _x = new Domain();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.domain";
            _x.id = id;
            _x.authenticationType = authenticationType;
            _x.availabilityStatus = availabilityStatus;
            _x.isAdminManaged = isAdminManaged;
            _x.isDefault = isDefault;
            _x.isInitial = isInitial;
            _x.isRoot = isRoot;
            _x.isVerified = isVerified;
            _x.passwordNotificationWindowInDays = passwordNotificationWindowInDays;
            _x.passwordValidityPeriodInDays = passwordValidityPeriodInDays;
            _x.supportedServices = supportedServices;
            _x.supportedServicesNextLink = supportedServicesNextLink;
            _x.state = state;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="authenticationType")
    @JsonIgnore
    public Optional<String> getAuthenticationType() {
        return Optional.ofNullable(authenticationType);
    }

    public Domain withAuthenticationType(String authenticationType) {
        Domain _x = _copy();
        _x.changedFields = changedFields.add("authenticationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domain");
        _x.authenticationType = authenticationType;
        return _x;
    }

    @Property(name="availabilityStatus")
    @JsonIgnore
    public Optional<String> getAvailabilityStatus() {
        return Optional.ofNullable(availabilityStatus);
    }

    public Domain withAvailabilityStatus(String availabilityStatus) {
        Domain _x = _copy();
        _x.changedFields = changedFields.add("availabilityStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domain");
        _x.availabilityStatus = availabilityStatus;
        return _x;
    }

    @Property(name="isAdminManaged")
    @JsonIgnore
    public Optional<Boolean> getIsAdminManaged() {
        return Optional.ofNullable(isAdminManaged);
    }

    public Domain withIsAdminManaged(Boolean isAdminManaged) {
        Domain _x = _copy();
        _x.changedFields = changedFields.add("isAdminManaged");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domain");
        _x.isAdminManaged = isAdminManaged;
        return _x;
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public Domain withIsDefault(Boolean isDefault) {
        Domain _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domain");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="isInitial")
    @JsonIgnore
    public Optional<Boolean> getIsInitial() {
        return Optional.ofNullable(isInitial);
    }

    public Domain withIsInitial(Boolean isInitial) {
        Domain _x = _copy();
        _x.changedFields = changedFields.add("isInitial");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domain");
        _x.isInitial = isInitial;
        return _x;
    }

    @Property(name="isRoot")
    @JsonIgnore
    public Optional<Boolean> getIsRoot() {
        return Optional.ofNullable(isRoot);
    }

    public Domain withIsRoot(Boolean isRoot) {
        Domain _x = _copy();
        _x.changedFields = changedFields.add("isRoot");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domain");
        _x.isRoot = isRoot;
        return _x;
    }

    @Property(name="isVerified")
    @JsonIgnore
    public Optional<Boolean> getIsVerified() {
        return Optional.ofNullable(isVerified);
    }

    public Domain withIsVerified(Boolean isVerified) {
        Domain _x = _copy();
        _x.changedFields = changedFields.add("isVerified");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domain");
        _x.isVerified = isVerified;
        return _x;
    }

    @Property(name="passwordNotificationWindowInDays")
    @JsonIgnore
    public Optional<Integer> getPasswordNotificationWindowInDays() {
        return Optional.ofNullable(passwordNotificationWindowInDays);
    }

    public Domain withPasswordNotificationWindowInDays(Integer passwordNotificationWindowInDays) {
        Domain _x = _copy();
        _x.changedFields = changedFields.add("passwordNotificationWindowInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domain");
        _x.passwordNotificationWindowInDays = passwordNotificationWindowInDays;
        return _x;
    }

    @Property(name="passwordValidityPeriodInDays")
    @JsonIgnore
    public Optional<Integer> getPasswordValidityPeriodInDays() {
        return Optional.ofNullable(passwordValidityPeriodInDays);
    }

    public Domain withPasswordValidityPeriodInDays(Integer passwordValidityPeriodInDays) {
        Domain _x = _copy();
        _x.changedFields = changedFields.add("passwordValidityPeriodInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domain");
        _x.passwordValidityPeriodInDays = passwordValidityPeriodInDays;
        return _x;
    }

    @Property(name="supportedServices")
    @JsonIgnore
    public CollectionPage<String> getSupportedServices() {
        return new CollectionPage<String>(contextPath, String.class, supportedServices, Optional.ofNullable(supportedServicesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="supportedServices")
    @JsonIgnore
    public CollectionPage<String> getSupportedServices(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, supportedServices, Optional.ofNullable(supportedServicesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<DomainState> getState() {
        return Optional.ofNullable(state);
    }

    public Domain withState(DomainState state) {
        Domain _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domain");
        _x.state = state;
        return _x;
    }

    @NavigationProperty(name="serviceConfigurationRecords")
    @JsonIgnore
    public DomainDnsRecordCollectionRequest getServiceConfigurationRecords() {
        return new DomainDnsRecordCollectionRequest(
                        contextPath.addSegment("serviceConfigurationRecords"));
    }

    @NavigationProperty(name="verificationDnsRecords")
    @JsonIgnore
    public DomainDnsRecordCollectionRequest getVerificationDnsRecords() {
        return new DomainDnsRecordCollectionRequest(
                        contextPath.addSegment("verificationDnsRecords"));
    }

    @NavigationProperty(name="domainNameReferences")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getDomainNameReferences() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("domainNameReferences"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Domain patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Domain _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Domain put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Domain _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Domain _copy() {
        Domain _x = new Domain();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.authenticationType = authenticationType;
        _x.availabilityStatus = availabilityStatus;
        _x.isAdminManaged = isAdminManaged;
        _x.isDefault = isDefault;
        _x.isInitial = isInitial;
        _x.isRoot = isRoot;
        _x.isVerified = isVerified;
        _x.passwordNotificationWindowInDays = passwordNotificationWindowInDays;
        _x.passwordValidityPeriodInDays = passwordValidityPeriodInDays;
        _x.supportedServices = supportedServices;
        _x.state = state;
        return _x;
    }

    @Action(name = "forceDelete")
    @JsonIgnore
    public ActionRequestNoReturn forceDelete(Boolean disableUserAccounts) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("disableUserAccounts", "Edm.Boolean", disableUserAccounts)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.forceDelete"), _parameters);
    }

    @Action(name = "verify")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Domain> verify() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Domain>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.verify"), Domain.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Domain[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("authenticationType=");
        b.append(this.authenticationType);
        b.append(", ");
        b.append("availabilityStatus=");
        b.append(this.availabilityStatus);
        b.append(", ");
        b.append("isAdminManaged=");
        b.append(this.isAdminManaged);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("isInitial=");
        b.append(this.isInitial);
        b.append(", ");
        b.append("isRoot=");
        b.append(this.isRoot);
        b.append(", ");
        b.append("isVerified=");
        b.append(this.isVerified);
        b.append(", ");
        b.append("passwordNotificationWindowInDays=");
        b.append(this.passwordNotificationWindowInDays);
        b.append(", ");
        b.append("passwordValidityPeriodInDays=");
        b.append(this.passwordValidityPeriodInDays);
        b.append(", ");
        b.append("supportedServices=");
        b.append(this.supportedServices);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
