package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "content", 
    "location"})
@JsonInclude(Include.NON_NULL)
public class DocumentCommentReply extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.documentCommentReply";
    }

    @JsonProperty("content")
    protected String content;

    @JsonProperty("location")
    protected String location;

    protected DocumentCommentReply() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDocumentCommentReply() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String content;
        private String location;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public DocumentCommentReply build() {
            DocumentCommentReply _x = new DocumentCommentReply();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.documentCommentReply";
            _x.id = id;
            _x.content = content;
            _x.location = location;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public DocumentCommentReply withContent(String content) {
        DocumentCommentReply _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.documentCommentReply");
        _x.content = content;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<String> getLocation() {
        return Optional.ofNullable(location);
    }

    public DocumentCommentReply withLocation(String location) {
        DocumentCommentReply _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.documentCommentReply");
        _x.location = location;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DocumentCommentReply patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DocumentCommentReply _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DocumentCommentReply put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DocumentCommentReply _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DocumentCommentReply _copy() {
        DocumentCommentReply _x = new DocumentCommentReply();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.content = content;
        _x.location = location;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DocumentCommentReply[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
