package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.SettingValue;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "templateId", 
    "values"})
@JsonInclude(Include.NON_NULL)
public class DirectorySetting extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.directorySetting";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("templateId")
    protected String templateId;

    @JsonProperty("values")
    protected List<SettingValue> values;

    @JsonProperty("values@nextLink")
    protected String valuesNextLink;

    protected DirectorySetting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDirectorySetting() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String templateId;
        private List<SettingValue> values;
        private String valuesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            this.changedFields = changedFields.add("templateId");
            return this;
        }

        public Builder values(List<SettingValue> values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public Builder values(SettingValue... values) {
            return values(Arrays.asList(values));
        }

        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public DirectorySetting build() {
            DirectorySetting _x = new DirectorySetting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.directorySetting";
            _x.id = id;
            _x.displayName = displayName;
            _x.templateId = templateId;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DirectorySetting withDisplayName(String displayName) {
        DirectorySetting _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directorySetting");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="templateId")
    @JsonIgnore
    public Optional<String> getTemplateId() {
        return Optional.ofNullable(templateId);
    }

    public DirectorySetting withTemplateId(String templateId) {
        DirectorySetting _x = _copy();
        _x.changedFields = changedFields.add("templateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directorySetting");
        _x.templateId = templateId;
        return _x;
    }

    @Property(name="values")
    @JsonIgnore
    public CollectionPage<SettingValue> getValues() {
        return new CollectionPage<SettingValue>(contextPath, SettingValue.class, values, Optional.ofNullable(valuesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="values")
    @JsonIgnore
    public CollectionPage<SettingValue> getValues(HttpRequestOptions options) {
        return new CollectionPage<SettingValue>(contextPath, SettingValue.class, values, Optional.ofNullable(valuesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DirectorySetting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DirectorySetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DirectorySetting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DirectorySetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DirectorySetting _copy() {
        DirectorySetting _x = new DirectorySetting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.templateId = templateId;
        _x.values = values;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DirectorySetting[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("templateId=");
        b.append(this.templateId);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
