package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AuditActivityInitiator;
import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.complex.TargetResource;
import odata.msgraph.client.beta.enums.OperationResult;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "category", 
    "correlationId", 
    "result", 
    "resultReason", 
    "activityDisplayName", 
    "activityDateTime", 
    "loggedByService", 
    "operationType", 
    "initiatedBy", 
    "targetResources", 
    "additionalDetails"})
@JsonInclude(Include.NON_NULL)
public class DirectoryAudit extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.directoryAudit";
    }

    @JsonProperty("category")
    protected String category;

    @JsonProperty("correlationId")
    protected String correlationId;

    @JsonProperty("result")
    protected OperationResult result;

    @JsonProperty("resultReason")
    protected String resultReason;

    @JsonProperty("activityDisplayName")
    protected String activityDisplayName;

    @JsonProperty("activityDateTime")
    protected OffsetDateTime activityDateTime;

    @JsonProperty("loggedByService")
    protected String loggedByService;

    @JsonProperty("operationType")
    protected String operationType;

    @JsonProperty("initiatedBy")
    protected AuditActivityInitiator initiatedBy;

    @JsonProperty("targetResources")
    protected List<TargetResource> targetResources;

    @JsonProperty("targetResources@nextLink")
    protected String targetResourcesNextLink;

    @JsonProperty("additionalDetails")
    protected List<KeyValue> additionalDetails;

    @JsonProperty("additionalDetails@nextLink")
    protected String additionalDetailsNextLink;

    protected DirectoryAudit() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDirectoryAudit() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String category;
        private String correlationId;
        private OperationResult result;
        private String resultReason;
        private String activityDisplayName;
        private OffsetDateTime activityDateTime;
        private String loggedByService;
        private String operationType;
        private AuditActivityInitiator initiatedBy;
        private List<TargetResource> targetResources;
        private String targetResourcesNextLink;
        private List<KeyValue> additionalDetails;
        private String additionalDetailsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            this.changedFields = changedFields.add("correlationId");
            return this;
        }

        public Builder result(OperationResult result) {
            this.result = result;
            this.changedFields = changedFields.add("result");
            return this;
        }

        public Builder resultReason(String resultReason) {
            this.resultReason = resultReason;
            this.changedFields = changedFields.add("resultReason");
            return this;
        }

        public Builder activityDisplayName(String activityDisplayName) {
            this.activityDisplayName = activityDisplayName;
            this.changedFields = changedFields.add("activityDisplayName");
            return this;
        }

        public Builder activityDateTime(OffsetDateTime activityDateTime) {
            this.activityDateTime = activityDateTime;
            this.changedFields = changedFields.add("activityDateTime");
            return this;
        }

        public Builder loggedByService(String loggedByService) {
            this.loggedByService = loggedByService;
            this.changedFields = changedFields.add("loggedByService");
            return this;
        }

        public Builder operationType(String operationType) {
            this.operationType = operationType;
            this.changedFields = changedFields.add("operationType");
            return this;
        }

        public Builder initiatedBy(AuditActivityInitiator initiatedBy) {
            this.initiatedBy = initiatedBy;
            this.changedFields = changedFields.add("initiatedBy");
            return this;
        }

        public Builder targetResources(List<TargetResource> targetResources) {
            this.targetResources = targetResources;
            this.changedFields = changedFields.add("targetResources");
            return this;
        }

        public Builder targetResources(TargetResource... targetResources) {
            return targetResources(Arrays.asList(targetResources));
        }

        public Builder targetResourcesNextLink(String targetResourcesNextLink) {
            this.targetResourcesNextLink = targetResourcesNextLink;
            this.changedFields = changedFields.add("targetResources");
            return this;
        }

        public Builder additionalDetails(List<KeyValue> additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.changedFields = changedFields.add("additionalDetails");
            return this;
        }

        public Builder additionalDetails(KeyValue... additionalDetails) {
            return additionalDetails(Arrays.asList(additionalDetails));
        }

        public Builder additionalDetailsNextLink(String additionalDetailsNextLink) {
            this.additionalDetailsNextLink = additionalDetailsNextLink;
            this.changedFields = changedFields.add("additionalDetails");
            return this;
        }

        public DirectoryAudit build() {
            DirectoryAudit _x = new DirectoryAudit();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.directoryAudit";
            _x.id = id;
            _x.category = category;
            _x.correlationId = correlationId;
            _x.result = result;
            _x.resultReason = resultReason;
            _x.activityDisplayName = activityDisplayName;
            _x.activityDateTime = activityDateTime;
            _x.loggedByService = loggedByService;
            _x.operationType = operationType;
            _x.initiatedBy = initiatedBy;
            _x.targetResources = targetResources;
            _x.targetResourcesNextLink = targetResourcesNextLink;
            _x.additionalDetails = additionalDetails;
            _x.additionalDetailsNextLink = additionalDetailsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    public DirectoryAudit withCategory(String category) {
        DirectoryAudit _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryAudit");
        _x.category = category;
        return _x;
    }

    @Property(name="correlationId")
    @JsonIgnore
    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(correlationId);
    }

    public DirectoryAudit withCorrelationId(String correlationId) {
        DirectoryAudit _x = _copy();
        _x.changedFields = changedFields.add("correlationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryAudit");
        _x.correlationId = correlationId;
        return _x;
    }

    @Property(name="result")
    @JsonIgnore
    public Optional<OperationResult> getResult() {
        return Optional.ofNullable(result);
    }

    public DirectoryAudit withResult(OperationResult result) {
        DirectoryAudit _x = _copy();
        _x.changedFields = changedFields.add("result");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryAudit");
        _x.result = result;
        return _x;
    }

    @Property(name="resultReason")
    @JsonIgnore
    public Optional<String> getResultReason() {
        return Optional.ofNullable(resultReason);
    }

    public DirectoryAudit withResultReason(String resultReason) {
        DirectoryAudit _x = _copy();
        _x.changedFields = changedFields.add("resultReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryAudit");
        _x.resultReason = resultReason;
        return _x;
    }

    @Property(name="activityDisplayName")
    @JsonIgnore
    public Optional<String> getActivityDisplayName() {
        return Optional.ofNullable(activityDisplayName);
    }

    public DirectoryAudit withActivityDisplayName(String activityDisplayName) {
        DirectoryAudit _x = _copy();
        _x.changedFields = changedFields.add("activityDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryAudit");
        _x.activityDisplayName = activityDisplayName;
        return _x;
    }

    @Property(name="activityDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getActivityDateTime() {
        return Optional.ofNullable(activityDateTime);
    }

    public DirectoryAudit withActivityDateTime(OffsetDateTime activityDateTime) {
        DirectoryAudit _x = _copy();
        _x.changedFields = changedFields.add("activityDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryAudit");
        _x.activityDateTime = activityDateTime;
        return _x;
    }

    @Property(name="loggedByService")
    @JsonIgnore
    public Optional<String> getLoggedByService() {
        return Optional.ofNullable(loggedByService);
    }

    public DirectoryAudit withLoggedByService(String loggedByService) {
        DirectoryAudit _x = _copy();
        _x.changedFields = changedFields.add("loggedByService");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryAudit");
        _x.loggedByService = loggedByService;
        return _x;
    }

    @Property(name="operationType")
    @JsonIgnore
    public Optional<String> getOperationType() {
        return Optional.ofNullable(operationType);
    }

    public DirectoryAudit withOperationType(String operationType) {
        DirectoryAudit _x = _copy();
        _x.changedFields = changedFields.add("operationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryAudit");
        _x.operationType = operationType;
        return _x;
    }

    @Property(name="initiatedBy")
    @JsonIgnore
    public Optional<AuditActivityInitiator> getInitiatedBy() {
        return Optional.ofNullable(initiatedBy);
    }

    public DirectoryAudit withInitiatedBy(AuditActivityInitiator initiatedBy) {
        DirectoryAudit _x = _copy();
        _x.changedFields = changedFields.add("initiatedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryAudit");
        _x.initiatedBy = initiatedBy;
        return _x;
    }

    @Property(name="targetResources")
    @JsonIgnore
    public CollectionPage<TargetResource> getTargetResources() {
        return new CollectionPage<TargetResource>(contextPath, TargetResource.class, targetResources, Optional.ofNullable(targetResourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="targetResources")
    @JsonIgnore
    public CollectionPage<TargetResource> getTargetResources(HttpRequestOptions options) {
        return new CollectionPage<TargetResource>(contextPath, TargetResource.class, targetResources, Optional.ofNullable(targetResourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="additionalDetails")
    @JsonIgnore
    public CollectionPage<KeyValue> getAdditionalDetails() {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, additionalDetails, Optional.ofNullable(additionalDetailsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="additionalDetails")
    @JsonIgnore
    public CollectionPage<KeyValue> getAdditionalDetails(HttpRequestOptions options) {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, additionalDetails, Optional.ofNullable(additionalDetailsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DirectoryAudit patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DirectoryAudit _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DirectoryAudit put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DirectoryAudit _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DirectoryAudit _copy() {
        DirectoryAudit _x = new DirectoryAudit();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.category = category;
        _x.correlationId = correlationId;
        _x.result = result;
        _x.resultReason = resultReason;
        _x.activityDisplayName = activityDisplayName;
        _x.activityDateTime = activityDateTime;
        _x.loggedByService = loggedByService;
        _x.operationType = operationType;
        _x.initiatedBy = initiatedBy;
        _x.targetResources = targetResources;
        _x.additionalDetails = additionalDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DirectoryAudit[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("correlationId=");
        b.append(this.correlationId);
        b.append(", ");
        b.append("result=");
        b.append(this.result);
        b.append(", ");
        b.append("resultReason=");
        b.append(this.resultReason);
        b.append(", ");
        b.append("activityDisplayName=");
        b.append(this.activityDisplayName);
        b.append(", ");
        b.append("activityDateTime=");
        b.append(this.activityDateTime);
        b.append(", ");
        b.append("loggedByService=");
        b.append(this.loggedByService);
        b.append(", ");
        b.append("operationType=");
        b.append(this.operationType);
        b.append(", ");
        b.append("initiatedBy=");
        b.append(this.initiatedBy);
        b.append(", ");
        b.append("targetResources=");
        b.append(this.targetResources);
        b.append(", ");
        b.append("additionalDetails=");
        b.append(this.additionalDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
