package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptDeviceStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptGroupAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptUserStateCollectionRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementScriptRunSummaryRequest;
import odata.msgraph.client.beta.enums.RunAsAccountType;


/**
 * <i>“Intune will provide customer the ability to run their Shell scripts on the
 * enrolled Mac OS devices. The script can be run once or periodically.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "executionFrequency", 
    "retryCount", 
    "blockExecutionNotifications", 
    "displayName", 
    "description", 
    "scriptContent", 
    "createdDateTime", 
    "lastModifiedDateTime", 
    "runAsAccount", 
    "fileName", 
    "roleScopeTagIds"})
@JsonInclude(Include.NON_NULL)
public class DeviceShellScript extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceShellScript";
    }

    @JsonProperty("executionFrequency")
    protected Duration executionFrequency;

    @JsonProperty("retryCount")
    protected Integer retryCount;

    @JsonProperty("blockExecutionNotifications")
    protected Boolean blockExecutionNotifications;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("scriptContent")
    protected byte[] scriptContent;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("runAsAccount")
    protected RunAsAccountType runAsAccount;

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    protected DeviceShellScript() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceShellScript() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Duration executionFrequency;
        private Integer retryCount;
        private Boolean blockExecutionNotifications;
        private String displayName;
        private String description;
        private byte[] scriptContent;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private RunAsAccountType runAsAccount;
        private String fileName;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The interval for script to run. If not defined the script will run once”</i>
         * 
         * @param executionFrequency
         *            value of {@code executionFrequency} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder executionFrequency(Duration executionFrequency) {
            this.executionFrequency = executionFrequency;
            this.changedFields = changedFields.add("executionFrequency");
            return this;
        }

        /**
         * <i>“Number of times for the script to be retried if it fails”</i>
         * 
         * @param retryCount
         *            value of {@code retryCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder retryCount(Integer retryCount) {
            this.retryCount = retryCount;
            this.changedFields = changedFields.add("retryCount");
            return this;
        }

        /**
         * <i>“Does not notify the user a script is being executed”</i>
         * 
         * @param blockExecutionNotifications
         *            value of {@code blockExecutionNotifications} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockExecutionNotifications(Boolean blockExecutionNotifications) {
            this.blockExecutionNotifications = blockExecutionNotifications;
            this.changedFields = changedFields.add("blockExecutionNotifications");
            return this;
        }

        /**
         * <i>“Name of the device management script.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Optional description for the device management script.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The script content.”</i>
         * 
         * @param scriptContent
         *            value of {@code scriptContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scriptContent(byte[] scriptContent) {
            this.scriptContent = scriptContent;
            this.changedFields = changedFields.add("scriptContent");
            return this;
        }

        /**
         * <i>“The date and time the device management script was created. This property is
         * read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The date and time the device management script was last modified. This property
         * is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Indicates the type of execution context.”</i>
         * 
         * @param runAsAccount
         *            value of {@code runAsAccount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runAsAccount(RunAsAccountType runAsAccount) {
            this.runAsAccount = runAsAccount;
            this.changedFields = changedFields.add("runAsAccount");
            return this;
        }

        /**
         * <i>“Script file name.”</i>
         * 
         * @param fileName
         *            value of {@code fileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        /**
         * <i>“List of Scope Tag IDs for this PowerShellScript instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tag IDs for this PowerShellScript instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tag IDs for this PowerShellScript instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public DeviceShellScript build() {
            DeviceShellScript _x = new DeviceShellScript();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceShellScript";
            _x.id = id;
            _x.executionFrequency = executionFrequency;
            _x.retryCount = retryCount;
            _x.blockExecutionNotifications = blockExecutionNotifications;
            _x.displayName = displayName;
            _x.description = description;
            _x.scriptContent = scriptContent;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.runAsAccount = runAsAccount;
            _x.fileName = fileName;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The interval for script to run. If not defined the script will run once”</i>
     * 
     * @return property executionFrequency
     */
    @Property(name="executionFrequency")
    @JsonIgnore
    public Optional<Duration> getExecutionFrequency() {
        return Optional.ofNullable(executionFrequency);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * executionFrequency} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The interval for script to run. If not defined the script will run once”</i>
     * 
     * @param executionFrequency
     *            new value of {@code executionFrequency} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code executionFrequency} field changed
     */
    public DeviceShellScript withExecutionFrequency(Duration executionFrequency) {
        DeviceShellScript _x = _copy();
        _x.changedFields = changedFields.add("executionFrequency");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceShellScript");
        _x.executionFrequency = executionFrequency;
        return _x;
    }

    /**
     * <i>“Number of times for the script to be retried if it fails”</i>
     * 
     * @return property retryCount
     */
    @Property(name="retryCount")
    @JsonIgnore
    public Optional<Integer> getRetryCount() {
        return Optional.ofNullable(retryCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code retryCount} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Number of times for the script to be retried if it fails”</i>
     * 
     * @param retryCount
     *            new value of {@code retryCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code retryCount} field changed
     */
    public DeviceShellScript withRetryCount(Integer retryCount) {
        DeviceShellScript _x = _copy();
        _x.changedFields = changedFields.add("retryCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceShellScript");
        _x.retryCount = retryCount;
        return _x;
    }

    /**
     * <i>“Does not notify the user a script is being executed”</i>
     * 
     * @return property blockExecutionNotifications
     */
    @Property(name="blockExecutionNotifications")
    @JsonIgnore
    public Optional<Boolean> getBlockExecutionNotifications() {
        return Optional.ofNullable(blockExecutionNotifications);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockExecutionNotifications} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Does not notify the user a script is being executed”</i>
     * 
     * @param blockExecutionNotifications
     *            new value of {@code blockExecutionNotifications} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockExecutionNotifications} field changed
     */
    public DeviceShellScript withBlockExecutionNotifications(Boolean blockExecutionNotifications) {
        DeviceShellScript _x = _copy();
        _x.changedFields = changedFields.add("blockExecutionNotifications");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceShellScript");
        _x.blockExecutionNotifications = blockExecutionNotifications;
        return _x;
    }

    /**
     * <i>“Name of the device management script.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the device management script.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceShellScript withDisplayName(String displayName) {
        DeviceShellScript _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceShellScript");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Optional description for the device management script.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Optional description for the device management script.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceShellScript withDescription(String description) {
        DeviceShellScript _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceShellScript");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The script content.”</i>
     * 
     * @return property scriptContent
     */
    @Property(name="scriptContent")
    @JsonIgnore
    public Optional<byte[]> getScriptContent() {
        return Optional.ofNullable(scriptContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code scriptContent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The script content.”</i>
     * 
     * @param scriptContent
     *            new value of {@code scriptContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scriptContent} field changed
     */
    public DeviceShellScript withScriptContent(byte[] scriptContent) {
        DeviceShellScript _x = _copy();
        _x.changedFields = changedFields.add("scriptContent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceShellScript");
        _x.scriptContent = scriptContent;
        return _x;
    }

    /**
     * <i>“The date and time the device management script was created. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date and time the device management script was created. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceShellScript withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceShellScript _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceShellScript");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The date and time the device management script was last modified. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time the device management script was last modified. This property
     * is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceShellScript withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceShellScript _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceShellScript");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Indicates the type of execution context.”</i>
     * 
     * @return property runAsAccount
     */
    @Property(name="runAsAccount")
    @JsonIgnore
    public Optional<RunAsAccountType> getRunAsAccount() {
        return Optional.ofNullable(runAsAccount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runAsAccount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates the type of execution context.”</i>
     * 
     * @param runAsAccount
     *            new value of {@code runAsAccount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runAsAccount} field changed
     */
    public DeviceShellScript withRunAsAccount(RunAsAccountType runAsAccount) {
        DeviceShellScript _x = _copy();
        _x.changedFields = changedFields.add("runAsAccount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceShellScript");
        _x.runAsAccount = runAsAccount;
        return _x;
    }

    /**
     * <i>“Script file name.”</i>
     * 
     * @return property fileName
     */
    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fileName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Script file name.”</i>
     * 
     * @param fileName
     *            new value of {@code fileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileName} field changed
     */
    public DeviceShellScript withFileName(String fileName) {
        DeviceShellScript _x = _copy();
        _x.changedFields = changedFields.add("fileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceShellScript");
        _x.fileName = fileName;
        return _x;
    }

    /**
     * <i>“List of Scope Tag IDs for this PowerShellScript instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tag IDs for this PowerShellScript instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“The list of group assignments for the device management script.”</i>
     * 
     * @return navigational property groupAssignments
     */
    @NavigationProperty(name="groupAssignments")
    @JsonIgnore
    public DeviceManagementScriptGroupAssignmentCollectionRequest getGroupAssignments() {
        return new DeviceManagementScriptGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"));
    }

    /**
     * <i>“The list of group assignments for the device management script.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public DeviceManagementScriptAssignmentCollectionRequest getAssignments() {
        return new DeviceManagementScriptAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    /**
     * <i>“Run summary for device management script.”</i>
     * 
     * @return navigational property runSummary
     */
    @NavigationProperty(name="runSummary")
    @JsonIgnore
    public DeviceManagementScriptRunSummaryRequest getRunSummary() {
        return new DeviceManagementScriptRunSummaryRequest(contextPath.addSegment("runSummary"));
    }

    /**
     * <i>“List of run states for this script across all devices.”</i>
     * 
     * @return navigational property deviceRunStates
     */
    @NavigationProperty(name="deviceRunStates")
    @JsonIgnore
    public DeviceManagementScriptDeviceStateCollectionRequest getDeviceRunStates() {
        return new DeviceManagementScriptDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceRunStates"));
    }

    /**
     * <i>“List of run states for this script across all users.”</i>
     * 
     * @return navigational property userRunStates
     */
    @NavigationProperty(name="userRunStates")
    @JsonIgnore
    public DeviceManagementScriptUserStateCollectionRequest getUserRunStates() {
        return new DeviceManagementScriptUserStateCollectionRequest(
                        contextPath.addSegment("userRunStates"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceShellScript patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceShellScript _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceShellScript put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceShellScript _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceShellScript _copy() {
        DeviceShellScript _x = new DeviceShellScript();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.executionFrequency = executionFrequency;
        _x.retryCount = retryCount;
        _x.blockExecutionNotifications = blockExecutionNotifications;
        _x.displayName = displayName;
        _x.description = description;
        _x.scriptContent = scriptContent;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.runAsAccount = runAsAccount;
        _x.fileName = fileName;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<DeviceManagementScriptGroupAssignment> deviceManagementScriptGroupAssignments, List<DeviceManagementScriptAssignment> deviceManagementScriptAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceManagementScriptGroupAssignments", "Collection(microsoft.graph.deviceManagementScriptGroupAssignment)", deviceManagementScriptGroupAssignments)
            .put("deviceManagementScriptAssignments", "Collection(microsoft.graph.deviceManagementScriptAssignment)", deviceManagementScriptAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceShellScript[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("executionFrequency=");
        b.append(this.executionFrequency);
        b.append(", ");
        b.append("retryCount=");
        b.append(this.retryCount);
        b.append(", ");
        b.append("blockExecutionNotifications=");
        b.append(this.blockExecutionNotifications);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("scriptContent=");
        b.append(this.scriptContent);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("runAsAccount=");
        b.append(this.runAsAccount);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
