package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementSettingComparison;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTemplateSettingCategoryCollectionRequest;
import odata.msgraph.client.beta.enums.DeviceManagementTemplateSubtype;
import odata.msgraph.client.beta.enums.DeviceManagementTemplateType;
import odata.msgraph.client.beta.enums.PolicyPlatformType;


/**
 * <i>“Entity that represents a defined collection of device settings”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "description", 
    "versionInfo", 
    "isDeprecated", 
    "intentCount", 
    "templateType", 
    "platformType", 
    "templateSubtype", 
    "publishedDateTime"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementTemplate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementTemplate";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("versionInfo")
    protected String versionInfo;

    @JsonProperty("isDeprecated")
    protected Boolean isDeprecated;

    @JsonProperty("intentCount")
    protected Integer intentCount;

    @JsonProperty("templateType")
    protected DeviceManagementTemplateType templateType;

    @JsonProperty("platformType")
    protected PolicyPlatformType platformType;

    @JsonProperty("templateSubtype")
    protected DeviceManagementTemplateSubtype templateSubtype;

    @JsonProperty("publishedDateTime")
    protected OffsetDateTime publishedDateTime;

    protected DeviceManagementTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String versionInfo;
        private Boolean isDeprecated;
        private Integer intentCount;
        private DeviceManagementTemplateType templateType;
        private PolicyPlatformType platformType;
        private DeviceManagementTemplateSubtype templateSubtype;
        private OffsetDateTime publishedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The template's display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The template's description”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The template's version information”</i>
         * 
         * @param versionInfo
         *            value of {@code versionInfo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder versionInfo(String versionInfo) {
            this.versionInfo = versionInfo;
            this.changedFields = changedFields.add("versionInfo");
            return this;
        }

        /**
         * <i>“The template is deprecated or not. Intents cannot be created from a deprecated
         * template.”</i>
         * 
         * @param isDeprecated
         *            value of {@code isDeprecated} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isDeprecated(Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            this.changedFields = changedFields.add("isDeprecated");
            return this;
        }

        /**
         * <i>“Number of Intents created from this template.”</i>
         * 
         * @param intentCount
         *            value of {@code intentCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intentCount(Integer intentCount) {
            this.intentCount = intentCount;
            this.changedFields = changedFields.add("intentCount");
            return this;
        }

        /**
         * <i>“The template's type.”</i>
         * 
         * @param templateType
         *            value of {@code templateType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateType(DeviceManagementTemplateType templateType) {
            this.templateType = templateType;
            this.changedFields = changedFields.add("templateType");
            return this;
        }

        /**
         * <i>“The template's platform.”</i>
         * 
         * @param platformType
         *            value of {@code platformType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platformType(PolicyPlatformType platformType) {
            this.platformType = platformType;
            this.changedFields = changedFields.add("platformType");
            return this;
        }

        /**
         * <i>“The template's subtype.”</i>
         * 
         * @param templateSubtype
         *            value of {@code templateSubtype} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateSubtype(DeviceManagementTemplateSubtype templateSubtype) {
            this.templateSubtype = templateSubtype;
            this.changedFields = changedFields.add("templateSubtype");
            return this;
        }

        /**
         * <i>“When the template was published”</i>
         * 
         * @param publishedDateTime
         *            value of {@code publishedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publishedDateTime(OffsetDateTime publishedDateTime) {
            this.publishedDateTime = publishedDateTime;
            this.changedFields = changedFields.add("publishedDateTime");
            return this;
        }

        public DeviceManagementTemplate build() {
            DeviceManagementTemplate _x = new DeviceManagementTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementTemplate";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.versionInfo = versionInfo;
            _x.isDeprecated = isDeprecated;
            _x.intentCount = intentCount;
            _x.templateType = templateType;
            _x.platformType = platformType;
            _x.templateSubtype = templateSubtype;
            _x.publishedDateTime = publishedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The template's display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The template's display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementTemplate withDisplayName(String displayName) {
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTemplate");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The template's description”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The template's description”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementTemplate withDescription(String description) {
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTemplate");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The template's version information”</i>
     * 
     * @return property versionInfo
     */
    @Property(name="versionInfo")
    @JsonIgnore
    public Optional<String> getVersionInfo() {
        return Optional.ofNullable(versionInfo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code versionInfo}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The template's version information”</i>
     * 
     * @param versionInfo
     *            new value of {@code versionInfo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code versionInfo} field changed
     */
    public DeviceManagementTemplate withVersionInfo(String versionInfo) {
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("versionInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTemplate");
        _x.versionInfo = versionInfo;
        return _x;
    }

    /**
     * <i>“The template is deprecated or not. Intents cannot be created from a deprecated
     * template.”</i>
     * 
     * @return property isDeprecated
     */
    @Property(name="isDeprecated")
    @JsonIgnore
    public Optional<Boolean> getIsDeprecated() {
        return Optional.ofNullable(isDeprecated);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isDeprecated}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The template is deprecated or not. Intents cannot be created from a deprecated
     * template.”</i>
     * 
     * @param isDeprecated
     *            new value of {@code isDeprecated} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isDeprecated} field changed
     */
    public DeviceManagementTemplate withIsDeprecated(Boolean isDeprecated) {
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("isDeprecated");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTemplate");
        _x.isDeprecated = isDeprecated;
        return _x;
    }

    /**
     * <i>“Number of Intents created from this template.”</i>
     * 
     * @return property intentCount
     */
    @Property(name="intentCount")
    @JsonIgnore
    public Optional<Integer> getIntentCount() {
        return Optional.ofNullable(intentCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intentCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of Intents created from this template.”</i>
     * 
     * @param intentCount
     *            new value of {@code intentCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intentCount} field changed
     */
    public DeviceManagementTemplate withIntentCount(Integer intentCount) {
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("intentCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTemplate");
        _x.intentCount = intentCount;
        return _x;
    }

    /**
     * <i>“The template's type.”</i>
     * 
     * @return property templateType
     */
    @Property(name="templateType")
    @JsonIgnore
    public Optional<DeviceManagementTemplateType> getTemplateType() {
        return Optional.ofNullable(templateType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code templateType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The template's type.”</i>
     * 
     * @param templateType
     *            new value of {@code templateType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templateType} field changed
     */
    public DeviceManagementTemplate withTemplateType(DeviceManagementTemplateType templateType) {
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("templateType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTemplate");
        _x.templateType = templateType;
        return _x;
    }

    /**
     * <i>“The template's platform.”</i>
     * 
     * @return property platformType
     */
    @Property(name="platformType")
    @JsonIgnore
    public Optional<PolicyPlatformType> getPlatformType() {
        return Optional.ofNullable(platformType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platformType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The template's platform.”</i>
     * 
     * @param platformType
     *            new value of {@code platformType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platformType} field changed
     */
    public DeviceManagementTemplate withPlatformType(PolicyPlatformType platformType) {
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("platformType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTemplate");
        _x.platformType = platformType;
        return _x;
    }

    /**
     * <i>“The template's subtype.”</i>
     * 
     * @return property templateSubtype
     */
    @Property(name="templateSubtype")
    @JsonIgnore
    public Optional<DeviceManagementTemplateSubtype> getTemplateSubtype() {
        return Optional.ofNullable(templateSubtype);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code templateSubtype}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The template's subtype.”</i>
     * 
     * @param templateSubtype
     *            new value of {@code templateSubtype} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templateSubtype} field changed
     */
    public DeviceManagementTemplate withTemplateSubtype(DeviceManagementTemplateSubtype templateSubtype) {
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("templateSubtype");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTemplate");
        _x.templateSubtype = templateSubtype;
        return _x;
    }

    /**
     * <i>“When the template was published”</i>
     * 
     * @return property publishedDateTime
     */
    @Property(name="publishedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getPublishedDateTime() {
        return Optional.ofNullable(publishedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publishedDateTime
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“When the template was published”</i>
     * 
     * @param publishedDateTime
     *            new value of {@code publishedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publishedDateTime} field changed
     */
    public DeviceManagementTemplate withPublishedDateTime(OffsetDateTime publishedDateTime) {
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = changedFields.add("publishedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementTemplate");
        _x.publishedDateTime = publishedDateTime;
        return _x;
    }

    /**
     * <i>“Collection of all settings this template has”</i>
     * 
     * @return navigational property settings
     */
    @NavigationProperty(name="settings")
    @JsonIgnore
    public DeviceManagementSettingInstanceCollectionRequest getSettings() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("settings"));
    }

    /**
     * <i>“Collection of setting categories within the template”</i>
     * 
     * @return navigational property categories
     */
    @NavigationProperty(name="categories")
    @JsonIgnore
    public DeviceManagementTemplateSettingCategoryCollectionRequest getCategories() {
        return new DeviceManagementTemplateSettingCategoryCollectionRequest(
                        contextPath.addSegment("categories"));
    }

    /**
     * <i>“Collection of templates this template can migrate to”</i>
     * 
     * @return navigational property migratableTo
     */
    @NavigationProperty(name="migratableTo")
    @JsonIgnore
    public DeviceManagementTemplateCollectionRequest getMigratableTo() {
        return new DeviceManagementTemplateCollectionRequest(
                        contextPath.addSegment("migratableTo"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementTemplate _copy() {
        DeviceManagementTemplate _x = new DeviceManagementTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.versionInfo = versionInfo;
        _x.isDeprecated = isDeprecated;
        _x.intentCount = intentCount;
        _x.templateType = templateType;
        _x.platformType = platformType;
        _x.templateSubtype = templateSubtype;
        _x.publishedDateTime = publishedDateTime;
        return _x;
    }

    @Action(name = "createInstance")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeviceManagementIntent> createInstance(String displayName, String description, List<DeviceManagementSettingInstance> settingsDelta, List<String> roleScopeTagIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("description", "Edm.String", Checks.checkIsAscii(description))
            .put("settingsDelta", "Collection(microsoft.graph.deviceManagementSettingInstance)", settingsDelta)
            .put("roleScopeTagIds", "Collection(Edm.String)", Checks.checkIsAscii(roleScopeTagIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeviceManagementIntent>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createInstance"), DeviceManagementIntent.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "compare")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementSettingComparison> compare(String templateId) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("templateId", "Edm.String", Checks.checkIsAscii(templateId))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.compare"), DeviceManagementSettingComparison.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("versionInfo=");
        b.append(this.versionInfo);
        b.append(", ");
        b.append("isDeprecated=");
        b.append(this.isDeprecated);
        b.append(", ");
        b.append("intentCount=");
        b.append(this.intentCount);
        b.append(", ");
        b.append("templateType=");
        b.append(this.templateType);
        b.append(", ");
        b.append("platformType=");
        b.append(this.platformType);
        b.append(", ");
        b.append("templateSubtype=");
        b.append(this.templateSubtype);
        b.append(", ");
        b.append("publishedDateTime=");
        b.append(this.publishedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
