package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“A setting instance representing a string value”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementStringSettingInstance extends DeviceManagementSettingInstance implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementStringSettingInstance";
    }

    @JsonProperty("value")
    protected String value;

    protected DeviceManagementStringSettingInstance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementStringSettingInstance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String definitionId;
        private String valueJson;
        private String value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder definitionId(String definitionId) {
            this.definitionId = definitionId;
            this.changedFields = changedFields.add("definitionId");
            return this;
        }

        public Builder valueJson(String valueJson) {
            this.valueJson = valueJson;
            this.changedFields = changedFields.add("valueJson");
            return this;
        }

        /**
         * <i>“The string value”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public DeviceManagementStringSettingInstance build() {
            DeviceManagementStringSettingInstance _x = new DeviceManagementStringSettingInstance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementStringSettingInstance";
            _x.id = id;
            _x.definitionId = definitionId;
            _x.valueJson = valueJson;
            _x.value = value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The string value”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The string value”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public DeviceManagementStringSettingInstance withValue(String value) {
        DeviceManagementStringSettingInstance _x = _copy();
        _x.changedFields = changedFields.add("value");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementStringSettingInstance");
        _x.value = value;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementStringSettingInstance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementStringSettingInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementStringSettingInstance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementStringSettingInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementStringSettingInstance _copy() {
        DeviceManagementStringSettingInstance _x = new DeviceManagementStringSettingInstance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.definitionId = definitionId;
        _x.valueJson = valueJson;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementStringSettingInstance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("definitionId=");
        b.append(this.definitionId);
        b.append(", ");
        b.append("valueJson=");
        b.append(this.valueJson);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
