package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Base type for a setting instance”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "definitionId", 
    "valueJson"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingInstance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingInstance";
    }

    @JsonProperty("definitionId")
    protected String definitionId;

    @JsonProperty("valueJson")
    protected String valueJson;

    protected DeviceManagementSettingInstance() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The ID of the setting definition for this instance”</i>
     * 
     * @return property definitionId
     */
    @Property(name="definitionId")
    @JsonIgnore
    public Optional<String> getDefinitionId() {
        return Optional.ofNullable(definitionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code definitionId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The ID of the setting definition for this instance”</i>
     * 
     * @param definitionId
     *            new value of {@code definitionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code definitionId} field changed
     */
    public DeviceManagementSettingInstance withDefinitionId(String definitionId) {
        DeviceManagementSettingInstance _x = _copy();
        _x.changedFields = changedFields.add("definitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingInstance");
        _x.definitionId = definitionId;
        return _x;
    }

    /**
     * <i>“JSON representation of the value”</i>
     * 
     * @return property valueJson
     */
    @Property(name="valueJson")
    @JsonIgnore
    public Optional<String> getValueJson() {
        return Optional.ofNullable(valueJson);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code valueJson} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“JSON representation of the value”</i>
     * 
     * @param valueJson
     *            new value of {@code valueJson} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code valueJson} field changed
     */
    public DeviceManagementSettingInstance withValueJson(String valueJson) {
        DeviceManagementSettingInstance _x = _copy();
        _x.changedFields = changedFields.add("valueJson");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingInstance");
        _x.valueJson = valueJson;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementSettingInstance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementSettingInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementSettingInstance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementSettingInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementSettingInstance _copy() {
        DeviceManagementSettingInstance _x = new DeviceManagementSettingInstance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.definitionId = definitionId;
        _x.valueJson = valueJson;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingInstance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("definitionId=");
        b.append(this.definitionId);
        b.append(", ");
        b.append("valueJson=");
        b.append(this.valueJson);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
