package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementConstraint;
import odata.msgraph.client.beta.complex.DeviceManagementSettingDependency;
import odata.msgraph.client.beta.enums.DeviceManangementIntentValueType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Entity representing the defintion for a given setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "valueType", 
    "displayName", 
    "isTopLevel", 
    "description", 
    "placeholderText", 
    "documentationUrl", 
    "keywords", 
    "constraints", 
    "dependencies"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementSettingDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementSettingDefinition";
    }

    @JsonProperty("valueType")
    protected DeviceManangementIntentValueType valueType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isTopLevel")
    protected Boolean isTopLevel;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("placeholderText")
    protected String placeholderText;

    @JsonProperty("documentationUrl")
    protected String documentationUrl;

    @JsonProperty("keywords")
    protected List<String> keywords;

    @JsonProperty("keywords@nextLink")
    protected String keywordsNextLink;

    @JsonProperty("constraints")
    protected List<DeviceManagementConstraint> constraints;

    @JsonProperty("constraints@nextLink")
    protected String constraintsNextLink;

    @JsonProperty("dependencies")
    protected List<DeviceManagementSettingDependency> dependencies;

    @JsonProperty("dependencies@nextLink")
    protected String dependenciesNextLink;

    protected DeviceManagementSettingDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementSettingDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManangementIntentValueType valueType;
        private String displayName;
        private Boolean isTopLevel;
        private String description;
        private String placeholderText;
        private String documentationUrl;
        private List<String> keywords;
        private String keywordsNextLink;
        private List<DeviceManagementConstraint> constraints;
        private String constraintsNextLink;
        private List<DeviceManagementSettingDependency> dependencies;
        private String dependenciesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The data type of the value”</i>
         * 
         * @param valueType
         *            value of {@code valueType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder valueType(DeviceManangementIntentValueType valueType) {
            this.valueType = valueType;
            this.changedFields = changedFields.add("valueType");
            return this;
        }

        /**
         * <i>“The setting's display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“If the setting is top level, it can be configured without the need to be wrapped
         * in a collection or complex setting”</i>
         * 
         * @param isTopLevel
         *            value of {@code isTopLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isTopLevel(Boolean isTopLevel) {
            this.isTopLevel = isTopLevel;
            this.changedFields = changedFields.add("isTopLevel");
            return this;
        }

        /**
         * <i>“The setting's description”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Placeholder text as an example of valid input”</i>
         * 
         * @param placeholderText
         *            value of {@code placeholderText} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder placeholderText(String placeholderText) {
            this.placeholderText = placeholderText;
            this.changedFields = changedFields.add("placeholderText");
            return this;
        }

        /**
         * <i>“Url to setting documentation”</i>
         * 
         * @param documentationUrl
         *            value of {@code documentationUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            this.changedFields = changedFields.add("documentationUrl");
            return this;
        }

        /**
         * <i>“Keywords associated with the setting”</i>
         * 
         * @param keywords
         *            value of {@code keywords} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        /**
         * <i>“Keywords associated with the setting”</i>
         * 
         * @param keywords
         *            value of {@code keywords} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keywords(String... keywords) {
            return keywords(Arrays.asList(keywords));
        }

        /**
         * <i>“Keywords associated with the setting”</i>
         * 
         * @param keywordsNextLink
         *            value of {@code keywords@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keywordsNextLink(String keywordsNextLink) {
            this.keywordsNextLink = keywordsNextLink;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        /**
         * <i>“Collection of constraints for the setting value”</i>
         * 
         * @param constraints
         *            value of {@code constraints} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder constraints(List<DeviceManagementConstraint> constraints) {
            this.constraints = constraints;
            this.changedFields = changedFields.add("constraints");
            return this;
        }

        /**
         * <i>“Collection of constraints for the setting value”</i>
         * 
         * @param constraints
         *            value of {@code constraints} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder constraints(DeviceManagementConstraint... constraints) {
            return constraints(Arrays.asList(constraints));
        }

        /**
         * <i>“Collection of constraints for the setting value”</i>
         * 
         * @param constraintsNextLink
         *            value of {@code constraints@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder constraintsNextLink(String constraintsNextLink) {
            this.constraintsNextLink = constraintsNextLink;
            this.changedFields = changedFields.add("constraints");
            return this;
        }

        /**
         * <i>“Collection of dependencies on other settings”</i>
         * 
         * @param dependencies
         *            value of {@code dependencies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependencies(List<DeviceManagementSettingDependency> dependencies) {
            this.dependencies = dependencies;
            this.changedFields = changedFields.add("dependencies");
            return this;
        }

        /**
         * <i>“Collection of dependencies on other settings”</i>
         * 
         * @param dependencies
         *            value of {@code dependencies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependencies(DeviceManagementSettingDependency... dependencies) {
            return dependencies(Arrays.asList(dependencies));
        }

        /**
         * <i>“Collection of dependencies on other settings”</i>
         * 
         * @param dependenciesNextLink
         *            value of {@code dependencies@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependenciesNextLink(String dependenciesNextLink) {
            this.dependenciesNextLink = dependenciesNextLink;
            this.changedFields = changedFields.add("dependencies");
            return this;
        }

        public DeviceManagementSettingDefinition build() {
            DeviceManagementSettingDefinition _x = new DeviceManagementSettingDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementSettingDefinition";
            _x.id = id;
            _x.valueType = valueType;
            _x.displayName = displayName;
            _x.isTopLevel = isTopLevel;
            _x.description = description;
            _x.placeholderText = placeholderText;
            _x.documentationUrl = documentationUrl;
            _x.keywords = keywords;
            _x.keywordsNextLink = keywordsNextLink;
            _x.constraints = constraints;
            _x.constraintsNextLink = constraintsNextLink;
            _x.dependencies = dependencies;
            _x.dependenciesNextLink = dependenciesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The data type of the value”</i>
     * 
     * @return property valueType
     */
    @Property(name="valueType")
    @JsonIgnore
    public Optional<DeviceManangementIntentValueType> getValueType() {
        return Optional.ofNullable(valueType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code valueType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The data type of the value”</i>
     * 
     * @param valueType
     *            new value of {@code valueType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code valueType} field changed
     */
    public DeviceManagementSettingDefinition withValueType(DeviceManangementIntentValueType valueType) {
        DeviceManagementSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("valueType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingDefinition");
        _x.valueType = valueType;
        return _x;
    }

    /**
     * <i>“The setting's display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The setting's display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementSettingDefinition withDisplayName(String displayName) {
        DeviceManagementSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingDefinition");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“If the setting is top level, it can be configured without the need to be wrapped
     * in a collection or complex setting”</i>
     * 
     * @return property isTopLevel
     */
    @Property(name="isTopLevel")
    @JsonIgnore
    public Optional<Boolean> getIsTopLevel() {
        return Optional.ofNullable(isTopLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isTopLevel} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“If the setting is top level, it can be configured without the need to be wrapped
     * in a collection or complex setting”</i>
     * 
     * @param isTopLevel
     *            new value of {@code isTopLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isTopLevel} field changed
     */
    public DeviceManagementSettingDefinition withIsTopLevel(Boolean isTopLevel) {
        DeviceManagementSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("isTopLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingDefinition");
        _x.isTopLevel = isTopLevel;
        return _x;
    }

    /**
     * <i>“The setting's description”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The setting's description”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementSettingDefinition withDescription(String description) {
        DeviceManagementSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingDefinition");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Placeholder text as an example of valid input”</i>
     * 
     * @return property placeholderText
     */
    @Property(name="placeholderText")
    @JsonIgnore
    public Optional<String> getPlaceholderText() {
        return Optional.ofNullable(placeholderText);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code placeholderText}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Placeholder text as an example of valid input”</i>
     * 
     * @param placeholderText
     *            new value of {@code placeholderText} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code placeholderText} field changed
     */
    public DeviceManagementSettingDefinition withPlaceholderText(String placeholderText) {
        DeviceManagementSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("placeholderText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingDefinition");
        _x.placeholderText = placeholderText;
        return _x;
    }

    /**
     * <i>“Url to setting documentation”</i>
     * 
     * @return property documentationUrl
     */
    @Property(name="documentationUrl")
    @JsonIgnore
    public Optional<String> getDocumentationUrl() {
        return Optional.ofNullable(documentationUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code documentationUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Url to setting documentation”</i>
     * 
     * @param documentationUrl
     *            new value of {@code documentationUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code documentationUrl} field changed
     */
    public DeviceManagementSettingDefinition withDocumentationUrl(String documentationUrl) {
        DeviceManagementSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("documentationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementSettingDefinition");
        _x.documentationUrl = documentationUrl;
        return _x;
    }

    /**
     * <i>“Keywords associated with the setting”</i>
     * 
     * @return property keywords
     */
    @Property(name="keywords")
    @JsonIgnore
    public CollectionPage<String> getKeywords() {
        return new CollectionPage<String>(contextPath, String.class, keywords, Optional.ofNullable(keywordsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Keywords associated with the setting”</i>
     * 
     * @return property keywords
     */
    @Property(name="keywords")
    @JsonIgnore
    public CollectionPage<String> getKeywords(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, keywords, Optional.ofNullable(keywordsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Collection of constraints for the setting value”</i>
     * 
     * @return property constraints
     */
    @Property(name="constraints")
    @JsonIgnore
    public CollectionPage<DeviceManagementConstraint> getConstraints() {
        return new CollectionPage<DeviceManagementConstraint>(contextPath, DeviceManagementConstraint.class, constraints, Optional.ofNullable(constraintsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of constraints for the setting value”</i>
     * 
     * @return property constraints
     */
    @Property(name="constraints")
    @JsonIgnore
    public CollectionPage<DeviceManagementConstraint> getConstraints(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConstraint>(contextPath, DeviceManagementConstraint.class, constraints, Optional.ofNullable(constraintsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Collection of dependencies on other settings”</i>
     * 
     * @return property dependencies
     */
    @Property(name="dependencies")
    @JsonIgnore
    public CollectionPage<DeviceManagementSettingDependency> getDependencies() {
        return new CollectionPage<DeviceManagementSettingDependency>(contextPath, DeviceManagementSettingDependency.class, dependencies, Optional.ofNullable(dependenciesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of dependencies on other settings”</i>
     * 
     * @return property dependencies
     */
    @Property(name="dependencies")
    @JsonIgnore
    public CollectionPage<DeviceManagementSettingDependency> getDependencies(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementSettingDependency>(contextPath, DeviceManagementSettingDependency.class, dependencies, Optional.ofNullable(dependenciesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementSettingDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementSettingDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementSettingDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementSettingDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementSettingDefinition _copy() {
        DeviceManagementSettingDefinition _x = new DeviceManagementSettingDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.valueType = valueType;
        _x.displayName = displayName;
        _x.isTopLevel = isTopLevel;
        _x.description = description;
        _x.placeholderText = placeholderText;
        _x.documentationUrl = documentationUrl;
        _x.keywords = keywords;
        _x.constraints = constraints;
        _x.dependencies = dependencies;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementSettingDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("valueType=");
        b.append(this.valueType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isTopLevel=");
        b.append(this.isTopLevel);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("placeholderText=");
        b.append(this.placeholderText);
        b.append(", ");
        b.append("documentationUrl=");
        b.append(this.documentationUrl);
        b.append(", ");
        b.append("keywords=");
        b.append(this.keywords);
        b.append(", ");
        b.append("constraints=");
        b.append(this.constraints);
        b.append(", ");
        b.append("dependencies=");
        b.append(this.dependencies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
