package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.collection.request.DeviceManagementCachedReportConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExportJobCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementReportScheduleCollectionRequest;


/**
 * <i>“Singleton entity that acts as a container for all reports functionality.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementReports extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementReports";
    }

    protected DeviceManagementReports() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementReports() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public DeviceManagementReports build() {
            DeviceManagementReports _x = new DeviceManagementReports();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementReports";
            _x.id = id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Entity representing the configuration of a cached report”</i>
     * 
     * @return navigational property cachedReportConfigurations
     */
    @NavigationProperty(name="cachedReportConfigurations")
    @JsonIgnore
    public DeviceManagementCachedReportConfigurationCollectionRequest getCachedReportConfigurations() {
        return new DeviceManagementCachedReportConfigurationCollectionRequest(
                        contextPath.addSegment("cachedReportConfigurations"));
    }

    /**
     * <i>“Entity representing a job to export a report”</i>
     * 
     * @return navigational property exportJobs
     */
    @NavigationProperty(name="exportJobs")
    @JsonIgnore
    public DeviceManagementExportJobCollectionRequest getExportJobs() {
        return new DeviceManagementExportJobCollectionRequest(
                        contextPath.addSegment("exportJobs"));
    }

    /**
     * <i>“Entity representing a schedule for which reports are delivered”</i>
     * 
     * @return navigational property reportSchedules
     */
    @NavigationProperty(name="reportSchedules")
    @JsonIgnore
    public DeviceManagementReportScheduleCollectionRequest getReportSchedules() {
        return new DeviceManagementReportScheduleCollectionRequest(
                        contextPath.addSegment("reportSchedules"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementReports patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementReports _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementReports put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementReports _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementReports _copy() {
        DeviceManagementReports _x = new DeviceManagementReports();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        return _x;
    }

    @Action(name = "getActiveMalwareReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getActiveMalwareReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActiveMalwareReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getDeviceNonComplianceReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getDeviceNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getDeviceNonComplianceReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getPolicyNonComplianceReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getPolicyNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPolicyNonComplianceReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getPolicyNonComplianceMetadata")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getPolicyNonComplianceMetadata(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPolicyNonComplianceMetadata"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getPolicyNonComplianceSummaryReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getPolicyNonComplianceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPolicyNonComplianceSummaryReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getSettingNonComplianceReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getSettingNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSettingNonComplianceReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getReportFilters")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getReportFilters(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getReportFilters"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getHistoricalReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getHistoricalReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getHistoricalReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getCachedReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getCachedReport(String id, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCachedReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getWindowsUpdateAlertSummaryReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getWindowsUpdateAlertSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getWindowsUpdateAlertSummaryReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getWindowsUpdateAlertsPerPolicyPerDeviceReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getWindowsUpdateAlertsPerPolicyPerDeviceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getWindowsUpdateAlertsPerPolicyPerDeviceReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementReports[");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
