package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementReportFileFormat;
import odata.msgraph.client.beta.enums.DeviceManagementScheduledReportRecurrence;


/**
 * <i>“Entity representing a schedule for which reports are delivered”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "reportScheduleName", 
    "subject", 
    "emails", 
    "recurrence", 
    "startDateTime", 
    "endDateTime", 
    "userId", 
    "reportName", 
    "filter", 
    "select", 
    "orderBy", 
    "format"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementReportSchedule extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementReportSchedule";
    }

    @JsonProperty("reportScheduleName")
    protected String reportScheduleName;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("emails")
    protected List<String> emails;

    @JsonProperty("emails@nextLink")
    protected String emailsNextLink;

    @JsonProperty("recurrence")
    protected DeviceManagementScheduledReportRecurrence recurrence;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("reportName")
    protected String reportName;

    @JsonProperty("filter")
    protected String filter;

    @JsonProperty("select")
    protected List<String> select;

    @JsonProperty("select@nextLink")
    protected String selectNextLink;

    @JsonProperty("orderBy")
    protected List<String> orderBy;

    @JsonProperty("orderBy@nextLink")
    protected String orderByNextLink;

    @JsonProperty("format")
    protected DeviceManagementReportFileFormat format;

    protected DeviceManagementReportSchedule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementReportSchedule() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String reportScheduleName;
        private String subject;
        private List<String> emails;
        private String emailsNextLink;
        private DeviceManagementScheduledReportRecurrence recurrence;
        private OffsetDateTime startDateTime;
        private OffsetDateTime endDateTime;
        private String userId;
        private String reportName;
        private String filter;
        private List<String> select;
        private String selectNextLink;
        private List<String> orderBy;
        private String orderByNextLink;
        private DeviceManagementReportFileFormat format;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Name of the schedule”</i>
         * 
         * @param reportScheduleName
         *            value of {@code reportScheduleName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reportScheduleName(String reportScheduleName) {
            this.reportScheduleName = reportScheduleName;
            this.changedFields = changedFields.add("reportScheduleName");
            return this;
        }

        /**
         * <i>“Subject of the scheduled reports that are delivered”</i>
         * 
         * @param subject
         *            value of {@code subject} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        /**
         * <i>“Emails to which the scheduled reports are delivered”</i>
         * 
         * @param emails
         *            value of {@code emails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emails(List<String> emails) {
            this.emails = emails;
            this.changedFields = changedFields.add("emails");
            return this;
        }

        /**
         * <i>“Emails to which the scheduled reports are delivered”</i>
         * 
         * @param emails
         *            value of {@code emails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emails(String... emails) {
            return emails(Arrays.asList(emails));
        }

        /**
         * <i>“Emails to which the scheduled reports are delivered”</i>
         * 
         * @param emailsNextLink
         *            value of {@code emails@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailsNextLink(String emailsNextLink) {
            this.emailsNextLink = emailsNextLink;
            this.changedFields = changedFields.add("emails");
            return this;
        }

        /**
         * <i>“Frequency of scheduled report delivery”</i>
         * 
         * @param recurrence
         *            value of {@code recurrence} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recurrence(DeviceManagementScheduledReportRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        /**
         * <i>“Time that the delivery of the scheduled reports starts”</i>
         * 
         * @param startDateTime
         *            value of {@code startDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        /**
         * <i>“Time that the delivery of the scheduled reports ends”</i>
         * 
         * @param endDateTime
         *            value of {@code endDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        /**
         * <i>“The Id of the User who created the report”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        /**
         * <i>“Name of the report”</i>
         * 
         * @param reportName
         *            value of {@code reportName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reportName(String reportName) {
            this.reportName = reportName;
            this.changedFields = changedFields.add("reportName");
            return this;
        }

        /**
         * <i>“Filters applied on the report”</i>
         * 
         * @param filter
         *            value of {@code filter} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder filter(String filter) {
            this.filter = filter;
            this.changedFields = changedFields.add("filter");
            return this;
        }

        /**
         * <i>“Columns selected from the report”</i>
         * 
         * @param select
         *            value of {@code select} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder select(List<String> select) {
            this.select = select;
            this.changedFields = changedFields.add("select");
            return this;
        }

        /**
         * <i>“Columns selected from the report”</i>
         * 
         * @param select
         *            value of {@code select} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder select(String... select) {
            return select(Arrays.asList(select));
        }

        /**
         * <i>“Columns selected from the report”</i>
         * 
         * @param selectNextLink
         *            value of {@code select@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder selectNextLink(String selectNextLink) {
            this.selectNextLink = selectNextLink;
            this.changedFields = changedFields.add("select");
            return this;
        }

        /**
         * <i>“Ordering of columns in the report”</i>
         * 
         * @param orderBy
         *            value of {@code orderBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder orderBy(List<String> orderBy) {
            this.orderBy = orderBy;
            this.changedFields = changedFields.add("orderBy");
            return this;
        }

        /**
         * <i>“Ordering of columns in the report”</i>
         * 
         * @param orderBy
         *            value of {@code orderBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder orderBy(String... orderBy) {
            return orderBy(Arrays.asList(orderBy));
        }

        /**
         * <i>“Ordering of columns in the report”</i>
         * 
         * @param orderByNextLink
         *            value of {@code orderBy@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder orderByNextLink(String orderByNextLink) {
            this.orderByNextLink = orderByNextLink;
            this.changedFields = changedFields.add("orderBy");
            return this;
        }

        /**
         * <i>“Format of the scheduled report”</i>
         * 
         * @param format
         *            value of {@code format} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder format(DeviceManagementReportFileFormat format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        public DeviceManagementReportSchedule build() {
            DeviceManagementReportSchedule _x = new DeviceManagementReportSchedule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.deviceManagementReportSchedule";
            _x.id = id;
            _x.reportScheduleName = reportScheduleName;
            _x.subject = subject;
            _x.emails = emails;
            _x.emailsNextLink = emailsNextLink;
            _x.recurrence = recurrence;
            _x.startDateTime = startDateTime;
            _x.endDateTime = endDateTime;
            _x.userId = userId;
            _x.reportName = reportName;
            _x.filter = filter;
            _x.select = select;
            _x.selectNextLink = selectNextLink;
            _x.orderBy = orderBy;
            _x.orderByNextLink = orderByNextLink;
            _x.format = format;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Name of the schedule”</i>
     * 
     * @return property reportScheduleName
     */
    @Property(name="reportScheduleName")
    @JsonIgnore
    public Optional<String> getReportScheduleName() {
        return Optional.ofNullable(reportScheduleName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * reportScheduleName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Name of the schedule”</i>
     * 
     * @param reportScheduleName
     *            new value of {@code reportScheduleName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reportScheduleName} field changed
     */
    public DeviceManagementReportSchedule withReportScheduleName(String reportScheduleName) {
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = changedFields.add("reportScheduleName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReportSchedule");
        _x.reportScheduleName = reportScheduleName;
        return _x;
    }

    /**
     * <i>“Subject of the scheduled reports that are delivered”</i>
     * 
     * @return property subject
     */
    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subject} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Subject of the scheduled reports that are delivered”</i>
     * 
     * @param subject
     *            new value of {@code subject} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subject} field changed
     */
    public DeviceManagementReportSchedule withSubject(String subject) {
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReportSchedule");
        _x.subject = subject;
        return _x;
    }

    /**
     * <i>“Emails to which the scheduled reports are delivered”</i>
     * 
     * @return property emails
     */
    @Property(name="emails")
    @JsonIgnore
    public CollectionPage<String> getEmails() {
        return new CollectionPage<String>(contextPath, String.class, emails, Optional.ofNullable(emailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Emails to which the scheduled reports are delivered”</i>
     * 
     * @return property emails
     */
    @Property(name="emails")
    @JsonIgnore
    public CollectionPage<String> getEmails(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, emails, Optional.ofNullable(emailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Frequency of scheduled report delivery”</i>
     * 
     * @return property recurrence
     */
    @Property(name="recurrence")
    @JsonIgnore
    public Optional<DeviceManagementScheduledReportRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code recurrence} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Frequency of scheduled report delivery”</i>
     * 
     * @param recurrence
     *            new value of {@code recurrence} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recurrence} field changed
     */
    public DeviceManagementReportSchedule withRecurrence(DeviceManagementScheduledReportRecurrence recurrence) {
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = changedFields.add("recurrence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReportSchedule");
        _x.recurrence = recurrence;
        return _x;
    }

    /**
     * <i>“Time that the delivery of the scheduled reports starts”</i>
     * 
     * @return property startDateTime
     */
    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Time that the delivery of the scheduled reports starts”</i>
     * 
     * @param startDateTime
     *            new value of {@code startDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDateTime} field changed
     */
    public DeviceManagementReportSchedule withStartDateTime(OffsetDateTime startDateTime) {
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReportSchedule");
        _x.startDateTime = startDateTime;
        return _x;
    }

    /**
     * <i>“Time that the delivery of the scheduled reports ends”</i>
     * 
     * @return property endDateTime
     */
    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code endDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Time that the delivery of the scheduled reports ends”</i>
     * 
     * @param endDateTime
     *            new value of {@code endDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endDateTime} field changed
     */
    public DeviceManagementReportSchedule withEndDateTime(OffsetDateTime endDateTime) {
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReportSchedule");
        _x.endDateTime = endDateTime;
        return _x;
    }

    /**
     * <i>“The Id of the User who created the report”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Id of the User who created the report”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public DeviceManagementReportSchedule withUserId(String userId) {
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReportSchedule");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“Name of the report”</i>
     * 
     * @return property reportName
     */
    @Property(name="reportName")
    @JsonIgnore
    public Optional<String> getReportName() {
        return Optional.ofNullable(reportName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code reportName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the report”</i>
     * 
     * @param reportName
     *            new value of {@code reportName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reportName} field changed
     */
    public DeviceManagementReportSchedule withReportName(String reportName) {
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = changedFields.add("reportName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReportSchedule");
        _x.reportName = reportName;
        return _x;
    }

    /**
     * <i>“Filters applied on the report”</i>
     * 
     * @return property filter
     */
    @Property(name="filter")
    @JsonIgnore
    public Optional<String> getFilter() {
        return Optional.ofNullable(filter);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code filter} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Filters applied on the report”</i>
     * 
     * @param filter
     *            new value of {@code filter} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code filter} field changed
     */
    public DeviceManagementReportSchedule withFilter(String filter) {
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = changedFields.add("filter");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReportSchedule");
        _x.filter = filter;
        return _x;
    }

    /**
     * <i>“Columns selected from the report”</i>
     * 
     * @return property select
     */
    @Property(name="select")
    @JsonIgnore
    public CollectionPage<String> getSelect() {
        return new CollectionPage<String>(contextPath, String.class, select, Optional.ofNullable(selectNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Columns selected from the report”</i>
     * 
     * @return property select
     */
    @Property(name="select")
    @JsonIgnore
    public CollectionPage<String> getSelect(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, select, Optional.ofNullable(selectNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Ordering of columns in the report”</i>
     * 
     * @return property orderBy
     */
    @Property(name="orderBy")
    @JsonIgnore
    public CollectionPage<String> getOrderBy() {
        return new CollectionPage<String>(contextPath, String.class, orderBy, Optional.ofNullable(orderByNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Ordering of columns in the report”</i>
     * 
     * @return property orderBy
     */
    @Property(name="orderBy")
    @JsonIgnore
    public CollectionPage<String> getOrderBy(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, orderBy, Optional.ofNullable(orderByNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Format of the scheduled report”</i>
     * 
     * @return property format
     */
    @Property(name="format")
    @JsonIgnore
    public Optional<DeviceManagementReportFileFormat> getFormat() {
        return Optional.ofNullable(format);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code format} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Format of the scheduled report”</i>
     * 
     * @param format
     *            new value of {@code format} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code format} field changed
     */
    public DeviceManagementReportSchedule withFormat(DeviceManagementReportFileFormat format) {
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = changedFields.add("format");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementReportSchedule");
        _x.format = format;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementReportSchedule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementReportSchedule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementReportSchedule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementReportSchedule _copy() {
        DeviceManagementReportSchedule _x = new DeviceManagementReportSchedule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportScheduleName = reportScheduleName;
        _x.subject = subject;
        _x.emails = emails;
        _x.recurrence = recurrence;
        _x.startDateTime = startDateTime;
        _x.endDateTime = endDateTime;
        _x.userId = userId;
        _x.reportName = reportName;
        _x.filter = filter;
        _x.select = select;
        _x.orderBy = orderBy;
        _x.format = format;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementReportSchedule[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportScheduleName=");
        b.append(this.reportScheduleName);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("emails=");
        b.append(this.emails);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("reportName=");
        b.append(this.reportName);
        b.append(", ");
        b.append("filter=");
        b.append(this.filter);
        b.append(", ");
        b.append("select=");
        b.append(this.select);
        b.append(", ");
        b.append("orderBy=");
        b.append(this.orderBy);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
